/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.MetricsConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.metrics.plugins.SimpleMetricsPlugin;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Before;
import org.junit.Test;

public class SharedStoreMetricsLeakTest
extends ClusterTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.setupServers();
    }

    private void setupServers() throws Exception {
        this.setupLiveServer(0, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty(), false);
        this.setupBackupServer(1, 0, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty());
        this.getServer(0).getConfiguration().setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreMasterPolicyConfiguration().setFailoverOnServerShutdown(true));
        this.getServer(0).getConfiguration().setMetricsConfiguration(new MetricsConfiguration().setJvmThread(false).setJvmGc(false).setJvmMemory(false).setPlugin(new SimpleMetricsPlugin().init(null)));
        this.getServer(1).getConfiguration().setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreSlavePolicyConfiguration().setFailoverOnServerShutdown(true).setAllowFailBack(true));
        this.getServer(1).getConfiguration().setMetricsConfiguration(new MetricsConfiguration().setJvmThread(false).setJvmGc(false).setJvmMemory(false).setPlugin(new SimpleMetricsPlugin().init(null)));
        this.setupClusterConnection("cluster", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
    }

    private boolean isNetty() {
        return true;
    }

    @Test
    public void testForMeterLeaks() throws Exception {
        ActiveMQServer live = this.getServer(0);
        ActiveMQServer backup = this.getServer(1);
        live.start();
        SharedStoreMetricsLeakTest.assertTrue((boolean)live.waitForActivation(5L, TimeUnit.SECONDS));
        backup.start();
        SharedStoreMetricsLeakTest.assertFalse((boolean)backup.waitForActivation(1L, TimeUnit.SECONDS));
        long baseline = backup.getMetricsManager().getMeterRegistry().getMeters().size();
        live.stop();
        SharedStoreMetricsLeakTest.assertTrue((boolean)backup.waitForActivation(5L, TimeUnit.SECONDS));
        Wait.assertTrue(() -> (long)backup.getMetricsManager().getMeterRegistry().getMeters().size() > baseline, (long)2000L, (long)100L);
        live.start();
        SharedStoreMetricsLeakTest.assertTrue((boolean)live.waitForActivation(5L, TimeUnit.SECONDS));
        Wait.assertTrue(() -> (long)backup.getMetricsManager().getMeterRegistry().getMeters().size() == baseline, (long)2000L, (long)100L);
        live.stop();
        backup.stop();
    }
}

