/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.replication;

import java.util.Arrays;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.tests.integration.replication.ReplicationOrderTest;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PluggableQuorumReplicationOrderTest
extends ReplicationOrderTest {
    @Parameterized.Parameter
    public boolean useNetty;

    @Parameterized.Parameters(name="useNetty={0}")
    public static Iterable<Object[]> getParams() {
        return Arrays.asList({false}, {true});
    }

    @Override
    protected void createConfigs() throws Exception {
        this.createPluggableReplicatedConfigs();
    }

    @Override
    protected void setupHAPolicyConfiguration() {
        ((ReplicationBackupPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setMaxSavedReplicatedJournalsSize(2).setAllowFailBack(true);
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return this.useNetty ? this.getNettyAcceptorTransportConfiguration(live) : super.getAcceptorTransportConfiguration(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return this.useNetty ? this.getNettyConnectorTransportConfiguration(live) : super.getConnectorTransportConfiguration(live);
    }
}

