/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfigurationParser;
import org.infinispan.persistence.jdbc.common.configuration.Attribute;
import org.infinispan.persistence.jdbc.common.configuration.Element;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfigurationBuilder;

@Namespaces(value={@Namespace(root="string-keyed-jdbc-store"), @Namespace(root="binary-keyed-jdbc-store"), @Namespace(root="mixed-keyed-jdbc-store"), @Namespace(uri="urn:infinispan:config:store:jdbc:*", root="string-keyed-jdbc-store"), @Namespace(uri="urn:infinispan:config:store:jdbc:*", root="binary-keyed-jdbc-store", until="9.0"), @Namespace(uri="urn:infinispan:config:store:jdbc:*", root="mixed-keyed-jdbc-store", until="9.0")})
public class JdbcStoreConfigurationParser
extends AbstractJdbcStoreConfigurationParser {
    static final String NAMESPACE = "urn:infinispan:config:store:jdbc:";

    public void readElement(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName((String)reader.getLocalName());
        switch (element) {
            case STRING_KEYED_JDBC_STORE: {
                this.parseStringKeyedJdbcStore(reader, builder.persistence());
                break;
            }
            case BINARY_KEYED_JDBC_STORE: 
            case MIXED_KEYED_JDBC_STORE: {
                throw new CacheConfigurationException("Binary and Mixed Keyed JDBC stores were removed in 9.0. Please use JdbcStringBasedStore instead");
            }
            default: {
                throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
            }
        }
    }

    private void parseStringKeyedJdbcStore(ConfigurationReader reader, PersistenceConfigurationBuilder persistenceBuilder) {
        JdbcStringBasedStoreConfigurationBuilder builder = new JdbcStringBasedStoreConfigurationBuilder(persistenceBuilder);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeName(i));
            if (this.handleCommonAttributes(builder, attribute, value)) continue;
            if (attribute == Attribute.KEY_TO_STRING_MAPPER) {
                builder.key2StringMapper(value);
                continue;
            }
            Parser.parseStoreAttribute((ConfigurationReader)reader, (int)i, (AbstractStoreConfigurationBuilder)builder);
        }
        while (reader.inTag()) {
            Element element = Element.forName((String)reader.getLocalName());
            if (this.handleCommonElement(builder, element, reader)) continue;
            if (element == Element.STRING_KEYED_TABLE) {
                this.parseTable(reader, builder.table());
                continue;
            }
            Parser.parseStoreElement((ConfigurationReader)reader, (StoreConfigurationBuilder)builder);
        }
        persistenceBuilder.addStore((StoreConfigurationBuilder)builder);
    }

    private void parseTable(ConfigurationReader reader, TableManipulationConfigurationBuilder<?, ?> builder) {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeName(i));
            switch (attribute) {
                case BATCH_SIZE: {
                    builder.batchSize(Integer.parseInt(value));
                    continue block7;
                }
                case CREATE_ON_START: {
                    builder.createOnStart(Boolean.parseBoolean(value));
                    continue block7;
                }
                case DROP_ON_EXIT: {
                    builder.dropOnExit(Boolean.parseBoolean(value));
                    continue block7;
                }
                case FETCH_SIZE: {
                    builder.fetchSize(Integer.parseInt(value));
                    continue block7;
                }
                case PREFIX: {
                    builder.tableNamePrefix(value);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        this.parseTableElements(reader, builder);
    }

    private void parseTableElements(ConfigurationReader reader, TableManipulationConfigurationBuilder<?, ?> builder) {
        block6: while (reader.inTag()) {
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case ID_COLUMN: {
                    Column column = this.parseTableElementAttributes(reader);
                    builder.idColumnName(column.name);
                    builder.idColumnType(column.type);
                    continue block6;
                }
                case DATA_COLUMN: {
                    Column column = this.parseTableElementAttributes(reader);
                    builder.dataColumnName(column.name);
                    builder.dataColumnType(column.type);
                    continue block6;
                }
                case TIMESTAMP_COLUMN: {
                    Column column = this.parseTableElementAttributes(reader);
                    builder.timestampColumnName(column.name);
                    builder.timestampColumnType(column.type);
                    continue block6;
                }
                case SEGMENT_COLUMN: {
                    Column column = this.parseTableElementAttributes(reader);
                    builder.segmentColumnName(column.name);
                    builder.segmentColumnType(column.type);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
        }
    }

    private Column parseTableElementAttributes(ConfigurationReader reader) {
        Column column = new Column();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    column.name = value;
                    continue block4;
                }
                case TYPE: {
                    column.type = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
        return column;
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(((Object)((Object)this)).getClass());
    }

    static class Column {
        String name;
        String type;

        Column() {
        }
    }
}

