/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.junit.Test;

public class JMSLVQTest
extends JMSClientTestSupport {
    private static final String NORMAL_QUEUE_NAME = "NORMAL";
    private static final String LVQ_QUEUE_NAME = "LVQ";
    private static final String LVQ_CUSTOM_KEY_QUEUE_NAME = "LVQ_CUSTOM_KEY_QUEUE";
    private static final String CUSTOM_KEY = "KEY";
    private JMSClientTestSupport.ConnectionSupplier AMQPConnection = () -> this.createConnection();
    private JMSClientTestSupport.ConnectionSupplier CoreConnection = () -> this.createCoreConnection();
    private JMSClientTestSupport.ConnectionSupplier OpenWireConnection = () -> this.createOpenWireConnection();

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,OPENWIRE,CORE";
    }

    @Override
    protected void addConfiguration(ActiveMQServer server) {
        server.getConfiguration().setPersistenceEnabled(false);
        server.getConfiguration().setMessageExpiryScanPeriod(1000L);
        server.getAddressSettingsRepository().addMatch(NORMAL_QUEUE_NAME, (Object)new AddressSettings());
        server.getAddressSettingsRepository().addMatch(LVQ_QUEUE_NAME, (Object)new AddressSettings().setDefaultLastValueQueue(true));
        server.getAddressSettingsRepository().addMatch(LVQ_CUSTOM_KEY_QUEUE_NAME, (Object)new AddressSettings().setDefaultLastValueQueue(true).setDefaultLastValueKey(SimpleString.toSimpleString((String)CUSTOM_KEY)));
    }

    @Override
    protected void createAddressAndQueues(ActiveMQServer server) throws Exception {
        super.createAddressAndQueues(server);
        server.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)NORMAL_QUEUE_NAME), RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(NORMAL_QUEUE_NAME).setRoutingType(RoutingType.ANYCAST));
        server.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)LVQ_QUEUE_NAME), RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(LVQ_QUEUE_NAME).setRoutingType(RoutingType.ANYCAST));
        server.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)LVQ_CUSTOM_KEY_QUEUE_NAME), RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(LVQ_CUSTOM_KEY_QUEUE_NAME).setRoutingType(RoutingType.ANYCAST));
    }

    @Test
    public void testLVQAMQPProducerAMQPConsumer() throws Exception {
        this.testLVQ(this.AMQPConnection, this.AMQPConnection);
    }

    @Test
    public void testLVQCoreProducerCoreConsumer() throws Exception {
        this.testLVQ(this.CoreConnection, this.CoreConnection);
    }

    @Test
    public void testLVQCoreProducerAMQPConsumer() throws Exception {
        this.testLVQ(this.CoreConnection, this.AMQPConnection);
    }

    @Test
    public void testLVQAMQPProducerCoreConsumer() throws Exception {
        this.testLVQ(this.AMQPConnection, this.CoreConnection);
    }

    @Test
    public void testLVQOpenWireProducerOpenWireConsumer() throws Exception {
        this.testLVQ(this.OpenWireConnection, this.OpenWireConnection);
    }

    @Test
    public void testLVQCoreProducerOpenWireConsumer() throws Exception {
        this.testLVQ(this.CoreConnection, this.OpenWireConnection);
    }

    @Test
    public void testLVQOpenWireProducerCoreConsumer() throws Exception {
        this.testLVQ(this.OpenWireConnection, this.CoreConnection);
    }

    @Test
    public void testLVQAMQPProducerOpenWireConsumer() throws Exception {
        this.testLVQ(this.AMQPConnection, this.OpenWireConnection);
    }

    @Test
    public void testLVQOpenWireProducerAMQPConsumer() throws Exception {
        this.testLVQ(this.OpenWireConnection, this.AMQPConnection);
    }

    public void testLVQ(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        this.testLVQDefaultKey(producerConnectionSupplier, consumerConnectionSupplier);
        this.testLVQCustomKey(producerConnectionSupplier, consumerConnectionSupplier);
    }

    public void testLVQDefaultKey(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        this.testLVQ(producerConnectionSupplier, consumerConnectionSupplier, LVQ_QUEUE_NAME, org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString());
    }

    public void testLVQCustomKey(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        this.testLVQ(producerConnectionSupplier, consumerConnectionSupplier, LVQ_CUSTOM_KEY_QUEUE_NAME, CUSTOM_KEY);
    }

    public void testLVQ(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName, String lastValueKey) throws Exception {
        this.sendLVQ(producerConnectionSupplier, queueName, lastValueKey);
        Thread.sleep(10L);
        this.receiveLVQ(consumerConnectionSupplier, queueName, lastValueKey);
    }

    private void receiveLVQ(JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName, String lastValueKey) throws JMSException {
        try (Connection consumerConnection = consumerConnectionSupplier.createConnection();){
            Session consumerSession = consumerConnection.createSession(false, 1);
            Queue consumerQueue = consumerSession.createQueue(queueName);
            MessageConsumer consumer = consumerSession.createConsumer((Destination)consumerQueue);
            TextMessage msg = (TextMessage)consumer.receive(1000L);
            JMSLVQTest.assertNotNull((Object)msg);
            JMSLVQTest.assertEquals((Object)CUSTOM_KEY, (Object)msg.getStringProperty(lastValueKey));
            JMSLVQTest.assertEquals((Object)"how are you", (Object)msg.getText());
            consumer.close();
        }
    }

    private void sendLVQ(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, String queueName, String lastValueKey) throws JMSException {
        try (Connection producerConnection = producerConnectionSupplier.createConnection();){
            Session producerSession = producerConnection.createSession(false, 1);
            Queue queue1 = producerSession.createQueue(queueName);
            MessageProducer p = producerSession.createProducer(null);
            TextMessage message1 = producerSession.createTextMessage();
            message1.setStringProperty(lastValueKey, CUSTOM_KEY);
            message1.setText("hello");
            p.send((Destination)queue1, (Message)message1);
            TextMessage message2 = producerSession.createTextMessage();
            message2.setStringProperty(lastValueKey, CUSTOM_KEY);
            message2.setText("how are you");
            p.send((Destination)queue1, (Message)message2);
        }
    }
}

