/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.interop;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.apache.qpid.jms.JmsTopic;
import org.junit.Assert;
import org.junit.Test;

public class AmqpCoreTest
extends JMSClientTestSupport {
    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,OPENWIRE,CORE";
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testMultipleCoreReceiving() throws Exception {
        int total = 100;
        try (Connection coreJmsConn = this.createCoreConnection();){
            Session session = coreJmsConn.createSession(false, 1);
            ClientSession coreSession = ((ActiveMQSession)session).getCoreSession();
            coreSession.createQueue(new QueueConfiguration("exampleQueue1").setAddress("exampleQueueAddress"));
            coreSession.createQueue(new QueueConfiguration("exampleQueue2").setAddress("exampleQueueAddress"));
            coreSession.createQueue(new QueueConfiguration("exampleQueue3").setAddress("exampleQueueAddress"));
            ClientConsumer consumer1 = coreSession.createConsumer("exampleQueue1");
            CoreMessageHandler handler1 = new CoreMessageHandler(1);
            consumer1.setMessageHandler((MessageHandler)handler1);
            ClientConsumer consumer2 = coreSession.createConsumer("exampleQueue2");
            CoreMessageHandler handler2 = new CoreMessageHandler(2);
            consumer2.setMessageHandler((MessageHandler)handler2);
            CoreMessageHandler handler3 = new CoreMessageHandler(3);
            ClientConsumer consumer3 = coreSession.createConsumer("exampleQueue3");
            consumer3.setMessageHandler((MessageHandler)handler3);
            this.sendAmqpMessages("exampleQueueAddress", 100);
            handler1.assertMessagesReceived(100);
            handler2.assertMessagesReceived(100);
            handler3.assertMessagesReceived(100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAmqpMessages(String address, int total) throws Exception {
        JmsConnectionFactory cfAMQP = new JmsConnectionFactory("amqp://127.0.0.1:5672");
        try (Connection connectionAMQP = cfAMQP.createConnection();){
            connectionAMQP.start();
            Session sessionAMQP = connectionAMQP.createSession(false, 1);
            MessageProducer sender = sessionAMQP.createProducer((Destination)new JmsTopic(address));
            for (int i = 0; i < total; ++i) {
                sender.send((Message)sessionAMQP.createTextMessage("hello"));
            }
        }
    }

    private class CoreMessageHandler
    implements MessageHandler {
        int id;
        AtomicInteger numMsg = new AtomicInteger();
        AtomicBoolean zeroLen = new AtomicBoolean();

        CoreMessageHandler(int id) {
            this.id = id;
        }

        public void onMessage(ClientMessage message) {
            AmqpCoreTest.this.instanceLog.debug((Object)("received: " + message.getBodySize()));
            if (message.getBodySize() == 0) {
                AmqpCoreTest.this.instanceLog.debug((Object)"xxx found zero len message!");
                this.zeroLen.set(true);
            }
            AmqpCoreTest.this.instanceLog.debug((Object)("[receiver " + this.id + "] recieved: " + this.numMsg.incrementAndGet()));
        }

        public void assertMessagesReceived(int num) throws Exception {
            Wait.assertEquals((int)num, this.numMsg::get, (long)30000L);
            Assert.assertFalse((boolean)this.zeroLen.get());
        }
    }
}

