/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.balancing;

import jakarta.jms.ConnectionFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQSslConnectionFactory;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.balancing.BrokerBalancerConfiguration;
import org.apache.activemq.artemis.core.config.balancing.PolicyConfiguration;
import org.apache.activemq.artemis.core.config.balancing.PoolConfiguration;
import org.apache.activemq.artemis.core.server.balancing.targets.TargetKey;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.qpid.jms.JmsConnectionFactory;

public class BalancingTestBase
extends ClusterTestBase {
    protected static final String AMQP_PROTOCOL = "AMQP";
    protected static final String CORE_PROTOCOL = "CORE";
    protected static final String OPENWIRE_PROTOCOL = "OPENWIRE";
    protected static final String CLUSTER_POOL = "CLUSTER";
    protected static final String DISCOVERY_POOL = "DISCOVERY";
    protected static final String STATIC_POOL = "STATIC";
    protected static final String BROKER_BALANCER_NAME = "bb1";
    protected static final String DEFAULT_CONNECTOR_NAME = "DEFAULT";
    protected static final String GROUP_ADDRESS = ActiveMQTestBase.getUDPDiscoveryAddress();
    protected static final int GROUP_PORT = ActiveMQTestBase.getUDPDiscoveryPort();
    protected static final int MULTIPLE_TARGETS = 3;

    protected TransportConfiguration getDefaultServerAcceptor(int node) {
        return (TransportConfiguration)this.getServer(node).getConfiguration().getAcceptorConfigurations().stream().findFirst().get();
    }

    protected TransportConfiguration getDefaultServerConnector(int node) {
        Map connectorConfigurations = this.getServer(node).getConfiguration().getConnectorConfigurations();
        TransportConfiguration connector = (TransportConfiguration)connectorConfigurations.get(DEFAULT_CONNECTOR_NAME);
        return connector != null ? connector : (TransportConfiguration)connectorConfigurations.values().stream().findFirst().get();
    }

    protected TransportConfiguration setupDefaultServerConnector(int node) {
        TransportConfiguration defaultServerConnector = this.getDefaultServerConnector(node);
        if (!defaultServerConnector.getName().equals(DEFAULT_CONNECTOR_NAME)) {
            defaultServerConnector = new TransportConfiguration(defaultServerConnector.getFactoryClassName(), defaultServerConnector.getParams(), DEFAULT_CONNECTOR_NAME, defaultServerConnector.getExtraParams());
            this.getServer(node).getConfiguration().getConnectorConfigurations().put(DEFAULT_CONNECTOR_NAME, defaultServerConnector);
        }
        return defaultServerConnector;
    }

    protected void setupBalancerServerWithCluster(int node, TargetKey targetKey, String policyName, Map<String, String> properties, boolean localTargetEnabled, String localTargetFilter, int quorumSize, String clusterConnection) {
        Configuration configuration = this.getServer(node).getConfiguration();
        BrokerBalancerConfiguration brokerBalancerConfiguration = new BrokerBalancerConfiguration().setName(BROKER_BALANCER_NAME);
        this.setupDefaultServerConnector(node);
        brokerBalancerConfiguration.setTargetKey(targetKey).setLocalTargetFilter(localTargetFilter).setPoolConfiguration(new PoolConfiguration().setCheckPeriod(1000).setQuorumSize(quorumSize).setLocalTargetEnabled(localTargetEnabled).setClusterConnection(clusterConnection)).setPolicyConfiguration(new PolicyConfiguration().setName(policyName).setProperties(properties));
        configuration.setBalancerConfigurations(Collections.singletonList(brokerBalancerConfiguration));
        TransportConfiguration acceptor = this.getDefaultServerAcceptor(node);
        acceptor.getParams().put("redirect-to", BROKER_BALANCER_NAME);
    }

    protected void setupBalancerServerWithDiscovery(int node, TargetKey targetKey, String policyName, Map<String, String> properties, boolean localTargetEnabled, String localTargetFilter, int quorumSize) {
        Configuration configuration = this.getServer(node).getConfiguration();
        BrokerBalancerConfiguration brokerBalancerConfiguration = new BrokerBalancerConfiguration().setName(BROKER_BALANCER_NAME);
        this.setupDefaultServerConnector(node);
        brokerBalancerConfiguration.setTargetKey(targetKey).setLocalTargetFilter(localTargetFilter).setPoolConfiguration(new PoolConfiguration().setCheckPeriod(1000).setQuorumSize(quorumSize).setLocalTargetEnabled(localTargetEnabled).setDiscoveryGroupName("dg1")).setPolicyConfiguration(new PolicyConfiguration().setName(policyName).setProperties(properties));
        configuration.setBalancerConfigurations(Collections.singletonList(brokerBalancerConfiguration));
        TransportConfiguration acceptor = this.getDefaultServerAcceptor(node);
        acceptor.getParams().put("redirect-to", BROKER_BALANCER_NAME);
    }

    protected void setupBalancerServerWithStaticConnectors(int node, TargetKey targetKey, String policyName, Map<String, String> properties, boolean localTargetEnabled, String localTargetFilter, int quorumSize, int ... targetNodes) {
        Configuration configuration = this.getServer(node).getConfiguration();
        BrokerBalancerConfiguration brokerBalancerConfiguration = new BrokerBalancerConfiguration().setName(BROKER_BALANCER_NAME);
        this.setupDefaultServerConnector(node);
        ArrayList<String> staticConnectors = new ArrayList<String>();
        for (int targetNode : targetNodes) {
            TransportConfiguration connector = this.getDefaultServerConnector(targetNode);
            configuration.getConnectorConfigurations().put(connector.getName(), connector);
            staticConnectors.add(connector.getName());
        }
        brokerBalancerConfiguration.setTargetKey(targetKey).setLocalTargetFilter(localTargetFilter).setPoolConfiguration(new PoolConfiguration().setCheckPeriod(1000).setQuorumSize(quorumSize).setLocalTargetEnabled(localTargetEnabled).setStaticConnectors(staticConnectors)).setPolicyConfiguration(new PolicyConfiguration().setName(policyName).setProperties(properties));
        configuration.setBalancerConfigurations(Collections.singletonList(brokerBalancerConfiguration));
        TransportConfiguration acceptor = this.getDefaultServerAcceptor(node);
        acceptor.getParams().put("redirect-to", BROKER_BALANCER_NAME);
    }

    protected ConnectionFactory createFactory(String protocol, boolean sslEnabled, String host, int port, String clientID, String user, String password) throws Exception {
        switch (protocol) {
            case "CORE": {
                StringBuilder urlBuilder = new StringBuilder();
                urlBuilder.append("tcp://");
                urlBuilder.append(host);
                urlBuilder.append(":");
                urlBuilder.append(port);
                urlBuilder.append("?ha=true&reconnectAttempts=30");
                urlBuilder.append("&sniHost=");
                urlBuilder.append(host);
                if (clientID != null) {
                    urlBuilder.append("&clientID=");
                    urlBuilder.append(clientID);
                }
                if (sslEnabled) {
                    urlBuilder.append("&");
                    urlBuilder.append("sslEnabled");
                    urlBuilder.append("=");
                    urlBuilder.append(true);
                    urlBuilder.append("&");
                    urlBuilder.append("trustStorePath");
                    urlBuilder.append("=");
                    urlBuilder.append("server-ca-truststore.jks");
                    urlBuilder.append("&");
                    urlBuilder.append("trustStorePassword");
                    urlBuilder.append("=");
                    urlBuilder.append("securepass");
                }
                return new org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory(urlBuilder.toString(), user, password);
            }
            case "AMQP": {
                StringBuilder urlBuilder = new StringBuilder();
                urlBuilder.append("failover:(");
                if (sslEnabled) {
                    urlBuilder.append("amqps://");
                    urlBuilder.append(host);
                    urlBuilder.append(":");
                    urlBuilder.append(port);
                    urlBuilder.append("?transport.trustStoreLocation=");
                    urlBuilder.append(((Object)((Object)this)).getClass().getClassLoader().getResource("server-ca-truststore.jks").getFile());
                    urlBuilder.append("&transport.trustStorePassword=securepass)");
                } else {
                    urlBuilder.append("amqp://");
                    urlBuilder.append(host);
                    urlBuilder.append(":");
                    urlBuilder.append(port);
                    urlBuilder.append(")");
                }
                if (clientID != null) {
                    urlBuilder.append("?jms.clientID=");
                    urlBuilder.append(clientID);
                }
                return new JmsConnectionFactory(user, password, urlBuilder.toString());
            }
            case "OPENWIRE": {
                StringBuilder urlBuilder = new StringBuilder();
                urlBuilder.append("failover:(");
                if (sslEnabled) {
                    urlBuilder.append("ssl://");
                    urlBuilder.append(host);
                    urlBuilder.append(":");
                    urlBuilder.append(port);
                    urlBuilder.append(")");
                } else {
                    urlBuilder.append("tcp://");
                    urlBuilder.append(host);
                    urlBuilder.append(":");
                    urlBuilder.append(port);
                    urlBuilder.append(")");
                }
                if (clientID != null) {
                    urlBuilder.append("?jms.clientID=");
                    urlBuilder.append(clientID);
                }
                if (sslEnabled) {
                    ActiveMQSslConnectionFactory sslConnectionFactory = new ActiveMQSslConnectionFactory(urlBuilder.toString());
                    sslConnectionFactory.setUserName(user);
                    sslConnectionFactory.setPassword(password);
                    sslConnectionFactory.setTrustStore("server-ca-truststore.jks");
                    sslConnectionFactory.setTrustStorePassword("securepass");
                    return sslConnectionFactory;
                }
                return new ActiveMQConnectionFactory(user, password, urlBuilder.toString());
            }
        }
        throw new IllegalStateException("Unexpected value: " + protocol);
    }
}

