/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.critical;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.jaas.InVMLoginModule;
import org.apache.activemq.artemis.tests.util.SpawnedTestBase;
import org.apache.activemq.artemis.utils.ArtemisCloseable;
import org.apache.activemq.artemis.utils.SpawnedVMSupport;
import org.apache.activemq.artemis.utils.critical.CriticalCloseable;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;
import org.junit.Assert;
import org.junit.Test;

public class CriticalCrashTest
extends SpawnedTestBase {
    @Test
    public void testCrash() throws Exception {
        Process process = SpawnedVMSupport.spawnVM((String)CriticalCrashTest.class.getName(), (String[])new String[]{"-Dbrokerconfig.criticalAnalyzer=true", "-Dbrokerconfig.criticalAnalyzerCheckPeriod=100", "-Dbrokerconfig.criticalAnalyzerTimeout=500", "-Dbrokerconfig.criticalAnalyzerPolicy=HALT"}, (String[])new String[0]);
        Assert.assertEquals((long)70L, (long)process.waitFor());
        CriticalCrashTest.deleteDirectory((File)new File("./target/server"));
    }

    public static void main(String[] arg) {
        try {
            CriticalCrashTest test = new CriticalCrashTest();
            test.runSimple();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSimple() throws Exception {
        CriticalCrashTest.deleteDirectory((File)new File("./target/server"));
        ActiveMQServer server = this.createServer("./target/server");
        try {
            server.start();
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
            Connection connection = factory.createConnection();
            Session session = connection.createSession();
            MessageProducer producer = session.createProducer((Destination)session.createQueue("queue"));
            for (int i = 0; i < 500; ++i) {
                producer.send((Message)session.createTextMessage("text"));
            }
        }
        finally {
            server.stop();
        }
    }

    ActiveMQServer createServer(String folder) throws Exception {
        final AtomicBoolean blocked = new AtomicBoolean(false);
        final Configuration conf = this.createConfig(folder);
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager(InVMLoginModule.class.getName(), new SecurityConfiguration());
        conf.setPersistenceEnabled(true);
        ActiveMQServerImpl server = new ActiveMQServerImpl(conf, (ActiveMQSecurityManager)securityManager){

            protected StorageManager createStorageManager() {
                JournalStorageManager storageManager = new JournalStorageManager(conf, this.getCriticalAnalyzer(), this.executorFactory, this.scheduledPool, this.ioExecutorFactory, this.ioCriticalErrorListener){

                    public ArtemisCloseable closeableReadLock() {
                        CriticalCloseable measure = this.measureCritical(0);
                        this.storageManagerLock.readLock().lock();
                        if (blocked.get()) {
                            while (true) {
                                try {
                                    while (true) {
                                        Thread.sleep(1000L);
                                    }
                                }
                                catch (Throwable throwable) {
                                    continue;
                                }
                                break;
                            }
                        }
                        return () -> this.lambda$closeableReadLock$0((ArtemisCloseable)measure);
                    }

                    public void storeMessage(org.apache.activemq.artemis.api.core.Message message) throws Exception {
                        super.storeMessage(message);
                        blocked.set(true);
                    }

                    private /* synthetic */ void lambda$closeableReadLock$0(ArtemisCloseable measure) {
                        this.storageManagerLock.readLock().unlock();
                        measure.close();
                    }
                };
                this.getCriticalAnalyzer().add((CriticalComponent)storageManager);
                return storageManager;
            }
        };
        return server;
    }

    Configuration createConfig(String folder) throws Exception {
        Configuration configuration = this.createDefaultConfig(true);
        configuration.setSecurityEnabled(false).setJournalMinFiles(2).setJournalFileSize(102400).setJournalType(CriticalCrashTest.getDefaultJournalType()).setJournalDirectory(folder + "/journal").setBindingsDirectory(folder + "/bindings").setPagingDirectory(folder + "/paging").setLargeMessagesDirectory(folder + "/largemessage").setJournalCompactMinFiles(0).setJournalCompactPercentage(0).setClusterPassword("UnitTestsClusterPassword").setJournalDatasync(false);
        configuration.setSecurityEnabled(false);
        configuration.setPersistenceEnabled(true);
        return configuration;
    }
}

