/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.cluster;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.core.server.cluster.MessageFlowRecord;
import org.apache.activemq.artemis.core.server.cluster.impl.BridgeImpl;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionImpl;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.JMSClusteredTestBase;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BindingsClusterTest
extends JMSClusteredTestBase {
    public static final String TOPIC = "jms.t1";
    private final boolean crash;

    public BindingsClusterTest(boolean crash) {
        this.crash = crash;
    }

    @Parameterized.Parameters(name="crash={0}")
    public static Collection getParameters() {
        return Arrays.asList({true}, {false});
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.jmsServer1.getActiveMQServer().setIdentity("Server 1");
        this.jmsServer2.getActiveMQServer().setIdentity("Server 2");
    }

    @Override
    protected boolean enablePersistence() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendToSingleDisconnectedBinding() throws Exception {
        Connection conn1 = this.cf1.createConnection();
        conn1.setClientID("someClient1");
        Connection conn2 = this.cf2.createConnection();
        conn2.setClientID("someClient2");
        conn1.start();
        conn2.start();
        try {
            Topic topic1 = this.createTopic(TOPIC, true);
            Topic topic2 = (Topic)this.context1.lookup("topic/jms.t1");
            Session session1 = conn1.createSession(false, 1);
            Session session2 = conn2.createSession(false, 1);
            TopicSubscriber cons2 = session2.createDurableSubscriber(topic2, "sub2");
            cons2.close();
            session2.close();
            conn2.close();
            Thread.sleep(500L);
            MessageProducer prod1 = session1.createProducer((Destination)topic1);
            prod1.setDeliveryMode(2);
            prod1.send((Message)session1.createTextMessage("m1"));
            this.printBindings(this.jmsServer1.getActiveMQServer(), TOPIC);
            this.printBindings(this.jmsServer2.getActiveMQServer(), TOPIC);
            this.crash();
            this.printBindings(this.jmsServer1.getActiveMQServer(), TOPIC);
            prod1.send((Message)session1.createTextMessage("m2"));
            this.restart();
            Thread.sleep(2000L);
            this.printBindings(this.jmsServer1.getActiveMQServer(), TOPIC);
            this.printBindings(this.jmsServer2.getActiveMQServer(), TOPIC);
            prod1.send((Message)session1.createTextMessage("m3"));
            this.cf2 = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(InVMConnectorFactory.class.getName(), this.generateInVMParams(2))});
            conn2 = this.cf2.createConnection();
            conn2.setClientID("someClient2");
            session2 = conn2.createSession(false, 1);
            cons2 = session2.createDurableSubscriber(topic2, "sub2");
            conn2.start();
            TextMessage received = (TextMessage)cons2.receive(5000L);
            BindingsClusterTest.assertNotNull((Object)received);
            BindingsClusterTest.assertEquals((Object)"m1", (Object)received.getText());
            received = (TextMessage)cons2.receive(5000L);
            BindingsClusterTest.assertNotNull((Object)received);
            BindingsClusterTest.assertEquals((Object)"m2", (Object)received.getText());
            received = (TextMessage)cons2.receive(5000L);
            BindingsClusterTest.assertNotNull((Object)received);
            BindingsClusterTest.assertEquals((Object)"m3", (Object)received.getText());
            cons2.close();
        }
        finally {
            conn1.close();
            conn2.close();
        }
        this.jmsServer1.destroyTopic(TOPIC);
        this.jmsServer2.destroyTopic(TOPIC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendToSingleDisconnectedBindingWhenLocalAvailable() throws Exception {
        Connection conn1 = this.cf1.createConnection();
        conn1.setClientID("someClient2");
        Connection conn2 = this.cf2.createConnection();
        conn2.setClientID("someClient2");
        conn1.start();
        conn2.start();
        try {
            Topic topic1 = this.createTopic(TOPIC, true);
            Topic topic2 = (Topic)this.context1.lookup("topic/jms.t1");
            Session session1 = conn1.createSession(false, 1);
            Session session2 = conn2.createSession(false, 1);
            TopicSubscriber cons1 = session1.createDurableSubscriber(topic1, "sub2");
            TopicSubscriber cons2 = session2.createDurableSubscriber(topic2, "sub2");
            cons2.close();
            session2.close();
            conn2.close();
            Thread.sleep(500L);
            MessageProducer prod1 = session1.createProducer((Destination)topic1);
            prod1.setDeliveryMode(2);
            prod1.send((Message)session1.createTextMessage("m1"));
            this.printBindings(this.jmsServer1.getActiveMQServer(), TOPIC);
            this.printBindings(this.jmsServer2.getActiveMQServer(), TOPIC);
            this.crash();
            this.printBindings(this.jmsServer1.getActiveMQServer(), TOPIC);
            prod1.send((Message)session1.createTextMessage("m2"));
            prod1.send((Message)session1.createTextMessage("m3"));
            prod1.send((Message)session1.createTextMessage("m4"));
            this.restart();
            Thread.sleep(2000L);
            this.printBindings(this.jmsServer1.getActiveMQServer(), TOPIC);
            this.printBindings(this.jmsServer2.getActiveMQServer(), TOPIC);
            prod1.send((Message)session1.createTextMessage("m5"));
            prod1.send((Message)session1.createTextMessage("m6"));
            this.cf2 = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(InVMConnectorFactory.class.getName(), this.generateInVMParams(2))});
            conn2 = this.cf2.createConnection();
            conn2.setClientID("someClient2");
            session2 = conn2.createSession(false, 1);
            cons2 = session2.createDurableSubscriber(topic2, "sub2");
            conn2.start();
            TextMessage received = (TextMessage)cons2.receiveNoWait();
            BindingsClusterTest.assertNull((Object)received);
            received = (TextMessage)cons1.receive(5000L);
            BindingsClusterTest.assertNotNull((Object)received);
            BindingsClusterTest.assertEquals((Object)"m1", (Object)received.getText());
            received = (TextMessage)cons1.receive(5000L);
            BindingsClusterTest.assertNotNull((Object)received);
            BindingsClusterTest.assertEquals((Object)"m2", (Object)received.getText());
            received = (TextMessage)cons1.receive(5000L);
            BindingsClusterTest.assertNotNull((Object)received);
            BindingsClusterTest.assertEquals((Object)"m3", (Object)received.getText());
            received = (TextMessage)cons1.receive(5000L);
            BindingsClusterTest.assertNotNull((Object)received);
            BindingsClusterTest.assertEquals((Object)"m4", (Object)received.getText());
            received = (TextMessage)cons1.receive(5000L);
            BindingsClusterTest.assertNotNull((Object)received);
            BindingsClusterTest.assertEquals((Object)"m5", (Object)received.getText());
            cons2.close();
        }
        finally {
            conn1.close();
            conn2.close();
        }
        this.jmsServer1.destroyTopic(TOPIC);
        this.jmsServer2.destroyTopic(TOPIC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoteBindingRemovedOnReconnectLocalAvailable() throws Exception {
        Connection conn1 = this.cf1.createConnection();
        conn1.setClientID("someClient2");
        Connection conn2 = this.cf2.createConnection();
        conn2.setClientID("someClient2");
        conn1.start();
        conn2.start();
        try {
            Topic topic1 = this.createTopic(TOPIC, true);
            Topic topic2 = (Topic)this.context1.lookup("topic/jms.t1");
            Session session1 = conn1.createSession(false, 1);
            Session session2 = conn2.createSession(false, 1);
            MessageConsumer cons1 = session1.createSharedConsumer(topic1, "sub2");
            MessageConsumer cons2 = session2.createSharedConsumer(topic2, "sub2");
            Thread.sleep(500L);
            MessageProducer prod1 = session1.createProducer((Destination)topic1);
            prod1.setDeliveryMode(2);
            prod1.send((Message)session1.createTextMessage("m1"));
            prod1.send((Message)session1.createTextMessage("m2"));
            this.printBindings(this.jmsServer1.getActiveMQServer(), TOPIC);
            this.printBindings(this.jmsServer2.getActiveMQServer(), TOPIC);
            TextMessage received = (TextMessage)cons2.receive(5000L);
            BindingsClusterTest.assertNotNull((Object)received);
            BindingsClusterTest.assertEquals((Object)"m2", (Object)received.getText());
            this.crash();
            cons2.close();
            this.printBindings(this.jmsServer1.getActiveMQServer(), TOPIC);
            prod1.send((Message)session1.createTextMessage("m3"));
            prod1.send((Message)session1.createTextMessage("m4"));
            prod1.send((Message)session1.createTextMessage("m5"));
            this.restart();
            Thread.sleep(2000L);
            this.printBindings(this.jmsServer1.getActiveMQServer(), TOPIC);
            this.printBindings(this.jmsServer2.getActiveMQServer(), TOPIC);
            prod1.send((Message)session1.createTextMessage("m6"));
            prod1.send((Message)session1.createTextMessage("m7"));
            received = (TextMessage)cons1.receive(5000L);
            BindingsClusterTest.assertNotNull((Object)received);
            BindingsClusterTest.assertEquals((Object)"m1", (Object)received.getText());
            received = (TextMessage)cons1.receive(5000L);
            BindingsClusterTest.assertNotNull((Object)received);
            BindingsClusterTest.assertEquals((Object)"m3", (Object)received.getText());
            received = (TextMessage)cons1.receive(5000L);
            BindingsClusterTest.assertNotNull((Object)received);
            BindingsClusterTest.assertEquals((Object)"m4", (Object)received.getText());
            received = (TextMessage)cons1.receive(5000L);
            BindingsClusterTest.assertNotNull((Object)received);
            BindingsClusterTest.assertEquals((Object)"m5", (Object)received.getText());
            received = (TextMessage)cons1.receive(5000L);
            BindingsClusterTest.assertNotNull((Object)received);
            BindingsClusterTest.assertEquals((Object)"m6", (Object)received.getText());
            received = (TextMessage)cons1.receive(5000L);
            BindingsClusterTest.assertNotNull((Object)received);
            BindingsClusterTest.assertEquals((Object)"m7", (Object)received.getText());
            cons2.close();
        }
        finally {
            conn1.close();
            conn2.close();
        }
        this.jmsServer1.destroyTopic(TOPIC);
        this.jmsServer2.destroyTopic(TOPIC);
    }

    private void crash() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        ClusterConnectionImpl next = (ClusterConnectionImpl)this.server1.getClusterManager().getClusterConnections().iterator().next();
        BridgeImpl bridge = (BridgeImpl)((MessageFlowRecord)next.getRecords().values().iterator().next()).getBridge();
        RemotingConnection forwardingConnection = this.getForwardingConnection((Bridge)bridge);
        forwardingConnection.addFailureListener(new FailureListener(){

            public void connectionFailed(ActiveMQException exception, boolean failedOver) {
                latch.countDown();
            }

            public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
                this.connectionFailed(me, failedOver);
            }
        });
        forwardingConnection.fail((ActiveMQException)((Object)new ActiveMQNotConnectedException()));
        BindingsClusterTest.assertTrue((boolean)latch.await(5000L, TimeUnit.MILLISECONDS));
        if (this.crash) {
            this.jmsServer2.stop();
        }
    }

    private void restart() throws Exception {
        if (this.crash) {
            this.jmsServer2.start();
        }
    }

    private RemotingConnection getForwardingConnection(Bridge bridge) throws Exception {
        long start = System.currentTimeMillis();
        do {
            RemotingConnection forwardingConnection;
            if ((forwardingConnection = ((BridgeImpl)bridge).getForwardingConnection()) != null) {
                return forwardingConnection;
            }
            Thread.sleep(10L);
        } while (System.currentTimeMillis() - start < 50000L);
        throw new IllegalStateException("Failed to get forwarding connection");
    }
}

