/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.ObjectNameBuilder;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.integration.management.ManagementTestBase;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JMXDomainTest
extends ManagementTestBase {
    private ActiveMQServer server_0 = null;
    private ActiveMQServer server_1 = null;
    private boolean jmxUseBrokerName;

    @Parameterized.Parameters(name="jmxUseBrokerName={0}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({true}, {false});
    }

    public JMXDomainTest(boolean jmxUseBrokerName) {
        this.jmxUseBrokerName = jmxUseBrokerName;
    }

    @Test
    public void test2ActiveMQServersManagedFrom1MBeanServer() throws Exception {
        Configuration config_0 = this.createDefaultInVMConfig().setJMXManagementEnabled(true);
        String jmxDomain_1 = ActiveMQDefaultConfiguration.getDefaultJmxDomain() + ".1";
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("serverId", 1);
        ConfigurationImpl config_1 = this.createBasicConfig().addAcceptorConfiguration(new TransportConfiguration(InVMAcceptorFactory.class.getName(), params)).setJMXDomain(jmxDomain_1).setJMXUseBrokerName(this.jmxUseBrokerName);
        this.server_0 = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config_0, (MBeanServer)this.mbeanServer, (boolean)false));
        this.server_1 = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config_1, (MBeanServer)this.mbeanServer, (boolean)false));
        ObjectNameBuilder builder_0 = ObjectNameBuilder.DEFAULT;
        ObjectNameBuilder builder_1 = ObjectNameBuilder.create((String)jmxDomain_1, (String)"localhost", (boolean)this.jmxUseBrokerName);
        this.checkNoResource(builder_0.getActiveMQServerObjectName());
        this.checkNoResource(builder_1.getActiveMQServerObjectName());
        this.server_0.start();
        this.checkResource(builder_0.getActiveMQServerObjectName());
        this.checkNoResource(builder_1.getActiveMQServerObjectName());
        this.server_1.start();
        this.checkResource(builder_0.getActiveMQServerObjectName());
        this.checkResource(builder_1.getActiveMQServerObjectName());
        this.server_0.stop();
        this.checkNoResource(builder_0.getActiveMQServerObjectName());
        this.checkResource(builder_1.getActiveMQServerObjectName());
        this.server_1.stop();
        this.checkNoResource(builder_0.getActiveMQServerObjectName());
        this.checkNoResource(builder_1.getActiveMQServerObjectName());
    }
}

