/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.postoffice.impl;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.Address;
import org.apache.activemq.artemis.core.postoffice.impl.AddressImpl;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class AddressImplTest
extends ActiveMQTestBase {
    @Test
    public void testNoDots() {
        SimpleString s1 = new SimpleString("abcde");
        SimpleString s2 = new SimpleString("abcde");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        Assert.assertTrue((boolean)a1.matches((Address)a2));
    }

    @Test
    public void testDotsSameLength2() {
        SimpleString s1 = new SimpleString("a.b");
        SimpleString s2 = new SimpleString("a.b");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        Assert.assertTrue((boolean)a1.matches((Address)a2));
    }

    @Test
    public void testA() {
        SimpleString s1 = new SimpleString("a.b.c");
        SimpleString s2 = new SimpleString("a.b.c.d.e.f.g.h.i.j.k.l.m.n.*");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        Assert.assertFalse((boolean)a1.matches((Address)a2));
    }

    @Test
    public void testB() {
        SimpleString s1 = new SimpleString("a.b.c.d");
        SimpleString s2 = new SimpleString("a.b.x.e");
        SimpleString s3 = new SimpleString("a.b.c.*");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertFalse((boolean)a2.matches((Address)w));
    }

    @Test
    public void testC() {
        SimpleString s1 = new SimpleString("a.b.c.d");
        SimpleString s2 = new SimpleString("a.b.c.x");
        SimpleString s3 = new SimpleString("a.b.*.d");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertFalse((boolean)a2.matches((Address)w));
    }

    @Test
    public void testD() {
        SimpleString s1 = new SimpleString("a.b.c.d.e");
        SimpleString s2 = new SimpleString("a.b.c.x.e");
        SimpleString s3 = new SimpleString("a.b.*.d.*");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertFalse((boolean)a2.matches((Address)w));
    }

    @Test
    public void testE() {
        SimpleString s1 = new SimpleString("a.b.c.d.e.f");
        SimpleString s2 = new SimpleString("a.b.c.x.e.f");
        SimpleString s3 = new SimpleString("a.b.*.d.*.f");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertFalse((boolean)a2.matches((Address)w));
    }

    @Test
    public void testF() {
        SimpleString s1 = new SimpleString("a.b.c.d.e.f");
        SimpleString s2 = new SimpleString("a.b.c.x.e.f");
        SimpleString s3 = new SimpleString("#");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertTrue((boolean)a2.matches((Address)w));
    }

    @Test
    public void testG() {
        SimpleString s1 = new SimpleString("a.b.c.d.e.f");
        SimpleString s2 = new SimpleString("a.b.c.x.e.f");
        SimpleString s3 = new SimpleString("a.#");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertTrue((boolean)a2.matches((Address)w));
    }

    @Test
    public void testH() {
        SimpleString s1 = new SimpleString("a.b.c.d.e.f");
        SimpleString s2 = new SimpleString("a.b.c.x.e.f");
        SimpleString s3 = new SimpleString("#.b.#");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertTrue((boolean)a2.matches((Address)w));
    }

    @Test
    public void testI() {
        SimpleString s1 = new SimpleString("a.b.c.d.e.f");
        SimpleString s2 = new SimpleString("a.b.c.x.e.f");
        SimpleString s3 = new SimpleString("a.#.b.#");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertTrue((boolean)a2.matches((Address)w));
    }

    @Test
    public void testJ() {
        SimpleString s1 = new SimpleString("a.b.c.d.e.f");
        SimpleString s2 = new SimpleString("a.b.c.x.e.f");
        SimpleString s3 = new SimpleString("a.#.c.d.e.f");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertFalse((boolean)a2.matches((Address)w));
    }

    @Test
    public void testK() {
        SimpleString s1 = new SimpleString("a.b.c.d.e.f");
        SimpleString s2 = new SimpleString("a.b.c.d.e.x");
        SimpleString s3 = new SimpleString("a.#.c.d.e.*");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertTrue((boolean)a2.matches((Address)w));
    }

    @Test
    public void testL() {
        SimpleString s1 = new SimpleString("a.b.c.d.e.f");
        SimpleString s2 = new SimpleString("a.b.c.d.e.x");
        SimpleString s3 = new SimpleString("a.#.c.d.*.f");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertFalse((boolean)a2.matches((Address)w));
    }

    @Test
    public void testM() {
        SimpleString s1 = new SimpleString("a.b.c");
        SimpleString s2 = new SimpleString("a.b.x.e");
        SimpleString s3 = new SimpleString("a.b.c.#");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertFalse((boolean)a2.matches((Address)w));
    }

    @Test
    public void testN() {
        SimpleString s1 = new SimpleString("usd.stock");
        SimpleString s2 = new SimpleString("a.b.x.e");
        SimpleString s3 = new SimpleString("*.stock.#");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertFalse((boolean)a2.matches((Address)w));
    }

    @Test
    public void testO() {
        SimpleString s1 = new SimpleString("a.b.c.d");
        SimpleString s2 = new SimpleString("a.b.x.e");
        SimpleString s3 = new SimpleString("a.b.c.*");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertFalse((boolean)a2.matches((Address)w));
    }

    @Test
    public void testP() {
        SimpleString s1 = new SimpleString("a.b.c.d");
        SimpleString s3 = new SimpleString("a.b.c#");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertFalse((boolean)a1.matches((Address)w));
    }

    @Test
    public void testQ() {
        SimpleString s1 = new SimpleString("a.b.c.d");
        SimpleString s3 = new SimpleString("#a.b.c");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertFalse((boolean)a1.matches((Address)w));
    }

    @Test
    public void testR() {
        SimpleString s1 = new SimpleString("a.b.c.d");
        SimpleString s3 = new SimpleString("#*a.b.c");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertFalse((boolean)a1.matches((Address)w));
    }

    @Test
    public void testS() {
        SimpleString s1 = new SimpleString("a.b.c.d");
        SimpleString s3 = new SimpleString("a.b.c*");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertFalse((boolean)a1.matches((Address)w));
    }

    @Test
    public void testT() {
        SimpleString s1 = new SimpleString("a.b.c.d");
        SimpleString s3 = new SimpleString("*a.b.c");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertFalse((boolean)a1.matches((Address)w));
    }

    @Test
    public void testU() {
        SimpleString s1 = new SimpleString("a.b.c.d");
        SimpleString s3 = new SimpleString("*a.b.c");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertFalse((boolean)a1.matches((Address)w));
    }

    @Test
    public void testV() {
        SimpleString s1 = new SimpleString("a.b.d");
        SimpleString s3 = new SimpleString("a.b.#.d");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
    }
}

