/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.ee.concurrency;

import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import org.glassfish.enterprise.concurrent.spi.TransactionHandle;
import org.glassfish.enterprise.concurrent.spi.TransactionSetupProvider;
import org.jboss.as.txn.logging.TransactionLogger;

public class TransactionSetupProviderImpl
implements TransactionSetupProvider {
    private final transient TransactionManager transactionManager;

    public TransactionSetupProviderImpl(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public TransactionHandle beforeProxyMethod(String transactionExecutionProperty) {
        Transaction transaction = null;
        if (!"USE_TRANSACTION_OF_EXECUTION_THREAD".equals(transactionExecutionProperty)) {
            try {
                transaction = this.transactionManager.suspend();
            }
            catch (Throwable e) {
                TransactionLogger.ROOT_LOGGER.debug("failed to suspend transaction", e);
            }
        }
        return new TransactionHandleImpl(transaction);
    }

    public void afterProxyMethod(TransactionHandle transactionHandle, String transactionExecutionProperty) {
        Transaction transaction = ((TransactionHandleImpl)transactionHandle).getTransaction();
        if (transaction != null) {
            try {
                this.transactionManager.resume(transaction);
            }
            catch (Throwable e) {
                TransactionLogger.ROOT_LOGGER.debug("failed to resume transaction", e);
            }
        }
    }

    private static class TransactionHandleImpl
    implements TransactionHandle {
        private final Transaction transaction;

        private TransactionHandleImpl(Transaction transaction) {
            this.transaction = transaction;
        }

        public Transaction getTransaction() {
            return this.transaction;
        }
    }
}

