/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.as.controller.ExpressionResolverImpl;
import org.jboss.as.controller.OperationClientException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.extension.ExpressionResolverExtension;
import org.jboss.as.controller.extension.ResolverExtensionRegistry;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class RuntimeExpressionResolver
extends ExpressionResolverImpl
implements ResolverExtensionRegistry {
    private static final Logger log = Logger.getLogger(RuntimeExpressionResolver.class);
    private final Set<ExpressionResolverExtension> extensions = new HashSet<ExpressionResolverExtension>();

    public synchronized void addResolverExtension(ExpressionResolverExtension extension) {
        this.extensions.add(extension);
    }

    public synchronized void removeResolverExtension(ExpressionResolverExtension extension) {
        this.extensions.remove(extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolvePluggableExpression(ModelNode node, OperationContext context) throws OperationFailedException {
        String expression = node.asString();
        if (context != null && expression.length() > 3) {
            String result = null;
            OperationFailedException ofe = null;
            RuntimeException operationClientException = null;
            RuntimeException otherRe = null;
            Set<ExpressionResolverExtension> set = this.extensions;
            synchronized (set) {
                Iterator<ExpressionResolverExtension> iter = this.extensions.iterator();
                while (result == null && iter.hasNext()) {
                    try {
                        result = this.resolveExpression(expression, iter.next(), context);
                    }
                    catch (OperationFailedException oe) {
                        if (ofe != null) continue;
                        ofe = oe;
                    }
                    catch (RuntimeException re) {
                        if (re instanceof OperationClientException) {
                            if (operationClientException != null) continue;
                            operationClientException = re;
                            continue;
                        }
                        if (otherRe != null) continue;
                        otherRe = re;
                    }
                }
            }
            if (result != null) {
                node.set(result);
            } else {
                if (ofe != null) {
                    throw ofe;
                }
                if (operationClientException != null) {
                    throw operationClientException;
                }
                if (otherRe != null) {
                    throw otherRe;
                }
            }
        }
    }

    private String resolveExpression(String expression, ExpressionResolverExtension resolver, OperationContext context) throws OperationFailedException {
        resolver.initialize(context);
        return resolver.resolveExpression(expression, context);
    }
}

