/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.StateHelper;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.LRUMap;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.TypedCollections;
import com.sun.faces.util.Util;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;

public class ServerSideStateHelper
extends StateHelper {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    public static final String STATEMANAGED_SERIAL_ID_KEY = ServerSideStateHelper.class.getName() + ".SerialId";
    public static final String LOGICAL_VIEW_MAP = ServerSideStateHelper.class.getName() + ".LogicalViewMap";
    protected final Integer numberOfLogicalViews = this.getIntegerConfigValue(WebConfiguration.WebContextInitParameter.NumberOfLogicalViews);
    protected final Integer numberOfViews = this.getIntegerConfigValue(WebConfiguration.WebContextInitParameter.NumberOfViews);
    protected boolean generateUniqueStateIds;
    protected final SecureRandom random;

    public ServerSideStateHelper() {
        WebConfiguration webConfig = WebConfiguration.getInstance();
        this.generateUniqueStateIds = webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.GenerateUniqueServerStateIds);
        if (this.generateUniqueStateIds) {
            this.random = new SecureRandom();
            this.random.nextBytes(new byte[1]);
        } else {
            this.random = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeState(FacesContext ctx, Object state, StringBuilder stateCapture) throws IOException {
        String id;
        Util.notNull("context", ctx);
        UIViewRoot viewRoot = ctx.getViewRoot();
        if (!viewRoot.isTransient()) {
            if (!ctx.getAttributes().containsKey("com.sun.faces.ViewStateValue")) {
                Util.notNull("state", state);
                Object[] stateToWrite = (Object[])state;
                ExternalContext externalContext = ctx.getExternalContext();
                Object sessionObj = externalContext.getSession(true);
                Map sessionMap = externalContext.getSessionMap();
                Object object = sessionObj;
                synchronized (object) {
                    Map<String, Object[]> actualMap;
                    Map<String, Map<String, Map<String, Object[]>>> logicalMap = TypedCollections.dynamicallyCastMap((Map)sessionMap.get(LOGICAL_VIEW_MAP), String.class, Map.class);
                    if (logicalMap == null) {
                        logicalMap = Collections.synchronizedMap(new LRUMap(this.numberOfLogicalViews));
                        sessionMap.put(LOGICAL_VIEW_MAP, logicalMap);
                    }
                    Object structure = stateToWrite[0];
                    Object savedState = this.handleSaveState(stateToWrite[1]);
                    String idInLogicalMap = (String)RequestStateManager.get(ctx, "com.sun.faces.logicalViewMap");
                    if (idInLogicalMap == null) {
                        idInLogicalMap = this.generateUniqueStateIds ? this.createRandomId() : this.createIncrementalRequestId(ctx);
                    }
                    String idInActualMap = null;
                    if (ctx.getPartialViewContext().isPartialRequest()) {
                        idInActualMap = (String)RequestStateManager.get(ctx, "com.sun.faces.actualViewMap");
                    }
                    if (null == idInActualMap) {
                        String string = idInActualMap = this.generateUniqueStateIds ? this.createRandomId() : this.createIncrementalRequestId(ctx);
                    }
                    if ((actualMap = TypedCollections.dynamicallyCastMap(logicalMap.get(idInLogicalMap), String.class, Object[].class)) == null) {
                        actualMap = new LRUMap<String, Object[]>(this.numberOfViews);
                        logicalMap.put(idInLogicalMap, actualMap);
                    }
                    id = idInLogicalMap + ':' + idInActualMap;
                    Object[] stateArray = actualMap.get(idInActualMap);
                    if (stateArray != null) {
                        stateArray[0] = structure;
                        stateArray[1] = savedState;
                    } else {
                        actualMap.put(idInActualMap, new Object[]{structure, savedState});
                    }
                    sessionMap.put(LOGICAL_VIEW_MAP, logicalMap);
                    ctx.getAttributes().put("com.sun.faces.ViewStateValue", id);
                }
            } else {
                id = (String)ctx.getAttributes().get("com.sun.faces.ViewStateValue");
            }
        } else {
            id = "stateless";
        }
        if (stateCapture != null) {
            stateCapture.append(id);
        } else {
            ResponseWriter writer = ctx.getResponseWriter();
            writer.startElement("input", null);
            writer.writeAttribute("type", (Object)"hidden", null);
            writer.writeAttribute("name", (Object)RenderKitUtils.PredefinedPostbackParameter.VIEW_STATE_PARAM.getName(ctx), null);
            if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableViewStateIdRendering)) {
                String viewStateId = Util.getViewStateId(ctx);
                writer.writeAttribute("id", (Object)viewStateId, null);
            }
            writer.writeAttribute("value", (Object)id, null);
            if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.AutoCompleteOffOnViewState)) {
                writer.writeAttribute("autocomplete", (Object)"off", null);
            }
            writer.endElement("input");
            this.writeClientWindowField(ctx, writer);
            this.writeRenderKitIdField(ctx, writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getState(FacesContext ctx, String viewId) {
        String compoundId = ServerSideStateHelper.getStateParamValue(ctx);
        if (compoundId == null) {
            return null;
        }
        if ("stateless".equals(compoundId)) {
            return "stateless";
        }
        int sep = compoundId.indexOf(58);
        assert (sep != -1);
        assert (sep < compoundId.length());
        String idInLogicalMap = compoundId.substring(0, sep);
        String idInActualMap = compoundId.substring(sep + 1);
        ExternalContext externalCtx = ctx.getExternalContext();
        Object sessionObj = externalCtx.getSession(false);
        if (sessionObj == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to restore server side state for view ID {0} as no session is available", viewId);
            }
            return null;
        }
        Object object = sessionObj;
        synchronized (object) {
            Map actualMap;
            Map logicalMap = (Map)externalCtx.getSessionMap().get(LOGICAL_VIEW_MAP);
            if (logicalMap != null && (actualMap = (Map)logicalMap.get(idInLogicalMap)) != null) {
                RequestStateManager.set(ctx, "com.sun.faces.logicalViewMap", idInLogicalMap);
                Object[] restoredState = new Object[2];
                Object[] state = (Object[])actualMap.get(idInActualMap);
                if (state != null) {
                    restoredState[0] = state[0];
                    restoredState[1] = state[1];
                    RequestStateManager.set(ctx, "com.sun.faces.actualViewMap", idInActualMap);
                    if (state.length == 2 && state[1] != null) {
                        restoredState[1] = this.handleRestoreState(state[1]);
                    }
                }
                return restoredState;
            }
        }
        return null;
    }

    protected Integer getIntegerConfigValue(WebConfiguration.WebContextInitParameter param) {
        Integer value;
        block5: {
            String noOfViewsStr = this.webConfig.getOptionValue(param);
            value = null;
            try {
                value = Integer.valueOf(noOfViewsStr);
            }
            catch (NumberFormatException nfe) {
                String defaultValue = param.getDefaultValue();
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.state.server.cannot.parse.int.option", new Object[]{param.getQualifiedName(), defaultValue});
                }
                try {
                    value = Integer.valueOf(defaultValue);
                }
                catch (NumberFormatException ne) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block5;
                    LOGGER.log(Level.FINEST, "Unable to convert number", ne);
                }
            }
        }
        return value;
    }

    protected Object handleSaveState(Object state) {
        if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.SerializeServerStateDeprecated) || this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.SerializeServerState)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            ObjectOutputStream oas = null;
            try {
                oas = this.serialProvider.createObjectOutputStream(this.compressViewState ? new GZIPOutputStream((OutputStream)baos, 1024) : baos);
                oas.writeObject(state);
                oas.flush();
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
            finally {
                block12: {
                    if (oas != null) {
                        try {
                            oas.close();
                        }
                        catch (IOException ioe) {
                            if (!LOGGER.isLoggable(Level.FINEST)) break block12;
                            LOGGER.log(Level.FINEST, "Closing stream", ioe);
                        }
                    }
                }
            }
            return baos.toByteArray();
        }
        return state;
    }

    /*
     * Exception decompiling
     */
    protected Object handleRestoreState(Object state) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String createIncrementalRequestId(FacesContext ctx) {
        Map sm = ctx.getExternalContext().getSessionMap();
        AtomicInteger idgen = (AtomicInteger)sm.get(STATEMANAGED_SERIAL_ID_KEY);
        if (idgen == null) {
            idgen = new AtomicInteger(1);
        }
        sm.put(STATEMANAGED_SERIAL_ID_KEY, idgen);
        return "j_id" + idgen.getAndIncrement();
    }

    private String createRandomId() {
        return Long.valueOf(this.random.nextLong()).toString();
    }

    @Override
    public boolean isStateless(FacesContext facesContext, String viewId) throws IllegalStateException {
        if (facesContext.isPostback()) {
            String compoundId = ServerSideStateHelper.getStateParamValue(facesContext);
            return compoundId != null && "stateless".equals(compoundId);
        }
        throw new IllegalStateException("Cannot determine whether or not the request is stateless");
    }
}

