/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.resources.arjunacore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.ExceptionDeferrer;
import com.arjuna.ats.arjuna.coordinator.TwoPhaseOutcome;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.internal.jta.resources.XAResourceErrorHandler;
import com.arjuna.ats.internal.jta.resources.arjunacore.XAResourceRecordWrappingPlugin;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.recovery.SerializableXAResourceDeserializer;
import com.arjuna.ats.jta.utils.XAHelper;
import com.arjuna.ats.jta.xa.RecoverableXAConnection;
import com.arjuna.ats.jta.xa.XidImple;
import com.arjuna.common.internal.util.ClassloadingUtility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.tm.FirstResource;
import org.jboss.tm.LastResource;

public class XAResourceRecord
extends AbstractRecord
implements ExceptionDeferrer {
    public static final int XACONNECTION = 0;
    private static final Uid START_XARESOURCE = Uid.minUid();
    private static final Uid END_XARESOURCE = Uid.maxUid();
    List<Throwable> deferredExceptions;
    protected XAResource _theXAResource;
    private boolean _forgotten;
    private RecoverableXAConnection _recoveryObject;
    private Xid _tranID;
    private boolean _prepared;
    private boolean _valid;
    private int _heuristic;
    private boolean _committed = false;
    private TransactionImple _theTransaction;
    private boolean _recovered = false;
    private String _productName;
    private String _productVersion;
    private String _jndiName;
    private static final XAResourceRecordWrappingPlugin _xaResourceRecordWrappingPlugin = jtaPropertyManager.getJTAEnvironmentBean().getXAResourceRecordWrappingPlugin();
    private static final boolean _rollbackOptimization = jtaPropertyManager.getJTAEnvironmentBean().isXaRollbackOptimization();
    private static final boolean _assumedComplete = jtaPropertyManager.getJTAEnvironmentBean().isXaAssumeRecoveryComplete();
    private List<SerializableXAResourceDeserializer> serializableXAResourceDeserializers;

    public XAResourceRecord(TransactionImple tx2, XAResource res, Xid xid, Object[] params) {
        super(new Uid(), null, 1);
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)("XAResourceRecord.XAResourceRecord ( " + xid + ", " + res + " ), record id=" + this.order()));
        }
        this._theXAResource = res;
        if (_xaResourceRecordWrappingPlugin != null) {
            _xaResourceRecordWrappingPlugin.transcribeWrapperData(this);
        }
        this._recoveryObject = null;
        this._tranID = xid;
        this._valid = true;
        if (params != null && params.length > 0 && params[0] instanceof RecoverableXAConnection) {
            this._recoveryObject = (RecoverableXAConnection)params[0];
        }
        this._prepared = false;
        this._heuristic = 7;
        this._theTransaction = tx2;
    }

    public final Xid getXid() {
        return this._tranID;
    }

    @Override
    public Uid order() {
        if (this._theXAResource instanceof FirstResource) {
            return START_XARESOURCE;
        }
        if (this._theXAResource instanceof LastResource) {
            return END_XARESOURCE;
        }
        return super.order();
    }

    @Override
    public boolean propagateOnCommit() {
        return false;
    }

    @Override
    public int typeIs() {
        return 171;
    }

    @Override
    public Object value() {
        return this._theXAResource;
    }

    @Override
    public void setValue(Object o) {
        jtaLogger.i18NLogger.warn_resources_arjunacore_setvalue("XAResourceRecord::set_value()");
    }

    @Override
    public int nestedAbort() {
        return 7;
    }

    @Override
    public int nestedCommit() {
        return 7;
    }

    @Override
    public int nestedPrepare() {
        return 0;
    }

    @Override
    public int topLevelPrepare() {
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)("XAResourceRecord.topLevelPrepare for " + this + ", record id=" + this.order()));
        }
        if (!this._valid || this._theXAResource == null || this._tranID == null) {
            jtaLogger.i18NLogger.warn_resources_arjunacore_preparenulltx("XAResourceRecord.prepare");
            this.removeConnection();
            return 1;
        }
        try {
            this.endAssociation(0x4000000, 1);
            this._prepared = true;
            if (this._theXAResource.prepare(this._tranID) == 3) {
                if (TxControl.isReadonlyOptimisation()) {
                    this.removeConnection();
                }
                return 2;
            }
            return 0;
        }
        catch (XAException e1) {
            this.addDeferredThrowable(e1);
            jtaLogger.i18NLogger.warn_resources_arjunacore_preparefailed(XAHelper.xidToString(this._tranID), this._theXAResource.toString(), XAHelper.printXAErrorCode(e1), e1);
            if (_rollbackOptimization) {
                this.removeConnection();
            }
            switch (e1.errorCode) {
                case -7: 
                case -6: 
                case -5: 
                case -4: 
                case -3: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    return 1;
                }
            }
            return 6;
        }
        catch (Exception e2) {
            jtaLogger.i18NLogger.warn_resources_arjunacore_preparefailed(XAHelper.xidToString(this._tranID), this._theXAResource.toString(), "-", e2);
            if (_rollbackOptimization) {
                this.removeConnection();
            }
            return 1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int topLevelAbort() {
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)("XAResourceRecord.topLevelAbort for " + this + ", record id=" + this.order()));
        }
        if (!this._valid) {
            return 8;
        }
        if (this._theTransaction != null && this._theTransaction.getXAResourceState(this._theXAResource) == 4) {
            return 7;
        }
        if (this._tranID == null) {
            jtaLogger.i18NLogger.warn_resources_arjunacore_rollbacknulltx("XAResourceRecord.rollback");
            return 8;
        }
        if (this._theXAResource == null) {
            this._theXAResource = this.getNewXAResource();
        }
        if (this._theXAResource != null) {
            block36: {
                if (this._heuristic != 7) {
                    return this._heuristic;
                }
                try {
                    if (!this._prepared) {
                        this.endAssociation(0x20000000, 3);
                    }
                }
                catch (XAException e1) {
                    this.addDeferredThrowable(e1);
                    if (e1.errorCode >= 100 && e1.errorCode < 107) break block36;
                    if (e1.errorCode == -3 || e1.errorCode == -7) {
                        try {
                            this._theXAResource.rollback(this._tranID);
                        }
                        catch (XAException e2) {
                            this.addDeferredThrowable(e2);
                            jtaLogger.i18NLogger.warn_resources_arjunacore_rollbackerror(XAHelper.xidToString(this._tranID), this._theXAResource.toString(), XAHelper.printXAErrorCode(e2), e2);
                            this.removeConnection();
                            return 8;
                        }
                    }
                    jtaLogger.i18NLogger.warn_resources_arjunacore_rollbackerror(XAHelper.xidToString(this._tranID), this._theXAResource.toString(), XAHelper.printXAErrorCode(e1), e1);
                    this.removeConnection();
                    return 8;
                }
                catch (RuntimeException e) {
                    jtaLogger.i18NLogger.warn_resources_arjunacore_rollbackerror(XAHelper.xidToString(this._tranID), this._theXAResource.toString(), "-", e);
                    throw e;
                }
            }
            try {
                this._theXAResource.rollback(this._tranID);
                return 7;
            }
            catch (XAException e1) {
                if (this.notAProblem(e1, false)) {
                    return 7;
                }
                this.addDeferredThrowable(e1);
                jtaLogger.i18NLogger.warn_resources_arjunacore_rollbackerror(XAHelper.xidToString(this._tranID), this._theXAResource.toString(), XAHelper.printXAErrorCode(e1), e1);
                switch (e1.errorCode) {
                    case -3: {
                        if (!this._prepared) {
                            return 7;
                        }
                    }
                    case 8: {
                        this._heuristic = 6;
                        int n = 6;
                        return n;
                    }
                    case 7: {
                        this._heuristic = 4;
                        int n = 4;
                        return n;
                    }
                    case 5: {
                        this._heuristic = 5;
                        int n = 5;
                        return n;
                    }
                    case -4: {
                        if (!this._recovered) return 7;
                        return 7;
                    }
                    case 6: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: {
                        return 7;
                    }
                    default: {
                        int n = 8;
                        return n;
                    }
                }
            }
            catch (Exception e2) {
                jtaLogger.i18NLogger.warn_resources_arjunacore_rollbackerror(XAHelper.xidToString(this._tranID), this._theXAResource.toString(), "-", e2);
                int n = 8;
                return n;
            }
            finally {
                if (!this._prepared) {
                    this.removeConnection();
                }
            }
        }
        jtaLogger.i18NLogger.warn_resources_arjunacore_noresource(XAHelper.xidToString(this._tranID));
        if (!_assumedComplete) return 8;
        jtaLogger.i18NLogger.info_resources_arjunacore_assumecomplete(XAHelper.xidToString(this._tranID));
        return 7;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int topLevelCommit() {
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)("XAResourceRecord.topLevelCommit for " + this + ", record id=" + this.order()));
        }
        if (!this._prepared) {
            return 9;
        }
        if (this._tranID == null) {
            jtaLogger.i18NLogger.warn_resources_arjunacore_commitnulltx("XAResourceRecord.commit");
            return 8;
        }
        if (this._theXAResource == null) {
            this._theXAResource = this.getNewXAResource();
        }
        if (this._theXAResource != null) {
            if (this._heuristic != 7) {
                return this._heuristic;
            }
            try {
                this._theXAResource.commit(this._tranID, false);
                return 7;
            }
            catch (XAException e1) {
                if (this.notAProblem(e1, true)) {
                    return 7;
                }
                this.addDeferredThrowable(e1);
                jtaLogger.i18NLogger.warn_resources_arjunacore_commitxaerror(XAHelper.xidToString(this._tranID), this._theXAResource.toString(), XAHelper.printXAErrorCode(e1), e1);
                switch (e1.errorCode) {
                    case 8: {
                        this._heuristic = 6;
                        int n = 6;
                        return n;
                    }
                    case 7: {
                        return 7;
                    }
                    case -6: 
                    case -3: 
                    case 6: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: {
                        this._heuristic = 3;
                        int n = 3;
                        return n;
                    }
                    case 5: {
                        int n = 5;
                        return n;
                    }
                    case -4: {
                        if (this._recovered) {
                            return 7;
                        }
                        this._heuristic = 6;
                        int n = 6;
                        return n;
                    }
                    case -7: 
                    case 4: {
                        this._committed = true;
                        int n = 8;
                        return n;
                    }
                    default: {
                        this._heuristic = 6;
                        int n = 6;
                        return n;
                    }
                }
            }
            catch (Exception e2) {
                jtaLogger.i18NLogger.warn_resources_arjunacore_commitxaerror(XAHelper.xidToString(this._tranID), this._theXAResource.toString(), "-", e2);
                int n = 8;
                return n;
            }
            finally {
                this.removeConnection();
            }
        } else {
            jtaLogger.i18NLogger.warn_resources_arjunacore_noresource(XAHelper.xidToString(this._tranID));
            if (_assumedComplete) {
                jtaLogger.i18NLogger.info_resources_arjunacore_assumecomplete(XAHelper.xidToString(this._tranID));
                return 7;
            }
            if (this._jndiName == null || !this.wasResourceContactedByRecoveryModule(this._jndiName)) return 8;
            jtaLogger.i18NLogger.info_resources_arjunacore_rmcompleted(XAHelper.xidToString(this._tranID));
            return 7;
        }
    }

    protected boolean notAProblem(XAException ex, boolean commit) {
        return XAResourceErrorHandler.notAProblem(this._theXAResource, ex, commit);
    }

    @Override
    public int nestedOnePhaseCommit() {
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public int topLevelOnePhaseCommit() {
        block38: {
            if (jtaLogger.logger.isTraceEnabled()) {
                jtaLogger.logger.trace((Object)("XAResourceRecord.topLevelOnePhaseCommit for " + this + ", record id=" + this.order()));
            }
            commit = true;
            if (this._tranID == null) {
                jtaLogger.i18NLogger.warn_resources_arjunacore_opcnulltx("XAResourceRecord.1pc");
                return 10;
            }
            if (this._theXAResource != null) {
                if (this._heuristic != 7) {
                    return this._heuristic;
                }
                endHeuristic = null;
                endRBOnly = null;
                try {
                    this.endAssociation(0x4000000, 1);
                }
                catch (XAException e1) {
                    switch (e1.errorCode) {
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            endHeuristic = e1;
                            break;
                        }
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: 
                        case 105: 
                        case 106: 
                        case 107: {
                            endRBOnly = e1;
                            commit = false;
                            break;
                        }
                        default: {
                            this.addDeferredThrowable(e1);
                            jtaLogger.i18NLogger.warn_resources_arjunacore_opcerror(XAHelper.xidToString(this._tranID), this._theXAResource.toString(), XAHelper.printXAErrorCode(e1), e1);
                            this.removeConnection();
                            return 10;
                        }
                    }
                }
                catch (RuntimeException e) {
                    jtaLogger.i18NLogger.warn_resources_arjunacore_opcerror(XAHelper.xidToString(this._tranID), this._theXAResource.toString(), "-", e);
                    throw e;
                }
                try {
                    if (endHeuristic != null) {
                        throw endHeuristic;
                    }
                    if (commit) {
                        this._theXAResource.commit(this._tranID, true);
                        break block38;
                    }
                    this._theXAResource.rollback(this._tranID);
                    throw endRBOnly;
                }
                catch (XAException e1) {
                    this.addDeferredThrowable(e1);
                    jtaLogger.i18NLogger.warn_resources_arjunacore_opcerror(XAHelper.xidToString(this._tranID), this._theXAResource.toString(), XAHelper.printXAErrorCode(e1), e1);
                    switch (e1.errorCode) {
                        case 5: 
                        case 8: {
                            this._heuristic = 6;
                            var5_8 = 6;
                            return var5_8;
                        }
                        case 7: {
                            this.forget();
                            ** break;
lbl52:
                            // 1 sources

                            break block38;
                        }
                        case 6: {
                            this.forget();
                            var5_9 = 10;
                            return var5_9;
                        }
                        case -3: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: 
                        case 105: 
                        case 106: 
                        case 107: {
                            var5_10 = 10;
                            return var5_10;
                        }
                        case -4: {
                            this._heuristic = 6;
                            var5_11 = 6;
                            return var5_11;
                        }
                        case -5: {
                            this._heuristic = 6;
                            var5_12 = 6;
                            return var5_12;
                        }
                        case -6: 
                        case 4: {
                            var5_13 = 10;
                            return var5_13;
                        }
                        case -7: {
                            this._heuristic = 6;
                            var5_14 = 6;
                            return var5_14;
                        }
                        default: {
                            this._committed = true;
                            var5_15 = 8;
                            return var5_15;
                        }
                    }
                }
                catch (Exception e2) {
                    jtaLogger.i18NLogger.warn_resources_arjunacore_opcerror(XAHelper.xidToString(this._tranID), this._theXAResource.toString(), "-", e2);
                    var5_16 = 8;
                    return var5_16;
                }
                finally {
                    this.removeConnection();
                }
            }
            return 10;
        }
        if (commit) {
            return 7;
        }
        return 8;
    }

    @Override
    public void clearHeuristicDecision() {
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.tracef("XAResourceRecord.clearHeuristicDecisition for %s changing from %d to %d", (Object)this, (Object)this._heuristic, (Object)7);
        }
        this._heuristic = 7;
    }

    @Override
    public boolean forgetHeuristic() {
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)("XAResourceRecord.forget for " + this));
        }
        this.forget();
        this.removeConnection();
        return this._forgotten;
    }

    private void forget() {
        if (this._theXAResource != null && this._tranID != null) {
            try {
                this._theXAResource.forget(this._tranID);
                this._heuristic = 7;
                this._forgotten = true;
            }
            catch (Exception e) {
                jtaLogger.i18NLogger.warn_recovery_forgetfailed("XAResourceRecord forget failed:", e);
                this._forgotten = false;
            }
        }
    }

    protected int recover() {
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)"XAResourceRecord.recover");
        }
        if (this._committed) {
            if (this.topLevelCommit() == 7) {
                return 1;
            }
            return 2;
        }
        return 3;
    }

    @Override
    public boolean save_state(OutputObjectState os, int t) {
        boolean res = false;
        try {
            os.packInt(this._heuristic);
            os.packBoolean(this._committed);
            XidImple.pack(os, this._tranID);
            if (this._recoveryObject == null) {
                os.packInt(1);
                os.packString(this._productName);
                os.packString(this._productVersion);
                os.packString(this._jndiName);
                if (this._theXAResource instanceof Serializable) {
                    try {
                        ByteArrayOutputStream s = new ByteArrayOutputStream();
                        ObjectOutputStream o = new ObjectOutputStream(s);
                        o.writeObject(this._theXAResource);
                        o.close();
                        os.packBoolean(true);
                        String name = this._theXAResource.getClass().getName();
                        os.packString(name);
                        os.packBytes(s.toByteArray());
                    }
                    catch (NotSerializableException ex) {
                        jtaLogger.i18NLogger.warn_resources_arjunacore_savestate();
                        return false;
                    }
                } else {
                    os.packBoolean(false);
                }
            } else {
                os.packInt(0);
                os.packString(this._recoveryObject.getClass().getName());
                this._recoveryObject.packInto(os);
            }
            res = true;
        }
        catch (Exception e) {
            jtaLogger.i18NLogger.warn_resources_arjunacore_savestateerror(this._theXAResource.toString(), XAHelper.xidToString(this._tranID), e);
            res = false;
        }
        if (res) {
            res = super.save_state(os, t);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restore_state(InputObjectState os, int t) {
        boolean res = false;
        try {
            this._heuristic = os.unpackInt();
            this._committed = os.unpackBoolean();
            this._tranID = XidImple.unpack(os);
            this._theXAResource = null;
            this._recoveryObject = null;
            if (os.unpackInt() == 1) {
                this._productName = os.unpackString();
                this._productVersion = os.unpackString();
                this._jndiName = os.unpackString();
                boolean haveXAResource = os.unpackBoolean();
                if (haveXAResource) {
                    try {
                        String className = os.unpackString();
                        byte[] b = os.unpackBytes();
                        ByteArrayInputStream s = new ByteArrayInputStream(b);
                        ObjectInputStream o = new ObjectInputStream(s);
                        boolean deserialized = false;
                        for (SerializableXAResourceDeserializer proxyXAResourceDeserializer : this.getXAResourceDeserializers()) {
                            if (!proxyXAResourceDeserializer.canDeserialze(className)) continue;
                            this._theXAResource = proxyXAResourceDeserializer.deserialze(o);
                            deserialized = true;
                            break;
                        }
                        if (!deserialized) {
                            try {
                                this._theXAResource = (XAResource)o.readObject();
                                if (jtaLogger.logger.isTraceEnabled()) {
                                    jtaLogger.logger.trace((Object)"XAResourceRecord.restore_state - XAResource de-serialized");
                                }
                            }
                            catch (ClassNotFoundException e) {
                                jtaLogger.i18NLogger.warn_resources_arjunacore_classnotfound(className);
                                haveXAResource = false;
                            }
                        }
                        o.close();
                    }
                    catch (Exception ex) {
                        jtaLogger.i18NLogger.warn_resources_arjunacore_restorestate(ex);
                        boolean bl = false;
                        if (res) {
                            res = super.restore_state(os, t);
                        }
                        if (this._heuristic != 7) {
                            jtaLogger.logger.warn((Object)("XAResourceRecord restored heuristic instance: " + this));
                        }
                        return bl;
                    }
                }
                if (!haveXAResource) {
                    this._theXAResource = this.getNewXAResource();
                    if (this._theXAResource == null) {
                        jtaLogger.i18NLogger.warn_resources_arjunacore_norecoveryxa(this.toString());
                        res = true;
                    }
                }
            } else {
                String creatorName = os.unpackString();
                this._recoveryObject = ClassloadingUtility.loadAndInstantiateClass(RecoverableXAConnection.class, creatorName, null);
                if (this._recoveryObject == null) {
                    throw new ClassNotFoundException();
                }
                this._recoveryObject.unpackFrom(os);
                this._theXAResource = this._recoveryObject.getResource();
                if (jtaLogger.logger.isTraceEnabled()) {
                    jtaLogger.logger.trace((Object)("XAResourceRecord.restore_state - XAResource got from " + creatorName));
                }
            }
            res = true;
        }
        catch (Exception e) {
            jtaLogger.i18NLogger.warn_resources_arjunacore_restorestateerror(this._theXAResource.toString(), XAHelper.xidToString(this._tranID), e);
            res = false;
        }
        finally {
            if (res) {
                res = super.restore_state(os, t);
            }
            if (this._heuristic != 7) {
                jtaLogger.logger.warn((Object)("XAResourceRecord restored heuristic instance: " + this));
            }
        }
        return res;
    }

    @Override
    public String type() {
        return XAResourceRecord.typeName();
    }

    public static String typeName() {
        return "/StateManager/AbstractRecord/XAResourceRecord";
    }

    @Override
    public boolean doSave() {
        return true;
    }

    @Override
    public void merge(AbstractRecord a) {
    }

    @Override
    public void alter(AbstractRecord a) {
    }

    @Override
    public boolean shouldAdd(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldAlter(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldMerge(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldReplace(AbstractRecord a) {
        return false;
    }

    public String getProductName() {
        return this._productName;
    }

    public void setProductName(String productName) {
        this._productName = productName;
    }

    public String getProductVersion() {
        return this._productVersion;
    }

    public void setProductVersion(String productVersion) {
        this._productVersion = productVersion;
    }

    public String getJndiName() {
        return this._jndiName;
    }

    public void setJndiName(String jndiName) {
        this._jndiName = jndiName;
    }

    public XAResourceRecord() {
        this._theXAResource = null;
        this._recoveryObject = null;
        this._tranID = null;
        this._prepared = true;
        this._heuristic = 7;
        this._valid = true;
        this._theTransaction = null;
        this._recovered = true;
    }

    public XAResourceRecord(Uid u) {
        super(u, null, 1);
        this._theXAResource = null;
        this._recoveryObject = null;
        this._tranID = null;
        this._prepared = true;
        this._heuristic = 7;
        this._valid = true;
        this._theTransaction = null;
        this._recovered = true;
    }

    public String toString() {
        return "XAResourceRecord < resource:" + this._theXAResource + ", txid:" + this._tranID + ", heuristic: " + TwoPhaseOutcome.stringForm(this._heuristic) + (this._productName != null && this._productVersion != null ? ", product: " + this._productName + "/" + this._productVersion : "") + (this._jndiName != null ? ", jndiName: " + this._jndiName : "") + " " + super.toString() + " >";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SerializableXAResourceDeserializer> getXAResourceDeserializers() {
        if (this.serializableXAResourceDeserializers != null) {
            return this.serializableXAResourceDeserializers;
        }
        XAResourceRecord xAResourceRecord = this;
        synchronized (xAResourceRecord) {
            if (this.serializableXAResourceDeserializers != null) {
                return this.serializableXAResourceDeserializers;
            }
            this.serializableXAResourceDeserializers = new ArrayList<SerializableXAResourceDeserializer>();
            for (RecoveryModule recoveryModule : RecoveryManager.manager().getModules()) {
                if (!(recoveryModule instanceof XARecoveryModule)) continue;
                XARecoveryModule xaRecoveryModule = (XARecoveryModule)recoveryModule;
                this.serializableXAResourceDeserializers.addAll(xaRecoveryModule.getSeriablizableXAResourceDeserializers());
                return this.serializableXAResourceDeserializers;
            }
        }
        return this.serializableXAResourceDeserializers;
    }

    private final XAResource getNewXAResource() {
        RecoveryManager recMan = RecoveryManager.manager();
        Vector<RecoveryModule> recoveryModules = recMan.getModules();
        if (recoveryModules != null) {
            Enumeration<RecoveryModule> modules = recoveryModules.elements();
            while (modules.hasMoreElements()) {
                RecoveryModule m = modules.nextElement();
                if (!(m instanceof XARecoveryModule)) continue;
                return ((XARecoveryModule)m).getNewXAResource(this);
            }
        }
        return null;
    }

    private final void removeConnection() {
        if (this._recoveryObject != null) {
            this._recoveryObject.close();
        }
        if (this._theTransaction != null) {
            this._theTransaction = null;
        }
    }

    private void endAssociation(int xaState, int txInfoState) throws XAException {
        if (this._theTransaction != null) {
            this._theTransaction.endAssociation(this._tranID, this._theXAResource, xaState, txInfoState);
        }
    }

    private boolean wasResourceContactedByRecoveryModule(String jndiName) {
        Vector<RecoveryModule> recoveryModules = RecoveryManager.manager().getModules();
        for (RecoveryModule recoveryModule : recoveryModules) {
            if (!(recoveryModule instanceof XARecoveryModule)) continue;
            return ((XARecoveryModule)recoveryModule).getContactedJndiNames().contains(jndiName);
        }
        return false;
    }

    public int getHeuristic() {
        return this._heuristic;
    }

    public boolean isForgotten() {
        return this._forgotten;
    }

    void addDeferredThrowable(Exception e) {
        if (this.deferredExceptions == null) {
            this.deferredExceptions = new ArrayList<Throwable>();
        }
        this.deferredExceptions.add(e);
    }

    @Override
    public void getDeferredThrowables(List<Throwable> list2) {
        if (this.deferredExceptions != null) {
            list2.addAll(this.deferredExceptions);
        }
    }
}

