/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning.irac;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.irac.IracCleanupTombstoneCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.versioning.irac.IracTombstoneManager;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.impl.VoidResponseCollector;
import org.infinispan.util.ExponentialBackOff;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.irac.DefaultIracManager;
import org.infinispan.xsite.irac.IracExecutor;
import org.infinispan.xsite.irac.IracManager;
import org.infinispan.xsite.status.SiteState;
import org.infinispan.xsite.status.TakeOfflineManager;

@Scope(value=Scopes.NAMED_CACHE)
public class DefaultIracTombstoneManager
implements IracTombstoneManager {
    @Inject
    DistributionManager distributionManager;
    @Inject
    RpcManager rpcManager;
    @Inject
    CommandsFactory commandsFactory;
    @Inject
    TakeOfflineManager takeOfflineManager;
    @Inject
    ComponentRef<IracManager> iracManager;
    private final Map<Object, TombstoneData> tombstoneMap;
    private final IracExecutor iracExecutor = new IracExecutor(this::performCleanup);
    final Collection<XSiteBackup> asyncBackups;

    public DefaultIracTombstoneManager(Configuration configuration) {
        this.asyncBackups = DefaultIracManager.asyncBackups(configuration);
        this.tombstoneMap = new ConcurrentHashMap<Object, TombstoneData>();
    }

    @Inject
    public void inject(@ComponentName(value="org.infinispan.executors.timeout") ScheduledExecutorService executorService, @ComponentName(value="org.infinispan.executors.blocking") Executor blockingExecutor) {
        this.iracExecutor.setBackOff(ExponentialBackOff.NO_OP);
        this.iracExecutor.setExecutor(blockingExecutor);
        executorService.scheduleAtFixedRate(this.iracExecutor::run, 30L, 30L, TimeUnit.SECONDS);
    }

    @Override
    public void storeTombstone(int segment, Object key, IracMetadata metadata) {
        this.tombstoneMap.put(key, new TombstoneData(segment, metadata));
    }

    @Override
    public void storeTombstoneIfAbsent(int segment, Object key, IracMetadata metadata) {
        if (metadata == null) {
            return;
        }
        this.tombstoneMap.putIfAbsent(key, new TombstoneData(segment, metadata));
    }

    @Override
    public IracMetadata getTombstone(Object key) {
        TombstoneData data = this.tombstoneMap.get(key);
        return data == null ? null : data.getMetadata();
    }

    @Override
    public void removeTombstone(Object key, IracMetadata iracMetadata) {
        if (iracMetadata == null) {
            return;
        }
        this.remove(key, new TombstoneData(-1, iracMetadata));
    }

    @Override
    public void removeTombstone(Object key) {
        this.tombstoneMap.remove(key);
    }

    @Override
    public boolean isEmpty() {
        return this.tombstoneMap.isEmpty();
    }

    @Override
    public int size() {
        return this.tombstoneMap.size();
    }

    public void startCleanupTombstone() {
        this.iracExecutor.run();
    }

    private CompletionStage<Void> performCleanup() {
        AggregateCompletionStage<Void> stage = CompletionStages.aggregateCompletionStage();
        for (Map.Entry<Object, TombstoneData> entry : this.tombstoneMap.entrySet()) {
            DistributionInfo info = this.distributionManager.getCacheTopology().getSegmentDistribution(entry.getValue().getSegment());
            if (!info.isWriteOwner()) {
                this.remove(entry.getKey(), entry.getValue());
                continue;
            }
            if (!info.isPrimary() || this.iracManager.running().containsKey(entry.getKey())) continue;
            stage.dependsOn(new CleanupTask(entry.getKey(), entry.getValue()).checkRemoteSites());
        }
        return stage.freeze();
    }

    private void remove(Object key, TombstoneData data) {
        this.tombstoneMap.remove(key, data);
    }

    DistributionInfo getSegmentDistribution(int segment) {
        return this.distributionManager.getCacheTopology().getSegmentDistribution(segment);
    }

    private class CleanupTask
    implements Function<Boolean, CompletionStage<Void>>,
    Runnable {
        private final Object key;
        private final TombstoneData tombstone;

        private CleanupTask(Object key, TombstoneData tombstone) {
            this.key = key;
            this.tombstone = tombstone;
        }

        CompletionStage<Void> checkRemoteSites() {
            AggregateCompletionStage<Boolean> stage = CompletionStages.orBooleanAggregateCompletionStage();
            for (XSiteBackup backup : DefaultIracTombstoneManager.this.asyncBackups) {
                if (DefaultIracTombstoneManager.this.takeOfflineManager.getSiteState(backup.getSiteName()) == SiteState.OFFLINE) continue;
                IracCleanupTombstoneCommand cmd = DefaultIracTombstoneManager.this.commandsFactory.buildIracCleanupTombstoneCommand(this.key, null);
                stage.dependsOn(DefaultIracTombstoneManager.this.rpcManager.invokeXSite(backup, cmd));
            }
            return stage.freeze().exceptionally(CompletableFutures.toTrueFunction()).thenCompose(this);
        }

        @Override
        public CompletionStage<Void> apply(Boolean keepTombstone) {
            if (keepTombstone.booleanValue()) {
                return CompletableFutures.completedNull();
            }
            IracCleanupTombstoneCommand cmd = DefaultIracTombstoneManager.this.commandsFactory.buildIracCleanupTombstoneCommand(this.key, this.tombstone.getMetadata());
            return DefaultIracTombstoneManager.this.rpcManager.invokeCommand(DefaultIracTombstoneManager.this.getSegmentDistribution(this.tombstone.getSegment()).writeOwners(), (ReplicableCommand)cmd, VoidResponseCollector.validOnly(), DefaultIracTombstoneManager.this.rpcManager.getSyncRpcOptions()).thenRun(this);
        }

        @Override
        public void run() {
            DefaultIracTombstoneManager.this.remove(this.key, this.tombstone);
        }
    }

    private static class TombstoneData {
        private final int segment;
        private final IracMetadata metadata;

        private TombstoneData(int segment, IracMetadata metadata) {
            this.segment = segment;
            this.metadata = Objects.requireNonNull(metadata);
        }

        public int getSegment() {
            return this.segment;
        }

        public IracMetadata getMetadata() {
            return this.metadata;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TombstoneData that = (TombstoneData)o;
            return this.metadata.equals(that.metadata);
        }

        public int hashCode() {
            return this.metadata.hashCode();
        }
    }
}

