/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.ejb3.iiop.handle.HandleDelegateImpl;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.omg.CORBA.ORB;
import org.wildfly.iiop.openjdk.deployment.IIOPDeploymentMarker;
import org.wildfly.iiop.openjdk.service.CorbaORBService;

public class IIOPJndiBindingProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (moduleDescription == null) {
            return;
        }
        if (!IIOPDeploymentMarker.isIIOPDeployment((DeploymentUnit)deploymentUnit)) {
            return;
        }
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit) || DeploymentTypeMarker.isType((DeploymentType)DeploymentType.APPLICATION_CLIENT, (DeploymentUnit)deploymentUnit)) {
            ServiceName moduleContextServiceName = ContextNames.contextServiceNameOfModule((String)moduleDescription.getApplicationName(), (String)moduleDescription.getModuleName());
            this.bindService(serviceTarget, moduleContextServiceName, module);
        }
        for (ComponentDescription component : moduleDescription.getComponentDescriptions()) {
            if (component.getNamingMode() != ComponentNamingMode.CREATE) continue;
            ServiceName compContextServiceName = ContextNames.contextServiceNameOfComponent((String)moduleDescription.getApplicationName(), (String)moduleDescription.getModuleName(), (String)component.getComponentName());
            this.bindService(serviceTarget, compContextServiceName, module);
        }
    }

    private void bindService(ServiceTarget serviceTarget, ServiceName contextServiceName, Module module) {
        ServiceName orbServiceName = contextServiceName.append(new String[]{"ORB"});
        BinderService orbService = new BinderService("ORB");
        serviceTarget.addService(orbServiceName, (Service)orbService).addDependency(CorbaORBService.SERVICE_NAME, ORB.class, (Injector)new ManagedReferenceInjector((Injector)orbService.getManagedObjectInjector())).addDependency(contextServiceName, ServiceBasedNamingStore.class, (Injector)orbService.getNamingStoreInjector()).install();
        ServiceName handleDelegateServiceName = contextServiceName.append(new String[]{"HandleDelegate"});
        BinderService handleDelegateBindingService = new BinderService("HandleDelegate");
        handleDelegateBindingService.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory((Value)new ImmediateValue((Object)new HandleDelegateImpl((ClassLoader)module.getClassLoader()))));
        serviceTarget.addService(handleDelegateServiceName, (Service)handleDelegateBindingService).addDependency(contextServiceName, ServiceBasedNamingStore.class, (Injector)handleDelegateBindingService.getNamingStoreInjector()).install();
    }
}

