/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.schedule;

import jakarta.ejb.ScheduleExpression;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.TimeZone;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.schedule.attribute.DayOfMonth;
import org.jboss.as.ejb3.timerservice.schedule.attribute.DayOfWeek;
import org.jboss.as.ejb3.timerservice.schedule.attribute.Hour;
import org.jboss.as.ejb3.timerservice.schedule.attribute.Minute;
import org.jboss.as.ejb3.timerservice.schedule.attribute.Month;
import org.jboss.as.ejb3.timerservice.schedule.attribute.Second;
import org.jboss.as.ejb3.timerservice.schedule.attribute.Year;

public class CalendarBasedTimeout {
    private ScheduleExpression scheduleExpression;
    private Second second;
    private Minute minute;
    private Hour hour;
    private DayOfWeek dayOfWeek;
    private DayOfMonth dayOfMonth;
    private Month month;
    private Year year;
    private Calendar firstTimeout;
    private TimeZone timezone;

    public CalendarBasedTimeout(ScheduleExpression schedule) {
        if (schedule == null) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidScheduleExpression(this.getClass().getName());
        }
        this.nullCheckScheduleAttributes(schedule);
        this.scheduleExpression = this.clone(schedule);
        this.second = new Second(schedule.getSecond());
        this.minute = new Minute(schedule.getMinute());
        this.hour = new Hour(schedule.getHour());
        this.dayOfWeek = new DayOfWeek(schedule.getDayOfWeek());
        this.dayOfMonth = new DayOfMonth(schedule.getDayOfMonth());
        this.month = new Month(schedule.getMonth());
        this.year = new Year(schedule.getYear());
        String timezoneId = schedule.getTimezone();
        if (timezoneId != null && !(timezoneId = timezoneId.trim()).isEmpty()) {
            String[] availableTimeZoneIDs = TimeZone.getAvailableIDs();
            if (availableTimeZoneIDs != null && Arrays.asList(availableTimeZoneIDs).contains(timezoneId)) {
                this.timezone = TimeZone.getTimeZone(timezoneId);
            } else {
                this.timezone = TimeZone.getDefault();
                EjbLogger.EJB3_TIMER_LOGGER.unknownTimezoneId(timezoneId, this.timezone.getID());
            }
        } else {
            this.timezone = TimeZone.getDefault();
        }
        this.setFirstTimeout();
    }

    public static boolean doesScheduleMatch(ScheduleExpression expression1, ScheduleExpression expression2) {
        return Objects.equals(expression1.getHour(), expression2.getHour()) && Objects.equals(expression1.getMinute(), expression2.getMinute()) && Objects.equals(expression1.getMonth(), expression2.getMonth()) && Objects.equals(expression1.getSecond(), expression2.getSecond()) && Objects.equals(expression1.getDayOfMonth(), expression2.getDayOfMonth()) && Objects.equals(expression1.getDayOfWeek(), expression2.getDayOfWeek()) && Objects.equals(expression1.getYear(), expression2.getYear()) && Objects.equals(expression1.getTimezone(), expression2.getTimezone()) && Objects.equals(expression1.getEnd(), expression2.getEnd()) && Objects.equals(expression1.getStart(), expression2.getStart());
    }

    public Calendar getNextTimeout() {
        return this.getNextTimeout(new GregorianCalendar(this.timezone), true);
    }

    public Calendar getFirstTimeout() {
        return this.firstTimeout;
    }

    private void setFirstTimeout() {
        GregorianCalendar currentCal = new GregorianCalendar(this.timezone);
        Date start = this.scheduleExpression.getStart();
        if (start != null) {
            currentCal.setTime(start);
        } else {
            this.resetTimeToFirstValues(currentCal);
        }
        this.firstTimeout = this.getNextTimeout(currentCal, false);
    }

    public ScheduleExpression getScheduleExpression() {
        return this.scheduleExpression;
    }

    public Calendar getNextTimeout(Calendar currentCal) {
        return this.getNextTimeout(currentCal, true);
    }

    private Calendar getNextTimeout(Calendar currentCal, boolean increment) {
        if (this.noMoreTimeouts(currentCal)) {
            return null;
        }
        Calendar nextCal = (Calendar)currentCal.clone();
        nextCal.setTimeZone(this.timezone);
        Date start = this.scheduleExpression.getStart();
        if (start != null && currentCal.getTime().before(start)) {
            nextCal.setTime(start);
        } else {
            if (increment) {
                nextCal.add(13, 1);
            }
            nextCal.add(14, -nextCal.get(14));
        }
        nextCal.setFirstDayOfWeek(1);
        nextCal = this.computeNextTime(nextCal);
        if (nextCal == null) {
            return null;
        }
        if ((nextCal = this.computeNextMonth(nextCal)) == null) {
            return null;
        }
        if ((nextCal = this.computeNextDate(nextCal)) == null) {
            return null;
        }
        if ((nextCal = this.computeNextYear(nextCal)) == null) {
            return null;
        }
        if (this.noMoreTimeouts(nextCal)) {
            return null;
        }
        return nextCal;
    }

    private Calendar computeNextTime(Calendar nextCal) {
        int nextTimeInSeconds;
        Integer nextHour;
        Integer nextMinute;
        int currentSecond = nextCal.get(13);
        int currentMinute = nextCal.get(12);
        int currentHour = nextCal.get(11);
        int currentTimeInSeconds = currentHour * 3600 + currentMinute * 60 + currentSecond;
        Integer nextSecond = this.second.getNextMatch(currentSecond);
        if (nextSecond == null) {
            return null;
        }
        if (nextSecond < currentSecond) {
            ++currentMinute;
        }
        if ((nextMinute = this.minute.getNextMatch(currentMinute < 60 ? currentMinute : 0)) == null) {
            return null;
        }
        if (nextMinute != currentMinute) {
            nextSecond = this.second.getNextMatch(0);
        }
        if (nextMinute < currentMinute) {
            ++currentHour;
        }
        if ((nextHour = this.hour.getNextMatch(currentHour < 24 ? currentHour : 0)) == null) {
            return null;
        }
        if (nextHour != currentHour) {
            nextSecond = this.second.getNextMatch(0);
            nextMinute = this.minute.getNextMatch(0);
        }
        if ((nextTimeInSeconds = nextHour * 3600 + nextMinute * 60 + nextSecond) == currentTimeInSeconds) {
            return nextCal;
        }
        this.setTime(nextCal, nextHour, nextMinute, nextSecond);
        if (nextTimeInSeconds < currentTimeInSeconds) {
            nextCal.add(5, 1);
        }
        return nextCal;
    }

    private Calendar computeNextDayOfWeek(Calendar nextCal) {
        Integer nextDayOfWeek = this.dayOfWeek.getNextMatch(nextCal);
        if (nextDayOfWeek == null) {
            return null;
        }
        int currentDayOfWeek = nextCal.get(7);
        if (currentDayOfWeek == nextDayOfWeek) {
            return nextCal;
        }
        int currentMonth = nextCal.get(2);
        if (nextDayOfWeek < currentDayOfWeek) {
            nextCal.add(4, 1);
        }
        nextCal.set(7, nextDayOfWeek);
        this.resetTimeToFirstValues(nextCal);
        if (nextCal.get(2) != currentMonth) {
            nextCal = this.computeNextMonth(nextCal);
        }
        return nextCal;
    }

    private Calendar computeNextMonth(Calendar nextCal) {
        Integer nextMonth = this.month.getNextMatch(nextCal);
        if (nextMonth == null) {
            return null;
        }
        int currentMonth = nextCal.get(2);
        if (currentMonth == nextMonth) {
            return nextCal;
        }
        if (nextMonth < currentMonth) {
            nextCal.add(1, 1);
        }
        nextCal.set(2, nextMonth);
        nextCal.set(7, this.dayOfWeek.getFirst());
        nextCal.set(5, 1);
        this.resetTimeToFirstValues(nextCal);
        return nextCal;
    }

    private Calendar computeNextDate(Calendar nextCal) {
        if (this.isDayOfMonthWildcard()) {
            return this.computeNextDayOfWeek(nextCal);
        }
        if (this.isDayOfWeekWildcard()) {
            return this.computeNextDayOfMonth(nextCal);
        }
        Calendar nextDayOfMonthCal = this.computeNextDayOfMonth((Calendar)nextCal.clone());
        Calendar nextDayOfWeekCal = this.computeNextDayOfWeek((Calendar)nextCal.clone());
        if (nextDayOfMonthCal == null) {
            return nextDayOfWeekCal;
        }
        if (nextDayOfWeekCal == null) {
            return nextDayOfMonthCal;
        }
        return nextDayOfWeekCal.getTime().before(nextDayOfMonthCal.getTime()) ? nextDayOfWeekCal : nextDayOfMonthCal;
    }

    private Calendar computeNextDayOfMonth(Calendar nextCal) {
        Integer nextDayOfMonth = this.dayOfMonth.getNextMatch(nextCal);
        if (nextDayOfMonth == null) {
            return null;
        }
        int currentDayOfMonth = nextCal.get(5);
        if (currentDayOfMonth == nextDayOfMonth) {
            return nextCal;
        }
        if (nextDayOfMonth > currentDayOfMonth) {
            if (this.monthHasDate(nextCal, nextDayOfMonth)) {
                nextCal.set(5, nextDayOfMonth);
                this.resetTimeToFirstValues(nextCal);
            } else {
                nextCal = this.advanceTillMonthHasDate(nextCal, nextDayOfMonth);
            }
        } else {
            nextCal.add(2, 1);
            this.resetTimeToFirstValues(nextCal);
            nextCal = this.computeNextMonth(nextCal);
            if (nextCal == null) {
                return null;
            }
            nextDayOfMonth = this.dayOfMonth.getFirstMatch(nextCal);
            if (nextDayOfMonth == null) {
                return null;
            }
            nextCal = this.advanceTillMonthHasDate(nextCal, nextDayOfMonth);
        }
        return nextCal;
    }

    private Calendar computeNextYear(Calendar nextCal) {
        Integer nextYear = this.year.getNextMatch(nextCal);
        if (nextYear == null || nextYear > Year.MAX_YEAR) {
            return null;
        }
        int currentYear = nextCal.get(1);
        if (currentYear == nextYear) {
            return nextCal;
        }
        if (nextYear < currentYear) {
            return null;
        }
        nextCal.set(1, nextYear);
        nextCal.set(2, this.month.getFirstMatch());
        nextCal.set(5, 1);
        this.resetTimeToFirstValues(nextCal);
        nextCal = this.computeNextDate(nextCal);
        return nextCal;
    }

    private Calendar advanceTillMonthHasDate(Calendar cal, Integer date) {
        this.resetTimeToFirstValues(cal);
        while (!this.monthHasDate(cal, date)) {
            if (cal.get(1) > Year.MAX_YEAR) {
                return null;
            }
            cal.add(2, 1);
            cal = this.computeNextMonth(cal);
            if (cal == null) {
                return null;
            }
            date = this.dayOfMonth.getFirstMatch(cal);
            if (date != null) continue;
            return null;
        }
        cal.set(5, date);
        return cal;
    }

    private boolean monthHasDate(Calendar cal, int date) {
        return date <= cal.getActualMaximum(5);
    }

    private boolean isAfterEnd(Calendar cal) {
        Date end = this.scheduleExpression.getEnd();
        if (end == null) {
            return false;
        }
        return cal.getTime().after(end);
    }

    private boolean noMoreTimeouts(Calendar cal) {
        return cal.get(1) > Year.MAX_YEAR || this.isAfterEnd(cal);
    }

    private boolean isDayOfWeekWildcard() {
        return this.scheduleExpression.getDayOfWeek().equals("*");
    }

    private boolean isDayOfMonthWildcard() {
        return this.scheduleExpression.getDayOfMonth().equals("*");
    }

    private void nullCheckScheduleAttributes(ScheduleExpression schedule) {
        if (schedule.getSecond() == null) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidScheduleExpressionSecond(schedule);
        }
        if (schedule.getMinute() == null) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidScheduleExpressionMinute(schedule);
        }
        if (schedule.getHour() == null) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidScheduleExpressionHour(schedule);
        }
        if (schedule.getDayOfMonth() == null) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidScheduleExpressionDayOfMonth(schedule);
        }
        if (schedule.getDayOfWeek() == null) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidScheduleExpressionDayOfWeek(schedule);
        }
        if (schedule.getMonth() == null) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidScheduleExpressionMonth(schedule);
        }
        if (schedule.getYear() == null) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidScheduleExpressionYear(schedule);
        }
    }

    private ScheduleExpression clone(ScheduleExpression schedule) {
        ScheduleExpression clonedSchedule = new ScheduleExpression();
        clonedSchedule.second(schedule.getSecond());
        clonedSchedule.minute(schedule.getMinute());
        clonedSchedule.hour(schedule.getHour());
        clonedSchedule.dayOfWeek(schedule.getDayOfWeek());
        clonedSchedule.dayOfMonth(schedule.getDayOfMonth());
        clonedSchedule.month(schedule.getMonth());
        clonedSchedule.year(schedule.getYear());
        clonedSchedule.timezone(schedule.getTimezone());
        clonedSchedule.start(schedule.getStart());
        clonedSchedule.end(schedule.getEnd());
        return clonedSchedule;
    }

    private void resetTimeToFirstValues(Calendar calendar) {
        int currentHour = calendar.get(11);
        int currentMinute = calendar.get(12);
        int currentSecond = calendar.get(13);
        int firstHour = this.hour.getFirst();
        int firstMinute = this.minute.getFirst();
        int firstSecond = this.second.getFirst();
        if (currentHour != firstHour || currentMinute != firstMinute || currentSecond != firstSecond) {
            this.setTime(calendar, firstHour, firstMinute, firstSecond);
        }
    }

    private void setTime(Calendar calendar, int hour, int minute, int second) {
        int dst = calendar.get(16);
        calendar.clear(11);
        calendar.set(11, hour);
        calendar.clear(12);
        calendar.set(12, minute);
        calendar.clear(13);
        calendar.set(13, second);
        calendar.set(16, dst);
    }
}

