/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds;

import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.ds.Driver;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;

public class DriverImpl
implements Driver {
    private static final long serialVersionUID = 6228505574424288182L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    private final String name;
    private final Integer minorVersion;
    private final Integer majorVersion;
    private final String module;
    private final String driverClass;
    private final String dataSourceClass;
    private final String xaDataSourceClass;

    public DriverImpl(String name, Integer majorVersion, Integer minorVersion, String module, String driverClass, String dataSourceClass, String xaDataSourceClass) throws ValidateException {
        this.name = name;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.module = module;
        this.driverClass = driverClass;
        this.dataSourceClass = dataSourceClass;
        this.xaDataSourceClass = xaDataSourceClass;
        this.validate();
    }

    public final String getName() {
        return this.name;
    }

    public final String getModule() {
        return this.module;
    }

    public final String getDriverClass() {
        return this.driverClass;
    }

    public final String getDataSourceClass() {
        return this.dataSourceClass;
    }

    public final String getXaDataSourceClass() {
        return this.xaDataSourceClass;
    }

    public void validate() throws ValidateException {
        if (this.name == null || this.name.trim().length() == 0) {
            throw new ValidateException(bundle.requiredAttributeMissing(Driver.Attribute.NAME.getLocalName(), this.getClass().getCanonicalName()));
        }
    }

    public Integer getMajorVersion() {
        return this.majorVersion;
    }

    public Integer getMinorVersion() {
        return this.minorVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<driver");
        if (this.name != null) {
            sb.append(" ").append(Driver.Attribute.NAME).append("=\"").append(this.name).append("\"");
        }
        if (this.module != null) {
            sb.append(" ").append(Driver.Attribute.MODULE).append("=\"").append(this.module).append("\"");
        }
        if (this.majorVersion != null) {
            sb.append(" ").append(Driver.Attribute.MAJOR_VERSION).append("=\"").append(this.majorVersion).append("\"");
        }
        if (this.minorVersion != null) {
            sb.append(" ").append(Driver.Attribute.MINOR_VERSION).append("=\"").append(this.minorVersion).append("\"");
        }
        sb.append(">");
        if (this.driverClass != null) {
            sb.append("<").append(Driver.Tag.DRIVER_CLASS).append(">");
            sb.append(this.driverClass);
            sb.append("</").append(Driver.Tag.DRIVER_CLASS).append(">");
        }
        if (this.dataSourceClass != null) {
            sb.append("<").append(Driver.Tag.DATASOURCE_CLASS).append(">");
            sb.append(this.dataSourceClass);
            sb.append("</").append(Driver.Tag.DATASOURCE_CLASS).append(">");
        }
        if (this.xaDataSourceClass != null) {
            sb.append("<").append(Driver.Tag.XA_DATASOURCE_CLASS).append(">");
            sb.append(this.xaDataSourceClass);
            sb.append("</").append(Driver.Tag.XA_DATASOURCE_CLASS).append(">");
        }
        sb.append("</driver>");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.driverClass == null ? 0 : this.driverClass.hashCode());
        result = 31 * result + (this.majorVersion == null ? 0 : this.majorVersion.hashCode());
        result = 31 * result + (this.minorVersion == null ? 0 : this.minorVersion.hashCode());
        result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.dataSourceClass == null ? 0 : this.dataSourceClass.hashCode());
        result = 31 * result + (this.xaDataSourceClass == null ? 0 : this.xaDataSourceClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DriverImpl)) {
            return false;
        }
        DriverImpl other = (DriverImpl)obj;
        if (this.driverClass == null ? other.driverClass != null : !this.driverClass.equals(other.driverClass)) {
            return false;
        }
        if (this.majorVersion == null ? other.majorVersion != null : !this.majorVersion.equals(other.majorVersion)) {
            return false;
        }
        if (this.minorVersion == null ? other.minorVersion != null : !this.minorVersion.equals(other.minorVersion)) {
            return false;
        }
        if (this.module == null ? other.module != null : !this.module.equals(other.module)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.dataSourceClass == null ? other.dataSourceClass != null : !this.dataSourceClass.equals(other.dataSourceClass)) {
            return false;
        }
        return !(this.xaDataSourceClass == null ? other.xaDataSourceClass != null : !this.xaDataSourceClass.equals(other.xaDataSourceClass));
    }
}

