/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.security.idm.Account;
import java.io.IOException;
import java.security.Principal;
import java.util.LinkedList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.extension.undertow.security.AccountImpl;

public class AuthenticatedSessionMarshaller
implements ProtoStreamMarshaller<AuthenticatedSessionManager.AuthenticatedSession> {
    private static final int MECHANISM_INDEX = 1;
    private static final int PRINCIPAL_INDEX = 2;
    private static final int ROLE_INDEX = 3;
    private static final int CREDENTIAL_INDEX = 4;
    private static final int ORIGINAL_INDEX = 5;
    private static final String DEFAULT_MECHANISM = "FORM";

    public AuthenticatedSessionManager.AuthenticatedSession readFrom(ProtoStreamReader reader) throws IOException {
        String mechanism = DEFAULT_MECHANISM;
        Principal principal = null;
        LinkedList<String> roles = new LinkedList<String>();
        Object credential = null;
        Principal original = null;
        block7: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    mechanism = reader.readString();
                    continue block7;
                }
                case 2: {
                    principal = new AccountImpl(reader.readString()).getPrincipal();
                    continue block7;
                }
                case 3: {
                    roles.add(reader.readString());
                    continue block7;
                }
                case 4: {
                    credential = reader.readAny();
                    continue block7;
                }
                case 5: {
                    original = new AccountImpl(reader.readString()).getPrincipal();
                    continue block7;
                }
            }
            reader.skipField(tag);
        }
        AccountImpl account = new AccountImpl(principal, new CopyOnWriteArraySet(roles), credential, original);
        return new AuthenticatedSessionManager.AuthenticatedSession((Account)account, mechanism);
    }

    public void writeTo(ProtoStreamWriter writer, AuthenticatedSessionManager.AuthenticatedSession auth) throws IOException {
        Principal original;
        AccountImpl account;
        Principal principal;
        String mechanism = auth.getMechanism();
        if (!mechanism.equals(DEFAULT_MECHANISM)) {
            writer.writeString(1, mechanism);
        }
        if ((principal = (account = (AccountImpl)auth.getAccount()).getPrincipal()) != null) {
            writer.writeString(2, principal.getName());
        }
        for (String role : account.getRoles()) {
            writer.writeString(3, role);
        }
        Object credential = account.getCredential();
        if (credential != null) {
            writer.writeAny(4, credential);
        }
        if ((original = account.getOriginalPrincipal()) != null) {
            writer.writeString(5, original.getName());
        }
    }

    public Class<? extends AuthenticatedSessionManager.AuthenticatedSession> getJavaClass() {
        return AuthenticatedSessionManager.AuthenticatedSession.class;
    }
}

