/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.webservices.deployers.WSComponentInstanceAssociationInterceptor;
import org.jboss.as.webservices.injection.WSComponentDescription;
import org.jboss.as.webservices.service.EndpointService;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.DotNames;
import org.jboss.invocation.AccessCheckingInterceptor;
import org.jboss.jandex.ClassInfo;
import org.jboss.msc.service.ServiceName;

public abstract class AbstractIntegrationProcessorJAXWS
implements DeploymentUnitProcessor {
    protected AbstractIntegrationProcessorJAXWS() {
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)unit)) {
            return;
        }
        CompositeIndex index = (CompositeIndex)unit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (index == null) {
            return;
        }
        EEModuleDescription eeModuleDescription = (EEModuleDescription)unit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        this.processAnnotation(unit, eeModuleDescription);
    }

    protected abstract void processAnnotation(DeploymentUnit var1, EEModuleDescription var2) throws DeploymentUnitProcessingException;

    static ComponentDescription createComponentDescription(DeploymentUnit unit, String componentName, String componentClassName, String dependsOnEndpointClassName) {
        EEModuleDescription moduleDescription = (EEModuleDescription)ASHelper.getRequiredAttachment(unit, Attachments.EE_MODULE_DESCRIPTION);
        moduleDescription.removeComponent(componentName, componentClassName);
        WSComponentDescription componentDescription = new WSComponentDescription(componentName, componentClassName, moduleDescription, unit.getServiceName());
        moduleDescription.addComponent((ComponentDescription)componentDescription);
        ServiceName endpointServiceName = EndpointService.getServiceName(unit, dependsOnEndpointClassName);
        componentDescription.addDependency(endpointServiceName);
        return componentDescription;
    }

    static ServiceName registerView(ComponentDescription componentDescription, String componentClassName) {
        ViewDescription pojoView = new ViewDescription(componentDescription, componentClassName);
        componentDescription.getViews().add(pojoView);
        pojoView.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.addViewInterceptor(AccessCheckingInterceptor.getFactory(), 1);
                configuration.addViewInterceptor(WSComponentInstanceAssociationInterceptor.FACTORY, 1792);
            }
        });
        return pojoView.getServiceName();
    }

    static boolean isEjb3(ClassInfo clazz) {
        return clazz.annotations().containsKey(DotNames.STATELESS_ANNOTATION) || clazz.annotations().containsKey(DotNames.SINGLETON_ANNOTATION);
    }
}

