/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.wildfly.clustering.web.cache.session.SessionAttributesFilter;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;

public class ImmutableSessionAttributesFilter
implements SessionAttributesFilter {
    private final ImmutableSessionAttributes attributes;

    public ImmutableSessionAttributesFilter(ImmutableSession session) {
        this(session.getAttributes());
    }

    public ImmutableSessionAttributesFilter(ImmutableSessionAttributes attributes) {
        this.attributes = attributes;
    }

    @Override
    public <T> Map<String, T> getAttributes(Class<T> targetClass) {
        Set names = this.attributes.getAttributeNames();
        if (names.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, T> result = new HashMap<String, T>(names.size());
        for (String name : names) {
            Object attribute = this.attributes.getAttribute(name);
            if (!targetClass.isInstance(attribute)) continue;
            result.put(name, targetClass.cast(attribute));
        }
        return Collections.unmodifiableMap(result);
    }
}

