/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.jboss.as.clustering.context.DefaultExecutorService;
import org.jboss.as.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Key;
import org.wildfly.clustering.ee.Recordable;
import org.wildfly.clustering.ee.Scheduler;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.cache.ConcurrentManager;
import org.wildfly.clustering.ee.cache.IdentifierFactory;
import org.wildfly.clustering.ee.cache.SimpleManager;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.infinispan.PrimaryOwnerLocator;
import org.wildfly.clustering.ee.infinispan.affinity.AffinityIdentifierFactory;
import org.wildfly.clustering.ee.infinispan.scheduler.PrimaryOwnerScheduler;
import org.wildfly.clustering.ee.infinispan.scheduler.ScheduleLocalKeysTask;
import org.wildfly.clustering.ee.infinispan.scheduler.ScheduleWithMetaDataCommand;
import org.wildfly.clustering.ee.infinispan.scheduler.ScheduleWithTransientMetaDataCommand;
import org.wildfly.clustering.ee.infinispan.scheduler.SchedulerListener;
import org.wildfly.clustering.ee.infinispan.scheduler.SchedulerTopologyChangeListener;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.spi.distribution.CacheLocality;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;
import org.wildfly.clustering.infinispan.spi.distribution.SimpleLocality;
import org.wildfly.clustering.marshalling.spi.MarshalledValue;
import org.wildfly.clustering.spi.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.web.cache.session.CompositeSessionFactory;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.ConcurrentSessionManager;
import org.wildfly.clustering.web.cache.session.MarshalledValueSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.web.cache.session.SessionAttributeActivationNotifier;
import org.wildfly.clustering.web.cache.session.SessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.session.AbstractInfinispanSessionMetaDataFactory;
import org.wildfly.clustering.web.infinispan.session.ExpiredSessionRemover;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManager;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerConfiguration;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionMetaDataFactory;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionMetaDataFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.session.LockOnReadInfinispanSessionMetaDataFactory;
import org.wildfly.clustering.web.infinispan.session.SessionAttributeActivationNotifierFactory;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKeyFilter;
import org.wildfly.clustering.web.infinispan.session.SessionExpirationScheduler;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionAttributesFactory;
import org.wildfly.clustering.web.infinispan.session.fine.FineSessionAttributesFactory;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionExpirationMetaData;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SpecificationProvider;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

public class InfinispanSessionManagerFactory<S, SC, AL, MC, LC>
implements SessionManagerFactory<SC, LC, TransactionBatch>,
Runnable {
    final Batcher<TransactionBatch> batcher;
    final Registrar<SessionExpirationListener> expirationRegistrar;
    final CacheProperties properties;
    final Cache<Key<String>, ?> cache;
    final Scheduler<String, SessionExpirationMetaData> scheduler;
    final SpecificationProvider<S, SC, AL> provider;
    final ExecutorService executor = Executors.newCachedThreadPool((ThreadFactory)new DefaultThreadFactory(this.getClass()));
    final SessionAttributeActivationNotifierFactory<S, SC, AL, LC, TransactionBatch> notifierFactory;
    private final KeyAffinityServiceFactory affinityFactory;
    private final SessionFactory<SC, CompositeSessionMetaDataEntry<LC>, ?, LC> factory;
    private final BiConsumer<Locality, Locality> scheduleTask;
    private final SchedulerListener listener;

    public InfinispanSessionManagerFactory(final InfinispanSessionManagerFactoryConfiguration<S, SC, AL, MC, LC> config) {
        this.affinityFactory = config.getKeyAffinityServiceFactory();
        this.cache = config.getCache();
        this.batcher = config.getBatcher();
        this.properties = config.getCacheProperties();
        this.provider = config.getSpecificationProvider();
        this.notifierFactory = new SessionAttributeActivationNotifierFactory(this.provider);
        InfinispanSessionMetaDataFactoryConfiguration metaDataFactoryConfig = new InfinispanSessionMetaDataFactoryConfiguration(){

            public <K, V> Cache<K, V> getCache() {
                return config.getCache();
            }

            @Override
            public Executor getExecutor() {
                return InfinispanSessionManagerFactory.this.executor;
            }
        };
        AbstractInfinispanSessionMetaDataFactory metaDataFactory = this.properties.isLockOnRead() ? new LockOnReadInfinispanSessionMetaDataFactory(metaDataFactoryConfig) : new InfinispanSessionMetaDataFactory(metaDataFactoryConfig);
        this.factory = new CompositeSessionFactory(metaDataFactory, this.createSessionAttributesFactory(config), config.getLocalContextFactory());
        ExpiredSessionRemover remover = new ExpiredSessionRemover(this.factory);
        this.expirationRegistrar = remover;
        PrimaryOwnerScheduler localScheduler = new SessionExpirationScheduler(this.batcher, this.factory.getMetaDataFactory(), remover, Duration.ofMillis(this.cache.getCacheConfiguration().transaction().cacheStopTimeout()));
        CommandDispatcherFactory dispatcherFactory = config.getCommandDispatcherFactory();
        Group group = dispatcherFactory.getGroup();
        this.scheduler = group.isSingleton() ? localScheduler : new PrimaryOwnerScheduler(dispatcherFactory, this.cache.getName(), (org.wildfly.clustering.ee.infinispan.scheduler.Scheduler)localScheduler, (Function)new PrimaryOwnerLocator(this.cache, config.getMemberFactory()), SessionCreationMetaDataKey::new, this.properties.isTransactional() ? ScheduleWithMetaDataCommand::new : ScheduleWithTransientMetaDataCommand::new);
        this.scheduleTask = new ScheduleLocalKeysTask(this.cache, (Predicate)((Object)SessionCreationMetaDataKeyFilter.INSTANCE), (org.wildfly.clustering.ee.infinispan.scheduler.Scheduler)localScheduler);
        this.listener = new SchedulerTopologyChangeListener(this.cache, (org.wildfly.clustering.ee.infinispan.scheduler.Scheduler)localScheduler, this.scheduleTask);
    }

    @Override
    public void run() {
        this.scheduleTask.accept((Locality)new SimpleLocality(false), (Locality)new CacheLocality(this.cache));
    }

    public SessionManager<LC, TransactionBatch> createSessionManager(final SessionManagerConfiguration<SC> configuration) {
        AffinityIdentifierFactory factory = new AffinityIdentifierFactory(configuration.getIdentifierFactory(), this.cache, this.affinityFactory);
        InfinispanSessionManagerConfiguration config = new InfinispanSessionManagerConfiguration<SC, LC>((IdentifierFactory)factory){
            final /* synthetic */ IdentifierFactory val$factory;
            {
                this.val$factory = identifierFactory;
            }

            @Override
            public SessionExpirationListener getExpirationListener() {
                return configuration.getExpirationListener();
            }

            @Override
            public SC getServletContext() {
                return configuration.getServletContext();
            }

            @Override
            public Cache<Key<String>, ?> getCache() {
                return InfinispanSessionManagerFactory.this.cache;
            }

            @Override
            public CacheProperties getProperties() {
                return InfinispanSessionManagerFactory.this.properties;
            }

            @Override
            public IdentifierFactory<String> getIdentifierFactory() {
                return this.val$factory;
            }

            @Override
            public Batcher<TransactionBatch> getBatcher() {
                return InfinispanSessionManagerFactory.this.batcher;
            }

            @Override
            public Registrar<SessionExpirationListener> getExpirationRegistar() {
                return InfinispanSessionManagerFactory.this.expirationRegistrar;
            }

            @Override
            public Recordable<ImmutableSessionMetaData> getInactiveSessionRecorder() {
                return configuration.getInactiveSessionRecorder();
            }

            @Override
            public Scheduler<String, SessionExpirationMetaData> getExpirationScheduler() {
                return InfinispanSessionManagerFactory.this.scheduler;
            }

            @Override
            public Runnable getStartTask() {
                return InfinispanSessionManagerFactory.this;
            }

            @Override
            public Registrar<Map.Entry<SC, SessionManager<LC, TransactionBatch>>> getContextRegistrar() {
                return InfinispanSessionManagerFactory.this.notifierFactory;
            }
        };
        return new ConcurrentSessionManager(new InfinispanSessionManager(this.factory, config), this.properties.isTransactional() ? SimpleManager::new : ConcurrentManager::new);
    }

    private SessionAttributesFactory<SC, ?> createSessionAttributesFactory(InfinispanSessionManagerFactoryConfiguration<S, SC, AL, MC, LC> configuration) {
        switch (configuration.getAttributePersistenceStrategy()) {
            case FINE: {
                return new FineSessionAttributesFactory(new InfinispanMarshalledValueSessionAttributesFactoryConfiguration(configuration, this.notifierFactory, this.executor));
            }
            case COARSE: {
                return new CoarseSessionAttributesFactory(new InfinispanMarshalledValueSessionAttributesFactoryConfiguration(configuration, this.notifierFactory, this.executor));
            }
        }
        throw new IllegalStateException();
    }

    public void close() {
        this.listener.close();
        this.scheduler.close();
        this.factory.close();
        WildFlySecurityManager.doUnchecked((Object)this.executor, (ParametricPrivilegedAction)DefaultExecutorService.SHUTDOWN_ACTION);
        try {
            this.executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static class InfinispanMarshalledValueSessionAttributesFactoryConfiguration<S, SC, AL, V, MC, LC>
    extends MarshalledValueSessionAttributesFactoryConfiguration<S, SC, AL, V, MC, LC>
    implements InfinispanSessionAttributesFactoryConfiguration<S, SC, AL, V, MarshalledValue<V, MC>> {
        private final InfinispanSessionManagerFactoryConfiguration<S, SC, AL, MC, LC> configuration;
        private final Function<String, SessionAttributeActivationNotifier> notifierFactory;
        private final Executor executor;

        InfinispanMarshalledValueSessionAttributesFactoryConfiguration(InfinispanSessionManagerFactoryConfiguration<S, SC, AL, MC, LC> configuration, Function<String, SessionAttributeActivationNotifier> notifierFactory, Executor executor) {
            super(configuration);
            this.configuration = configuration;
            this.notifierFactory = notifierFactory;
            this.executor = executor;
        }

        public <CK, CV> Cache<CK, CV> getCache() {
            return this.configuration.getCache();
        }

        @Override
        public Executor getExecutor() {
            return this.executor;
        }

        @Override
        public Function<String, SessionAttributeActivationNotifier> getActivationNotifierFactory() {
            return this.notifierFactory;
        }
    }
}

