/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.enhanced;

import org.hibernate.HibernateException;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.id.enhanced.SequenceStructure;

public class OrderedSequenceStructure
extends SequenceStructure {
    private static final String ORDER = " ORDER";
    private AuxiliaryDatabaseObject sequenceObject = new OrderedSequence();

    public OrderedSequenceStructure(JdbcEnvironment jdbcEnvironment, QualifiedName qualifiedSequenceName, int initialValue, int incrementSize, Class numberType) {
        super(jdbcEnvironment, qualifiedSequenceName, initialValue, incrementSize, numberType);
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return this.sequenceObject.sqlCreateStrings(dialect);
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return this.sequenceObject.sqlDropStrings(dialect);
    }

    protected void buildSequence(Database database) {
        database.addAuxiliaryDatabaseObject(this.sequenceObject);
        this.sequenceName = database.getJdbcEnvironment().getQualifiedObjectNameFormatter().format(this.getQualifiedName(), database.getJdbcEnvironment().getDialect());
    }

    private class OrderedSequence
    implements AuxiliaryDatabaseObject {
        private OrderedSequence() {
        }

        public String getExportIdentifier() {
            return OrderedSequenceStructure.this.getName();
        }

        public boolean appliesToDialect(Dialect dialect) {
            return true;
        }

        public boolean beforeTablesOnCreation() {
            return true;
        }

        public String[] sqlCreateStrings(Dialect dialect) {
            String[] createStrings = dialect.getCreateSequenceStrings(OrderedSequenceStructure.this.getName(), OrderedSequenceStructure.this.getInitialValue(), OrderedSequenceStructure.this.getSourceIncrementSize());
            if (dialect instanceof Oracle8iDialect) {
                for (int i = 0; i < createStrings.length; ++i) {
                    createStrings[i] = createStrings[i] + OrderedSequenceStructure.ORDER;
                }
            }
            return createStrings;
        }

        public String[] sqlDropStrings(Dialect dialect) {
            return dialect.getDropSequenceStrings(OrderedSequenceStructure.this.getName());
        }
    }
}

