/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.util.ETag;

public class OperationParameter {
    private final boolean get;
    private final int maxAge;
    private final ETag etag;
    private final boolean encode;
    private final boolean pretty;

    private OperationParameter(Builder builder) {
        this.get = builder.get;
        this.maxAge = builder.maxAge;
        this.etag = builder.etag;
        this.encode = builder.encode;
        this.pretty = builder.pretty;
    }

    public boolean isGet() {
        return this.get;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public ETag getEtag() {
        return this.etag;
    }

    public boolean isEncode() {
        return this.encode;
    }

    public boolean isPretty() {
        return this.pretty;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OperationResult{");
        sb.append("get=").append(this.get);
        sb.append(", maxAge=").append(this.maxAge);
        sb.append(", etag=").append(this.etag);
        sb.append(", encode=").append(this.encode);
        sb.append(", pretty=").append(this.pretty);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        private final boolean get;
        private int maxAge;
        private ETag etag;
        private boolean pretty;
        private boolean encode;

        public Builder(boolean get) {
            this.get = get;
            this.maxAge = 0;
            this.encode = false;
            this.pretty = false;
        }

        public Builder maxAge(int maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public Builder etag(ETag etag) {
            this.etag = etag;
            return this;
        }

        public Builder encode(boolean encode) {
            this.encode = encode;
            return this;
        }

        public Builder pretty(boolean pretty) {
            this.pretty = pretty;
            return this;
        }

        public OperationParameter build() {
            return new OperationParameter(this);
        }
    }
}

