/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import jakarta.ejb.EJBHome;
import jakarta.ejb.EJBLocalHome;
import jakarta.ejb.TimerService;
import jakarta.ejb.TransactionAttributeType;
import jakarta.ejb.TransactionManagementType;
import jakarta.security.jacc.EJBRoleRefPermission;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import jakarta.transaction.UserTransaction;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.BasicComponentCreateService;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.interceptors.InvocationType;
import org.jboss.as.ejb3.component.EJBComponentCreateService;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.MethodIntfHelper;
import org.jboss.as.ejb3.component.MethodTransactionAttributeKey;
import org.jboss.as.ejb3.component.allowedmethods.AllowedMethodsInformation;
import org.jboss.as.ejb3.component.interceptors.ShutDownInterceptorFactory;
import org.jboss.as.ejb3.component.invocationmetrics.InvocationMetrics;
import org.jboss.as.ejb3.context.CurrentInvocationContext;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.security.EJBSecurityMetaData;
import org.jboss.as.ejb3.security.JaccInterceptor;
import org.jboss.as.ejb3.subsystem.EJBStatistics;
import org.jboss.as.ejb3.suspend.EJBSuspendHandlerService;
import org.jboss.as.ejb3.timerservice.TimerServiceImpl;
import org.jboss.as.ejb3.tx.ApplicationExceptionDetails;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.server.suspend.ServerActivityCallback;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBHomeLocator;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.transaction.client.ContextTransactionManager;

public abstract class EJBComponent
extends BasicComponent
implements ServerActivityCallback {
    private static final ApplicationExceptionDetails APPLICATION_EXCEPTION = new ApplicationExceptionDetails("java.lang.Exception", true, false);
    private final Map<MethodTransactionAttributeKey, TransactionAttributeType> txAttrs;
    private final Map<MethodTransactionAttributeKey, Integer> txTimeouts;
    private final Map<MethodTransactionAttributeKey, Boolean> txExplicitAttrs;
    private final boolean isBeanManagedTransaction;
    private final Map<Class<?>, ApplicationExceptionDetails> applicationExceptions;
    private final EJBSecurityMetaData securityMetaData;
    private final Map<String, ServiceName> viewServices;
    private final ServiceName ejbLocalHomeViewServiceName;
    private final ServiceName ejbHomeViewServiceName;
    private final ServiceName ejbObjectViewServiceName;
    private final ServiceName ejbLocalObjectViewServiceName;
    private final TimerService timerService;
    private final Map<Method, InterceptorFactory> timeoutInterceptors;
    private final Method timeoutMethod;
    private final String applicationName;
    private final String earApplicationName;
    private final String moduleName;
    private final String distinctName;
    private final InvocationMetrics invocationMetrics = new InvocationMetrics();
    private final EJBSuspendHandlerService ejbSuspendHandlerService;
    private final ShutDownInterceptorFactory shutDownInterceptorFactory;
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private final UserTransaction userTransaction;
    private final ControlPoint controlPoint;
    private final AtomicBoolean exceptionLoggingEnabled;
    private final SecurityDomain securityDomain;
    private final boolean enableJacc;
    private ThreadLocal<SecurityIdentity> incomingRunAsIdentity;
    private final Function<SecurityIdentity, Set<SecurityIdentity>> identityOutflowFunction;
    private final boolean securityRequired;
    private final EJBComponentDescription componentDescription;
    private final boolean legacyCompliantPrincipalPropagation;

    protected EJBComponent(EJBComponentCreateService ejbComponentCreateService) {
        super((BasicComponentCreateService)ejbComponentCreateService);
        this.applicationExceptions = Collections.unmodifiableMap(ejbComponentCreateService.getApplicationExceptions().getApplicationExceptions());
        Map<MethodTransactionAttributeKey, TransactionAttributeType> txAttrs = ejbComponentCreateService.getTxAttrs();
        if (txAttrs == null || txAttrs.isEmpty()) {
            this.txAttrs = Collections.emptyMap();
            this.txExplicitAttrs = Collections.emptyMap();
        } else {
            this.txAttrs = txAttrs;
            this.txExplicitAttrs = ejbComponentCreateService.getExplicitTxAttrs();
        }
        Map<MethodTransactionAttributeKey, Integer> txTimeouts = ejbComponentCreateService.getTxTimeouts();
        this.txTimeouts = txTimeouts == null || txTimeouts.isEmpty() ? Collections.emptyMap() : txTimeouts;
        this.isBeanManagedTransaction = TransactionManagementType.BEAN.equals((Object)ejbComponentCreateService.getTransactionManagementType());
        this.securityMetaData = ejbComponentCreateService.getSecurityMetaData();
        this.viewServices = ejbComponentCreateService.getViewServices();
        this.timerService = ejbComponentCreateService.getTimerService();
        this.timeoutMethod = ejbComponentCreateService.getTimeoutMethod();
        this.ejbLocalHomeViewServiceName = ejbComponentCreateService.getEjbLocalHome();
        this.ejbHomeViewServiceName = ejbComponentCreateService.getEjbHome();
        this.applicationName = ejbComponentCreateService.getApplicationName();
        this.earApplicationName = ejbComponentCreateService.getEarApplicationName();
        this.distinctName = ejbComponentCreateService.getDistinctName();
        this.moduleName = ejbComponentCreateService.getModuleName();
        this.ejbObjectViewServiceName = ejbComponentCreateService.getEjbObject();
        this.ejbLocalObjectViewServiceName = ejbComponentCreateService.getEjbLocalObject();
        this.timeoutInterceptors = Collections.unmodifiableMap(ejbComponentCreateService.getTimeoutInterceptors());
        this.shutDownInterceptorFactory = ejbComponentCreateService.getShutDownInterceptorFactory();
        this.ejbSuspendHandlerService = ejbComponentCreateService.getEJBSuspendHandler();
        this.transactionSynchronizationRegistry = ejbComponentCreateService.getTransactionSynchronizationRegistry();
        this.userTransaction = ejbComponentCreateService.getUserTransaction();
        this.controlPoint = ejbComponentCreateService.getControlPoint();
        this.exceptionLoggingEnabled = ejbComponentCreateService.getExceptionLoggingEnabled();
        this.securityDomain = ejbComponentCreateService.getSecurityDomain();
        this.enableJacc = ejbComponentCreateService.isEnableJacc();
        this.legacyCompliantPrincipalPropagation = ejbComponentCreateService.isLegacyCompliantPrincipalPropagation();
        this.incomingRunAsIdentity = new ThreadLocal();
        this.identityOutflowFunction = ejbComponentCreateService.getIdentityOutflowFunction();
        this.securityRequired = ejbComponentCreateService.isSecurityRequired();
        this.componentDescription = ejbComponentCreateService.getComponentDescription();
    }

    protected <T> T createViewInstanceProxy(Class<T> viewInterface, Map<Object, Object> contextData) {
        if (viewInterface == null) {
            throw EjbLogger.ROOT_LOGGER.viewInterfaceCannotBeNull();
        }
        if (this.viewServices.containsKey(viewInterface.getName())) {
            ServiceName serviceName = this.viewServices.get(viewInterface.getName());
            return this.createViewInstanceProxy(viewInterface, contextData, serviceName);
        }
        throw EjbLogger.ROOT_LOGGER.viewNotFound(viewInterface.getName(), this.getComponentName());
    }

    protected <T> T createViewInstanceProxy(Class<T> viewInterface, final Map<Object, Object> contextData, ServiceName serviceName) {
        ManagedReference instance;
        ServiceController serviceController = EJBComponent.currentServiceContainer().getRequiredService(serviceName);
        final ComponentView view = (ComponentView)serviceController.getValue();
        try {
            instance = WildFlySecurityManager.isChecking() ? (ManagedReference)WildFlySecurityManager.doUnchecked((PrivilegedExceptionAction)new PrivilegedExceptionAction<ManagedReference>(){

                @Override
                public ManagedReference run() throws Exception {
                    return view.createInstance(contextData);
                }
            }) : view.createInstance(contextData);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return viewInterface.cast(instance.getInstance());
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }

    public ApplicationExceptionDetails getApplicationException(Class<?> exceptionClass, Method invokedMethod) {
        ApplicationExceptionDetails applicationException = this.applicationExceptions.get(exceptionClass);
        if (applicationException != null) {
            return applicationException;
        }
        for (Class<?> superClass = exceptionClass.getSuperclass(); superClass != null && !superClass.equals(Exception.class) && !superClass.equals(Object.class); superClass = superClass.getSuperclass()) {
            applicationException = this.applicationExceptions.get(superClass);
            if (applicationException == null) continue;
            if (applicationException.isInherited()) {
                return applicationException;
            }
            return null;
        }
        if (RuntimeException.class.isAssignableFrom(exceptionClass) || Error.class.isAssignableFrom(exceptionClass)) {
            return null;
        }
        if (invokedMethod != null) {
            Class<?>[] exceptionTypes;
            for (Class<?> type : exceptionTypes = invokedMethod.getExceptionTypes()) {
                if (!type.isAssignableFrom(exceptionClass)) continue;
                return APPLICATION_EXCEPTION;
            }
        }
        return null;
    }

    public Principal getCallerPrincipal() {
        if (this.isSecurityDomainKnown()) {
            return this.getCallerSecurityIdentity().getPrincipal();
        }
        return new AnonymousPrincipal();
    }

    public SecurityIdentity getIncomingRunAsIdentity() {
        return this.incomingRunAsIdentity.get();
    }

    public void setIncomingRunAsIdentity(SecurityIdentity identity) {
        if (identity == null) {
            this.incomingRunAsIdentity.remove();
        } else {
            this.incomingRunAsIdentity.set(identity);
        }
    }

    protected TransactionAttributeType getCurrentTransactionAttribute() {
        InterceptorContext invocation = CurrentInvocationContext.get();
        MethodInterfaceType methodIntf = MethodIntfHelper.of(invocation);
        return this.getTransactionAttributeType(methodIntf, invocation.getMethod());
    }

    public EJBHome getEJBHome() throws IllegalStateException {
        if (this.ejbHomeViewServiceName == null) {
            throw EjbLogger.ROOT_LOGGER.beanHomeInterfaceIsNull(this.getComponentName());
        }
        ServiceController serviceController = EJBComponent.currentServiceContainer().getRequiredService(this.ejbHomeViewServiceName);
        ComponentView view = (ComponentView)serviceController.getValue();
        String locatorAppName = this.earApplicationName == null ? "" : this.earApplicationName;
        return (EJBHome)EJBClient.createProxy(EJBComponent.createHomeLocator(view.getViewClass().asSubclass(EJBHome.class), locatorAppName, this.moduleName, this.getComponentName(), this.distinctName));
    }

    private static <T extends EJBHome> EJBHomeLocator<T> createHomeLocator(Class<T> viewClass, String appName, String moduleName, String beanName, String distinctName) {
        return new EJBHomeLocator(viewClass, appName, moduleName, beanName, distinctName, Affinity.LOCAL);
    }

    public Class<?> getEjbObjectType() {
        if (this.ejbObjectViewServiceName == null) {
            return null;
        }
        ServiceController serviceController = EJBComponent.currentServiceContainer().getRequiredService(this.ejbObjectViewServiceName);
        ComponentView view = (ComponentView)serviceController.getValue();
        return view.getViewClass();
    }

    public Class<?> getEjbLocalObjectType() {
        if (this.ejbLocalObjectViewServiceName == null) {
            return null;
        }
        ServiceController serviceController = EJBComponent.currentServiceContainer().getRequiredService(this.ejbLocalObjectViewServiceName);
        ComponentView view = (ComponentView)serviceController.getValue();
        return view.getViewClass();
    }

    public EJBLocalHome getEJBLocalHome() throws IllegalStateException {
        if (this.ejbLocalHomeViewServiceName == null) {
            throw EjbLogger.ROOT_LOGGER.beanLocalHomeInterfaceIsNull(this.getComponentName());
        }
        return this.createViewInstanceProxy(EJBLocalHome.class, Collections.emptyMap(), this.ejbLocalHomeViewServiceName);
    }

    public boolean getRollbackOnly() throws IllegalStateException {
        if (this.isBeanManagedTransaction()) {
            throw EjbLogger.ROOT_LOGGER.failToCallgetRollbackOnly();
        }
        try {
            TransactionManager tm = this.getTransactionManager();
            if (tm.getTransaction() == null) {
                throw EjbLogger.ROOT_LOGGER.failToCallgetRollbackOnlyOnNoneTransaction();
            }
            int status = tm.getStatus();
            EjbLogger.ROOT_LOGGER.tracef("Current transaction status is %d", status);
            switch (status) {
                case 3: 
                case 4: {
                    throw EjbLogger.ROOT_LOGGER.failToCallgetRollbackOnlyAfterTxcompleted();
                }
                case 1: 
                case 9: {
                    return true;
                }
            }
            return false;
        }
        catch (SystemException se) {
            EjbLogger.ROOT_LOGGER.getTxManagerStatusFailed(se);
            return true;
        }
    }

    public TimerService getTimerService() throws IllegalStateException {
        return this.timerService;
    }

    public TransactionAttributeType getTransactionAttributeType(MethodInterfaceType methodIntf, Method method) {
        return this.getTransactionAttributeType(methodIntf, MethodIdentifier.getIdentifierForMethod((Method)method));
    }

    public TransactionAttributeType getTransactionAttributeType(MethodInterfaceType methodIntf, MethodIdentifier method) {
        return this.getTransactionAttributeType(methodIntf, method, TransactionAttributeType.REQUIRED);
    }

    public TransactionAttributeType getTransactionAttributeType(MethodInterfaceType methodIntf, MethodIdentifier method, TransactionAttributeType defaultType) {
        TransactionAttributeType txAttr = this.txAttrs.get(new MethodTransactionAttributeKey(methodIntf, method));
        if (txAttr == null && methodIntf != MethodInterfaceType.Bean) {
            txAttr = this.txAttrs.get(new MethodTransactionAttributeKey(MethodInterfaceType.Bean, method));
        }
        if (txAttr == null) {
            return defaultType;
        }
        return txAttr;
    }

    public boolean isTransactionAttributeTypeExplicit(MethodInterfaceType methodIntf, MethodIdentifier method) {
        Boolean txAttr = this.txExplicitAttrs.get(new MethodTransactionAttributeKey(methodIntf, method));
        if (txAttr == null && methodIntf != MethodInterfaceType.Bean) {
            txAttr = this.txExplicitAttrs.get(new MethodTransactionAttributeKey(MethodInterfaceType.Bean, method));
        }
        if (txAttr == null) {
            return false;
        }
        return txAttr;
    }

    @Deprecated
    public TransactionManager getTransactionManager() {
        return ContextTransactionManager.getInstance();
    }

    public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return this.transactionSynchronizationRegistry;
    }

    public int getTransactionTimeout(MethodInterfaceType methodIntf, Method method) {
        return this.getTransactionTimeout(methodIntf, MethodIdentifier.getIdentifierForMethod((Method)method));
    }

    public int getTransactionTimeout(MethodInterfaceType methodIntf, MethodIdentifier method) {
        Integer txTimeout = this.txTimeouts.get(new MethodTransactionAttributeKey(methodIntf, method));
        if (txTimeout == null && methodIntf != MethodInterfaceType.Bean) {
            txTimeout = this.txTimeouts.get(new MethodTransactionAttributeKey(MethodInterfaceType.Bean, method));
        }
        if (txTimeout == null) {
            return -1;
        }
        return txTimeout;
    }

    public UserTransaction getUserTransaction() throws IllegalStateException {
        return this.userTransaction;
    }

    public boolean isBeanManagedTransaction() {
        return this.isBeanManagedTransaction;
    }

    public boolean isCallerInRole(String roleName) throws IllegalStateException {
        if (this.isSecurityDomainKnown()) {
            if (this.enableJacc) {
                Policy policy = WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(Policy::getPolicy) : Policy.getPolicy();
                ProtectionDomain domain = new ProtectionDomain(null, null, null, JaccInterceptor.getGrantedRoles(this.getCallerSecurityIdentity()));
                return policy.implies(domain, (Permission)new EJBRoleRefPermission(this.getComponentName(), roleName));
            }
            return this.checkCallerSecurityIdentityRole(roleName);
        }
        return false;
    }

    public boolean isStatisticsEnabled() {
        return EJBStatistics.getInstance().isEnabled();
    }

    public Object lookup(String name) throws IllegalArgumentException {
        if (name == null) {
            throw EjbLogger.ROOT_LOGGER.jndiNameCannotBeNull();
        }
        NamespaceContextSelector namespaceContextSelector = NamespaceContextSelector.getCurrentSelector();
        if (namespaceContextSelector == null) {
            throw EjbLogger.ROOT_LOGGER.noNamespaceContextSelectorAvailable(name);
        }
        Context jndiContext = null;
        Object namespaceStrippedJndiName = name;
        if (name.startsWith("java:app/")) {
            jndiContext = namespaceContextSelector.getContext("app");
            namespaceStrippedJndiName = name.substring("java:app/".length());
        } else if (name.startsWith("java:module/")) {
            jndiContext = namespaceContextSelector.getContext("module");
            namespaceStrippedJndiName = name.substring("java:module/".length());
        } else if (name.startsWith("java:comp/")) {
            jndiContext = namespaceContextSelector.getContext("comp");
            namespaceStrippedJndiName = name.substring("java:comp/".length());
        } else if (!name.startsWith("java:")) {
            jndiContext = namespaceContextSelector.getContext("comp");
            namespaceStrippedJndiName = "env/" + name;
        } else if (name.startsWith("java:global/")) {
            try {
                jndiContext = new InitialContext();
            }
            catch (NamingException ne) {
                throw EjbLogger.ROOT_LOGGER.failToLookupJNDI(name, ne);
            }
        } else {
            throw EjbLogger.ROOT_LOGGER.failToLookupJNDINameSpace(name);
        }
        EjbLogger.ROOT_LOGGER.debugf("Looking up %s in jndi context: %s", namespaceStrippedJndiName, jndiContext);
        try {
            return jndiContext.lookup((String)namespaceStrippedJndiName);
        }
        catch (NamingException ne) {
            throw EjbLogger.ROOT_LOGGER.failToLookupStrippedJNDI(namespaceContextSelector, jndiContext, ne);
        }
    }

    public void setRollbackOnly() throws IllegalStateException {
        if (this.isBeanManagedTransaction()) {
            throw EjbLogger.ROOT_LOGGER.failToCallSetRollbackOnlyOnNoneCMB();
        }
        try {
            TransactionManager tm = this.getTransactionManager();
            if (tm.getTransaction() == null) {
                throw EjbLogger.ROOT_LOGGER.failToCallSetRollbackOnlyWithNoTx();
            }
            tm.setRollbackOnly();
        }
        catch (SystemException se) {
            EjbLogger.ROOT_LOGGER.setRollbackOnlyFailed(se);
        }
    }

    public EJBSecurityMetaData getSecurityMetaData() {
        return this.securityMetaData;
    }

    public Method getTimeoutMethod() {
        return this.timeoutMethod;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getEarApplicationName() {
        return this.earApplicationName;
    }

    public String getDistinctName() {
        return this.distinctName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public ServiceName getEjbLocalObjectViewServiceName() {
        return this.ejbLocalObjectViewServiceName;
    }

    public ServiceName getEjbObjectViewServiceName() {
        return this.ejbObjectViewServiceName;
    }

    public Map<Method, InterceptorFactory> getTimeoutInterceptors() {
        return this.timeoutInterceptors;
    }

    public AllowedMethodsInformation getAllowedMethodsInformation() {
        return this.isBeanManagedTransaction() ? AllowedMethodsInformation.INSTANCE_BMT : AllowedMethodsInformation.INSTANCE_CMT;
    }

    public InvocationMetrics getInvocationMetrics() {
        return this.invocationMetrics;
    }

    public ControlPoint getControlPoint() {
        return this.controlPoint;
    }

    public SecurityDomain getSecurityDomain() {
        return this.securityDomain;
    }

    public boolean isSecurityDomainKnown() {
        return this.securityDomain != null;
    }

    public Function<SecurityIdentity, Set<SecurityIdentity>> getIdentityOutflowFunction() {
        return this.identityOutflowFunction;
    }

    public synchronized void init() {
        this.getShutDownInterceptorFactory().start();
        super.init();
        if (this.timerService instanceof TimerServiceImpl) {
            ((TimerServiceImpl)this.timerService).activate();
        }
    }

    public final void stop() {
        this.getShutDownInterceptorFactory().shutdown();
        if (this.timerService instanceof TimerServiceImpl) {
            ((TimerServiceImpl)this.timerService).deactivate();
        }
        this.done();
    }

    public void done() {
        super.stop();
    }

    public boolean isExceptionLoggingEnabled() {
        return this.exceptionLoggingEnabled.get();
    }

    protected ShutDownInterceptorFactory getShutDownInterceptorFactory() {
        return this.shutDownInterceptorFactory;
    }

    private boolean checkCallerSecurityIdentityRole(String roleName) {
        SecurityIdentity identity = this.getCallerSecurityIdentity();
        if ("**".equals(roleName)) {
            return !identity.isAnonymous();
        }
        Roles roles = identity.getRoles("ejb", true);
        if (roles != null) {
            Collection<String> linked;
            if (roles.contains(roleName)) {
                return true;
            }
            if (this.securityMetaData.getSecurityRoleLinks() != null && (linked = this.securityMetaData.getSecurityRoleLinks().get(roleName)) != null) {
                for (String role : roles) {
                    if (!linked.contains(role)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private SecurityIdentity getCallerSecurityIdentity() {
        boolean isRemote;
        InvocationType invocationType = (InvocationType)CurrentInvocationContext.get().getPrivateData(InvocationType.class);
        boolean bl = isRemote = invocationType != null && invocationType.equals((Object)InvocationType.REMOTE);
        if (this.legacyCompliantPrincipalPropagation && !isRemote) {
            return this.getIncomingRunAsIdentity() == null ? this.securityDomain.getCurrentSecurityIdentity() : this.getIncomingRunAsIdentity();
        }
        if (this.getIncomingRunAsIdentity() != null) {
            return this.getIncomingRunAsIdentity();
        }
        if (this.securityRequired) {
            return this.securityDomain.getCurrentSecurityIdentity();
        }
        return this.securityDomain.getAnonymousSecurityIdentity();
    }

    public EJBSuspendHandlerService getEjbSuspendHandlerService() {
        return this.ejbSuspendHandlerService;
    }

    public EJBComponentDescription getComponentDescription() {
        return this.componentDescription;
    }
}

