/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.internal.PrimitiveLongList;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.internal.aggregator.DoubleAccumulation;
import io.opentelemetry.sdk.metrics.internal.aggregator.ExponentialHistogramAccumulation;
import io.opentelemetry.sdk.metrics.internal.aggregator.HistogramAccumulation;
import io.opentelemetry.sdk.metrics.internal.aggregator.LongAccumulation;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableHistogramPointData;
import io.opentelemetry.sdk.metrics.internal.data.exponentialhistogram.ExponentialHistogramPointData;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class MetricDataUtils {
    private MetricDataUtils() {
    }

    static boolean isMonotonicInstrument(InstrumentDescriptor descriptor) {
        InstrumentType type = descriptor.getType();
        return type == InstrumentType.HISTOGRAM || type == InstrumentType.COUNTER || type == InstrumentType.OBSERVABLE_COUNTER;
    }

    static List<LongPointData> toLongPointList(Map<Attributes, LongAccumulation> accumulationMap, long startEpochNanos, long epochNanos) {
        ArrayList<LongPointData> points = new ArrayList<LongPointData>(accumulationMap.size());
        accumulationMap.forEach((labels, accumulation) -> points.add(LongPointData.create(startEpochNanos, epochNanos, labels, accumulation.getValue(), accumulation.getExemplars())));
        return points;
    }

    static List<DoublePointData> toDoublePointList(Map<Attributes, DoubleAccumulation> accumulationMap, long startEpochNanos, long epochNanos) {
        ArrayList<DoublePointData> points = new ArrayList<DoublePointData>(accumulationMap.size());
        accumulationMap.forEach((labels, accumulation) -> points.add(DoublePointData.create(startEpochNanos, epochNanos, labels, accumulation.getValue(), accumulation.getExemplars())));
        return points;
    }

    static List<HistogramPointData> toDoubleHistogramPointList(Map<Attributes, HistogramAccumulation> accumulationMap, long startEpochNanos, long epochNanos, List<Double> boundaries) {
        ArrayList<HistogramPointData> points = new ArrayList<HistogramPointData>(accumulationMap.size());
        accumulationMap.forEach((labels, aggregator) -> {
            List counts = PrimitiveLongList.wrap((long[])((long[])aggregator.getCounts().clone()));
            points.add(ImmutableHistogramPointData.create(startEpochNanos, epochNanos, labels, aggregator.getSum(), boundaries, counts, aggregator.getExemplars()));
        });
        return points;
    }

    static List<ExponentialHistogramPointData> toExponentialHistogramPointList(Map<Attributes, ExponentialHistogramAccumulation> accumulationMap, long startEpochNanos, long epochNanos) {
        ArrayList<ExponentialHistogramPointData> points = new ArrayList<ExponentialHistogramPointData>(accumulationMap.size());
        accumulationMap.forEach((attributes, aggregator) -> points.add(ExponentialHistogramPointData.create(aggregator.getScale(), aggregator.getSum(), aggregator.getZeroCount(), aggregator.getPositiveBuckets(), aggregator.getNegativeBuckets(), startEpochNanos, epochNanos, attributes, aggregator.getExemplars())));
        return points;
    }
}

