/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.keystore;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

class LdapGeneralizedTimeUtil {
    LdapGeneralizedTimeUtil() {
    }

    static Date generalizedTimeToDate(String generalized) throws ParseException {
        String[] parts = generalized.split("[Z+-]");
        String[] timeFraction = parts[0].split("[.,]");
        String time = timeFraction[0];
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(0L);
        calendar.setLenient(false);
        calendar.set(1, Integer.parseInt(time.substring(0, 4)));
        calendar.set(2, Integer.parseInt(time.substring(4, 6)) - 1);
        calendar.set(5, Integer.parseInt(time.substring(6, 8)));
        calendar.set(11, Integer.parseInt(time.substring(8, 10)));
        if (time.length() >= 12) {
            calendar.set(12, Integer.parseInt(time.substring(10, 12)));
        }
        if (time.length() >= 14) {
            calendar.set(13, Integer.parseInt(time.substring(12, 14)));
        }
        if (timeFraction.length >= 2) {
            double fraction = Double.parseDouble("0." + timeFraction[1]);
            if (time.length() >= 14) {
                calendar.set(14, (int)Math.round(fraction * 1000.0));
            } else if (time.length() >= 12) {
                calendar.set(13, (int)Math.round(fraction * 60.0));
            } else {
                calendar.set(12, (int)Math.round(fraction * 60.0));
            }
        }
        if (generalized.length() > parts[0].length()) {
            char delimiter = generalized.charAt(parts[0].length());
            if (delimiter == 'Z') {
                calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            } else {
                calendar.setTimeZone(TimeZone.getTimeZone("GMT" + delimiter + parts[1]));
            }
        }
        return calendar.getTime();
    }
}

