/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb.hacks;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.BiFunction;
import org.jboss.resteasy.plugins.providers.jaxb.hacks.DelegatingMarshaller;
import org.jboss.resteasy.plugins.providers.jaxb.hacks.DelegatingUnmarshaller;
import org.jboss.resteasy.plugins.providers.jaxb.i18n.Messages;

public class RiHacks {
    public static Object createAtomNamespacePrefixMapper() throws JAXBException {
        return RiHacks.createNamespacePrefixMapper((namespace, suggestion) -> {
            if ("http://www.w3.org/2005/Atom".equals(namespace)) {
                return "atom";
            }
            return suggestion;
        });
    }

    public static Object createNamespacePrefixMapper(BiFunction<String, String, String> prefix) throws JAXBException {
        Class<?> type;
        try {
            Class.forName("org.glassfish.jaxb.runtime.marshaller.NamespacePrefixMapper");
            type = Class.forName("org.jboss.resteasy.plugins.providers.jaxb.hacks.NamespacePrefixMapper_3_0_Ri");
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("com.sun.xml.bind.marshaller.NamespacePrefixMapper");
                type = Class.forName("org.jboss.resteasy.plugins.providers.jaxb.hacks.NamespacePrefixMapper_2_1_Ri");
            }
            catch (ClassNotFoundException e2) {
                throw Messages.MESSAGES.namespacePrefixMapperNotInClassPath(e2);
            }
        }
        try {
            Constructor<?> constructor = type.getDeclaredConstructor(BiFunction.class);
            return constructor.newInstance(prefix);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw Messages.MESSAGES.namespacePrefixMapperNotInClassPath(e);
        }
    }

    public static Marshaller createMarshaller(JAXBContext context) throws JAXBException {
        return RiHacks.wrap(context.createMarshaller());
    }

    public static Unmarshaller createUnmarshaller(JAXBContext context) throws JAXBException {
        return RiHacks.wrap(context.createUnmarshaller());
    }

    private static Marshaller wrap(Marshaller marshaller) {
        if (marshaller instanceof DelegatingMarshaller) {
            return marshaller;
        }
        return new DelegatingMarshaller(marshaller);
    }

    private static Unmarshaller wrap(Unmarshaller unmarshaller) {
        if (unmarshaller instanceof DelegatingUnmarshaller) {
            return unmarshaller;
        }
        return new DelegatingUnmarshaller(unmarshaller);
    }
}

