/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.AbstractSAMLObjectMarshaller;
import org.opensaml.saml.saml2.common.CacheableSAMLObject;
import org.opensaml.saml.saml2.common.TimeBoundSAMLObject;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.w3c.dom.Element;

public abstract class RoleDescriptorMarshaller
extends AbstractSAMLObjectMarshaller {
    protected void marshallAttributes(XMLObject samlElement, Element domElement) throws MarshallingException {
        List supportedProtocols;
        RoleDescriptor roleDescriptor = (RoleDescriptor)samlElement;
        if (roleDescriptor.getID() != null) {
            domElement.setAttributeNS(null, "ID", roleDescriptor.getID());
        }
        if (roleDescriptor.getValidUntil() != null) {
            AttributeSupport.appendDateTimeAttribute((Element)domElement, (QName)TimeBoundSAMLObject.VALID_UNTIL_ATTRIB_QNAME, (Instant)roleDescriptor.getValidUntil());
        }
        if (roleDescriptor.getCacheDuration() != null) {
            AttributeSupport.appendDurationAttribute((Element)domElement, (QName)CacheableSAMLObject.CACHE_DURATION_ATTRIB_QNAME, (Duration)roleDescriptor.getCacheDuration());
        }
        if ((supportedProtocols = roleDescriptor.getSupportedProtocols()) != null && supportedProtocols.size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (String protocol : supportedProtocols) {
                builder.append(protocol);
                builder.append(" ");
            }
            domElement.setAttributeNS(null, "protocolSupportEnumeration", builder.toString().trim());
        }
        if (roleDescriptor.getErrorURL() != null) {
            domElement.setAttributeNS(null, "errorURL", roleDescriptor.getErrorURL());
        }
        this.marshallUnknownAttributes((AttributeExtensibleXMLObject)roleDescriptor, domElement);
    }

    protected void marshallAttributeIDness(XMLObject xmlObject, Element domElement) throws MarshallingException {
        XMLObjectSupport.marshallAttributeIDness(null, (String)"ID", (Element)domElement, (boolean)true);
        super.marshallAttributeIDness(xmlObject, domElement);
    }
}

