/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.protocol.core.impl.ActiveMQConsumerContext;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.spi.core.remoting.ConsumerContext;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.UUID;
import org.junit.Assert;
import org.junit.Test;

public class AcknowledgeTest
extends ActiveMQTestBase {
    public final SimpleString addressA = new SimpleString("addressA");
    public final SimpleString queueA = new SimpleString("queueA");
    public final SimpleString queueB = new SimpleString("queueB");
    public final SimpleString queueC = new SimpleString("queueC");

    @Test
    public void testReceiveAckLastMessageOnly() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        ServerLocator locator = this.createInVMNonHALocator().setAckBatchSize(0).setBlockOnAcknowledge(true);
        ClientSessionFactory cf = this.createSessionFactory(locator);
        ClientSession sendSession = cf.createSession(false, true, true);
        ClientSession session = cf.createSession(false, true, true);
        sendSession.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        ClientProducer cp = sendSession.createProducer(this.addressA);
        ClientConsumer cc = session.createConsumer(this.queueA);
        int numMessages = 100;
        for (int i = 0; i < numMessages; ++i) {
            cp.send((Message)sendSession.createMessage(false));
        }
        session.start();
        ClientMessage cm = null;
        for (int i = 0; i < numMessages; ++i) {
            cm = cc.receive(5000L);
            Assert.assertNotNull((Object)cm);
        }
        cm.acknowledge();
        Queue q = (Queue)server.getPostOffice().getBinding(this.queueA).getBindable();
        Assert.assertEquals((long)0L, (long)q.getDeliveringCount());
        session.close();
        sendSession.close();
    }

    @Test
    public void testAsyncConsumerNoAck() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory cf = this.createSessionFactory(locator);
        ClientSession sendSession = cf.createSession(false, true, true);
        ClientSession session = cf.createSession(false, true, true);
        sendSession.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        ClientProducer cp = sendSession.createProducer(this.addressA);
        ClientConsumer cc = session.createConsumer(this.queueA);
        int numMessages = 3;
        for (int i = 0; i < numMessages; ++i) {
            cp.send((Message)sendSession.createMessage(false));
        }
        Thread.sleep(500L);
        this.instanceLog.debug((Object)"woke up");
        final CountDownLatch latch = new CountDownLatch(numMessages);
        session.start();
        cc.setMessageHandler(new MessageHandler(){
            int c = 0;

            public void onMessage(ClientMessage message) {
                AcknowledgeTest.this.instanceLog.debug((Object)("Got message " + this.c++));
                latch.countDown();
            }
        });
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        Queue q = (Queue)server.getPostOffice().getBinding(this.queueA).getBindable();
        Assert.assertEquals((long)numMessages, (long)q.getDeliveringCount());
        sendSession.close();
        session.close();
    }

    @Test
    public void testAsyncConsumerAck() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        ServerLocator locator = this.createInVMNonHALocator().setBlockOnAcknowledge(true).setAckBatchSize(0);
        ClientSessionFactory cf = this.createSessionFactory(locator);
        ClientSession sendSession = cf.createSession(false, true, true);
        final ClientSession session = cf.createSession(false, true, true);
        sendSession.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        ClientProducer cp = sendSession.createProducer(this.addressA);
        ClientConsumer cc = session.createConsumer(this.queueA);
        int numMessages = 100;
        for (int i = 0; i < numMessages; ++i) {
            cp.send((Message)sendSession.createMessage(false));
        }
        final CountDownLatch latch = new CountDownLatch(numMessages);
        session.start();
        cc.setMessageHandler(new MessageHandler(){

            public void onMessage(ClientMessage message) {
                try {
                    message.acknowledge();
                }
                catch (ActiveMQException e) {
                    try {
                        session.close();
                    }
                    catch (ActiveMQException e1) {
                        e1.printStackTrace();
                    }
                }
                latch.countDown();
            }
        });
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        Queue q = (Queue)server.getPostOffice().getBinding(this.queueA).getBindable();
        Assert.assertEquals((long)0L, (long)q.getDeliveringCount());
        sendSession.close();
        session.close();
    }

    @Test
    public void testInvalidACK() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        ServerLocator locator = this.createInVMNonHALocator().setAckBatchSize(0).setBlockOnAcknowledge(true);
        ClientSessionFactory cf = this.createSessionFactory(locator);
        int numMessages = 100;
        ClientSession sessionConsumer = cf.createSession(true, true, 0);
        sessionConsumer.start();
        sessionConsumer.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA));
        ClientConsumer consumer = sessionConsumer.createConsumer(this.queueA);
        ClientSession sendSession = cf.createSession(false, true, true);
        ClientProducer cp22 = sendSession.createProducer(this.addressA);
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage msg = sendSession.createMessage(true);
            msg.putIntProperty("seq", i);
            cp22.send((Message)msg);
        }
        sendSession.close();
        ClientMessage msg = consumer.receive(5000L);
        Thread.sleep(1000L);
        try {
            ((ClientSessionInternal)sessionConsumer).acknowledge((ClientConsumer)new FakeConsumerWithID(0L), (Message)new FakeMessageWithID(12343L));
            AcknowledgeTest.fail((String)"supposed to throw an exception here");
        }
        catch (Exception cp22) {
            // empty catch block
        }
        try {
            ((ClientSessionInternal)sessionConsumer).acknowledge((ClientConsumer)new FakeConsumerWithID(3L), (Message)new FakeMessageWithID(12343L));
            AcknowledgeTest.fail((String)"supposed to throw an exception here");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        consumer.close();
        consumer = sessionConsumer.createConsumer(this.queueA);
        for (int i = 0; i < numMessages; ++i) {
            msg = consumer.receive(5000L);
            AcknowledgeTest.assertNotNull((Object)msg);
            AcknowledgeTest.assertEquals((long)i, (long)msg.getIntProperty("seq").intValue());
            msg.acknowledge();
        }
    }

    @Test
    public void testAsyncConsumerAckLastMessageOnly() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        ServerLocator locator = this.createInVMNonHALocator().setBlockOnAcknowledge(true).setAckBatchSize(0);
        ClientSessionFactory cf = this.createSessionFactory(locator);
        ClientSession sendSession = cf.createSession(false, true, true);
        final ClientSession session = cf.createSession(false, true, true);
        sendSession.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        ClientProducer cp = sendSession.createProducer(this.addressA);
        ClientConsumer cc = session.createConsumer(this.queueA);
        int numMessages = 100;
        for (int i = 0; i < numMessages; ++i) {
            cp.send((Message)sendSession.createMessage(false));
        }
        final CountDownLatch latch = new CountDownLatch(numMessages);
        session.start();
        cc.setMessageHandler(new MessageHandler(){

            public void onMessage(ClientMessage message) {
                if (latch.getCount() == 1L) {
                    try {
                        message.acknowledge();
                    }
                    catch (ActiveMQException e) {
                        try {
                            session.close();
                        }
                        catch (ActiveMQException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
                latch.countDown();
            }
        });
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        Queue q = (Queue)server.getPostOffice().getBinding(this.queueA).getBindable();
        Assert.assertEquals((long)0L, (long)q.getDeliveringCount());
        sendSession.close();
        session.close();
    }

    class FakeMessageWithID
    implements Message {
        final long id;

        public SimpleString getReplyTo() {
            return null;
        }

        public Message setReplyTo(SimpleString address) {
            return null;
        }

        public Object removeAnnotation(SimpleString key) {
            return null;
        }

        public Object getAnnotation(SimpleString key) {
            return null;
        }

        public int getPersistSize() {
            return 0;
        }

        public int getDurableCount() {
            return 0;
        }

        public void persist(ActiveMQBuffer targetRecord) {
        }

        public Persister<Message> getPersister() {
            return null;
        }

        public void reloadPersistence(ActiveMQBuffer record, CoreMessageObjectPools pools) {
        }

        public Long getScheduledDeliveryTime() {
            return null;
        }

        public ICoreMessage toCore() {
            return this.toCore(null);
        }

        public ICoreMessage toCore(CoreMessageObjectPools coreMessageObjectPools) {
            return null;
        }

        public void receiveBuffer(ByteBuf buffer) {
        }

        public void sendBuffer(ByteBuf buffer, int count) {
        }

        public Message setUserID(Object userID) {
            return null;
        }

        public void messageChanged() {
        }

        public Message copy() {
            return null;
        }

        public Message copy(long newID) {
            return null;
        }

        public Message setMessageID(long id) {
            return null;
        }

        public int getRefCount() {
            return 0;
        }

        public int getUsage() {
            return 0;
        }

        public int usageUp() {
            return 0;
        }

        public int usageDown() {
            return 0;
        }

        public int refUp() {
            return 0;
        }

        public int refDown() {
            return 0;
        }

        public int durableUp() {
            return 0;
        }

        public int durableDown() {
            return 0;
        }

        public int getMemoryEstimate() {
            return 0;
        }

        FakeMessageWithID(long id) {
            this.id = id;
        }

        public long getMessageID() {
            return this.id;
        }

        public UUID getUserID() {
            return null;
        }

        public String getAddress() {
            return null;
        }

        public SimpleString getAddressSimpleString() {
            return null;
        }

        public Message setAddress(String address) {
            return null;
        }

        public Message setAddress(SimpleString address) {
            return null;
        }

        public boolean isDurable() {
            return false;
        }

        public FakeMessageWithID setDurable(boolean durable) {
            return this;
        }

        public long getExpiration() {
            return 0L;
        }

        public boolean isExpired() {
            return false;
        }

        public FakeMessageWithID setExpiration(long expiration) {
            return this;
        }

        public long getTimestamp() {
            return 0L;
        }

        public FakeMessageWithID setTimestamp(long timestamp) {
            return this;
        }

        public byte getPriority() {
            return 0;
        }

        public FakeMessageWithID setPriority(byte priority) {
            return this;
        }

        public int getEncodeSize() {
            return 0;
        }

        public boolean isLargeMessage() {
            return false;
        }

        public Message putBooleanProperty(SimpleString key, boolean value) {
            return null;
        }

        public Message putBooleanProperty(String key, boolean value) {
            return null;
        }

        public Message putByteProperty(SimpleString key, byte value) {
            return null;
        }

        public Message putByteProperty(String key, byte value) {
            return null;
        }

        public Message putBytesProperty(SimpleString key, byte[] value) {
            return null;
        }

        public Message putBytesProperty(String key, byte[] value) {
            return null;
        }

        public Message putShortProperty(SimpleString key, short value) {
            return null;
        }

        public Message putShortProperty(String key, short value) {
            return null;
        }

        public Message putCharProperty(SimpleString key, char value) {
            return null;
        }

        public Message putCharProperty(String key, char value) {
            return null;
        }

        public Message putIntProperty(SimpleString key, int value) {
            return null;
        }

        public Message putIntProperty(String key, int value) {
            return null;
        }

        public Message putLongProperty(SimpleString key, long value) {
            return null;
        }

        public Message putLongProperty(String key, long value) {
            return null;
        }

        public Message putFloatProperty(SimpleString key, float value) {
            return null;
        }

        public Message putFloatProperty(String key, float value) {
            return null;
        }

        public Message putDoubleProperty(SimpleString key, double value) {
            return null;
        }

        public Message putDoubleProperty(String key, double value) {
            return null;
        }

        public Message putStringProperty(SimpleString key, SimpleString value) {
            return null;
        }

        public Message putStringProperty(SimpleString key, String value) {
            return null;
        }

        public Message putStringProperty(String key, String value) {
            return null;
        }

        public Message putObjectProperty(SimpleString key, Object value) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Message putObjectProperty(String key, Object value) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Object removeProperty(SimpleString key) {
            return null;
        }

        public Object removeProperty(String key) {
            return null;
        }

        public boolean containsProperty(SimpleString key) {
            return false;
        }

        public boolean containsProperty(String key) {
            return false;
        }

        public Boolean getBooleanProperty(SimpleString key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Boolean getBooleanProperty(String key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Byte getByteProperty(SimpleString key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Byte getByteProperty(String key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Double getDoubleProperty(SimpleString key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Double getDoubleProperty(String key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Integer getIntProperty(SimpleString key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Integer getIntProperty(String key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Long getLongProperty(SimpleString key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Long getLongProperty(String key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Object getObjectProperty(SimpleString key) {
            return null;
        }

        public Object getObjectProperty(String key) {
            return null;
        }

        public Short getShortProperty(SimpleString key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Short getShortProperty(String key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Float getFloatProperty(SimpleString key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public Float getFloatProperty(String key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public String getStringProperty(SimpleString key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public String getStringProperty(String key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public SimpleString getSimpleStringProperty(SimpleString key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public SimpleString getSimpleStringProperty(String key) throws ActiveMQPropertyConversionException {
            return null;
        }

        public byte[] getBytesProperty(SimpleString key) throws ActiveMQPropertyConversionException {
            return new byte[0];
        }

        public byte[] getBytesProperty(String key) throws ActiveMQPropertyConversionException {
            return new byte[0];
        }

        public Set<SimpleString> getPropertyNames() {
            return null;
        }

        public Map<String, Object> toMap() {
            return null;
        }

        public Map<String, Object> toPropertyMap() {
            return null;
        }

        public long getPersistentSize() throws ActiveMQException {
            return 0L;
        }

        public Object getOwner() {
            return null;
        }

        public void setOwner(Object object) {
        }
    }

    class FakeConsumerWithID
    implements ClientConsumer {
        final long id;

        FakeConsumerWithID(long id) {
            this.id = id;
        }

        public ConsumerContext getConsumerContext() {
            return new ActiveMQConsumerContext(this.id);
        }

        public ClientMessage receive() throws ActiveMQException {
            return null;
        }

        public ClientMessage receive(long timeout) throws ActiveMQException {
            return null;
        }

        public ClientMessage receiveImmediate() throws ActiveMQException {
            return null;
        }

        public MessageHandler getMessageHandler() throws ActiveMQException {
            return null;
        }

        public FakeConsumerWithID setMessageHandler(MessageHandler handler) throws ActiveMQException {
            return this;
        }

        public void close() throws ActiveMQException {
        }

        public boolean isClosed() {
            return false;
        }

        public Exception getLastException() {
            return null;
        }
    }
}

