/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.PluralAttribute;
import java.io.Serializable;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.internal.MetadataContext;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.metamodel.model.domain.internal.AbstractAttribute;
import org.hibernate.metamodel.model.domain.internal.PluralAttributeBuilder;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.internal.SqmMappingModelHelper;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractPluralAttribute<D, C, E>
extends AbstractAttribute<D, C, E>
implements PluralPersistentAttribute<D, C, E>,
Serializable {
    private final CollectionClassification classification;
    private final SqmPathSource<E> elementPathSource;

    protected AbstractPluralAttribute(PluralAttributeBuilder<D, C, E, ?> builder, MetadataContext metadataContext) {
        super(builder.getDeclaringType(), builder.getProperty().getName(), builder.getCollectionJavaType(), builder.getAttributeClassification(), builder.getValueType(), builder.getMember(), metadataContext);
        this.classification = builder.getCollectionClassification();
        this.elementPathSource = SqmMappingModelHelper.resolveSqmPathSource(CollectionPart.Nature.ELEMENT.getName(), builder.getValueType(), Bindable.BindableType.PLURAL_ATTRIBUTE);
    }

    @Override
    public String getPathName() {
        return this.getName();
    }

    @Override
    public CollectionClassification getCollectionClassification() {
        return this.classification;
    }

    @Override
    public SqmPathSource<E> getElementPathSource() {
        return this.elementPathSource;
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        if (CollectionPart.Nature.ELEMENT.getName().equals(name)) {
            return this.elementPathSource;
        }
        return this.elementPathSource.findSubPathSource(name);
    }

    @Override
    public SqmPathSource<?> getIntermediatePathSource(SqmPathSource<?> pathSource) {
        return pathSource == this.elementPathSource ? null : this.elementPathSource;
    }

    public PluralAttribute.CollectionType getCollectionType() {
        return this.getCollectionClassification().toJpaClassification();
    }

    @Override
    public JavaType<E> getExpressibleJavaType() {
        return this.getElementType().getExpressibleJavaType();
    }

    @Override
    public SimpleDomainType<E> getElementType() {
        return this.getValueGraphType();
    }

    @Override
    public Class<C> getJavaType() {
        return this.getAttributeJavaType().getJavaTypeClass();
    }

    @Override
    public SimpleDomainType<E> getValueGraphType() {
        return (SimpleDomainType)super.getValueGraphType();
    }

    @Override
    public SimpleDomainType<?> getKeyGraphType() {
        return null;
    }

    public boolean isAssociation() {
        return this.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_MANY || this.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_MANY;
    }

    public boolean isCollection() {
        return true;
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.PLURAL_ATTRIBUTE;
    }

    @Override
    public Class<E> getBindableJavaType() {
        return this.getElementType().getJavaType();
    }

    @Override
    public SqmPath<E> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        NavigablePath navigablePath = intermediatePathSource == null ? lhs.getNavigablePath().append(this.getPathName()) : lhs.getNavigablePath().append(intermediatePathSource.getPathName()).append(this.getPathName());
        return new SqmPluralValuedSimplePath(navigablePath, this, lhs, lhs.nodeBuilder());
    }
}

