/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;

public class CaseSearchedExpression
implements Expression,
DomainResultProducer {
    private final BasicValuedMapping type;
    private List<WhenFragment> whenFragments = new ArrayList<WhenFragment>();
    private Expression otherwise;

    public CaseSearchedExpression(MappingModelExpressible type) {
        this.type = (BasicValuedMapping)type;
    }

    public CaseSearchedExpression(MappingModelExpressible type, List<WhenFragment> whenFragments, Expression otherwise) {
        this.type = (BasicValuedMapping)type;
        this.whenFragments = whenFragments;
        this.otherwise = otherwise;
    }

    public List<WhenFragment> getWhenFragments() {
        return this.whenFragments;
    }

    public Expression getOtherwise() {
        return this.otherwise;
    }

    public void when(Predicate predicate, Expression result) {
        this.whenFragments.add(new WhenFragment(predicate, result));
    }

    public void otherwise(Expression otherwiseExpression) {
        this.otherwise = otherwiseExpression;
    }

    public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = creationState.getSqlAstCreationState().getSqlExpressionResolver().resolveSqlSelection(this, this.type.getExpressibleJavaType(), null, creationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.type.getExpressibleJavaType());
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        SqlExpressionResolver sqlExpressionResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        sqlExpressionResolver.resolveSqlSelection(this, this.type.getExpressibleJavaType(), null, creationState.getSqlAstCreationState().getCreationContext().getMappingMetamodel().getTypeConfiguration());
    }

    @Override
    public void accept(SqlAstWalker walker) {
        walker.visitCaseSearchedExpression(this);
    }

    @Override
    public MappingModelExpressible getExpressionType() {
        return this.type;
    }

    public static class WhenFragment
    implements Serializable {
        private final Predicate predicate;
        private final Expression result;

        public WhenFragment(Predicate predicate, Expression result) {
            this.predicate = predicate;
            this.result = result;
        }

        public Predicate getPredicate() {
            return this.predicate;
        }

        public Expression getResult() {
            return this.result;
        }
    }
}

