/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.spi;

import io.smallrye.openapi.api.constants.JDKConstants;
import io.smallrye.openapi.api.models.media.ContentImpl;
import io.smallrye.openapi.api.models.media.EncodingImpl;
import io.smallrye.openapi.api.models.media.MediaTypeImpl;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.api.models.parameters.ParameterImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.io.CurrentScannerInfo;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.io.parameter.ParameterConstant;
import io.smallrye.openapi.runtime.io.schema.SchemaConstant;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.ResourceParameters;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.BeanValidationScanner;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.scanner.spi.FrameworkParameter;
import io.smallrye.openapi.runtime.scanner.spi.ScannerSPILogging;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.ModelUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.beans.Introspector;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;

public abstract class AbstractParameterProcessor {
    private static Set<DotName> openApiParameterAnnotations = new HashSet<DotName>(Arrays.asList(ParameterConstant.DOTNAME_PARAMETER, ParameterConstant.DOTNAME_PARAMETERS));
    protected static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    protected final AnnotationScannerContext scannerContext;
    protected final IndexView index;
    protected final ClassLoader cl;
    protected final Function<AnnotationInstance, Parameter> readerFunction;
    protected final List<AnnotationScannerExtension> extensions;
    protected Map<ParameterContextKey, ParameterContext> params = new HashMap<ParameterContextKey, ParameterContext>();
    protected Map<String, AnnotationInstance> formParams = new LinkedHashMap<String, AnnotationInstance>();
    protected String formMediaType;
    protected Map<String, Map<String, AnnotationInstance>> matrixParams = new LinkedHashMap<String, Map<String, AnnotationInstance>>();
    private Set<String> processedMatrixSegments = new HashSet<String>();

    protected AbstractParameterProcessor(AnnotationScannerContext scannerContext, Function<AnnotationInstance, Parameter> reader, List<AnnotationScannerExtension> extensions) {
        this.scannerContext = scannerContext;
        this.index = scannerContext.getIndex();
        this.cl = scannerContext.getClassLoader();
        this.readerFunction = reader;
        this.extensions = extensions;
    }

    protected void reset() {
        this.params.clear();
        this.formParams.clear();
        this.matrixParams.clear();
    }

    protected ResourceParameters process(ClassInfo resourceClass, MethodInfo resourceMethod) {
        ResourceParameters parameters = new ResourceParameters();
        this.processPathParameters(resourceClass, resourceMethod, parameters);
        this.reset();
        this.processOperationParameters(resourceMethod, parameters);
        this.processFinalize(resourceClass, resourceMethod, parameters);
        return parameters;
    }

    protected void processPathParameters(ClassInfo resourceClass, MethodInfo resourceMethod, ResourceParameters parameters) {
    }

    protected void processOperationParameters(MethodInfo resourceMethod, ResourceParameters parameters) {
        resourceMethod.annotations().stream().filter(a -> !JandexUtil.equals(a.target(), (AnnotationTarget)resourceMethod)).forEach(this::readAnnotatedType);
        resourceMethod.annotations().stream().filter(a -> JandexUtil.equals(a.target(), (AnnotationTarget)resourceMethod)).filter(a -> openApiParameterAnnotations.contains(a.name())).forEach(this::readParameterAnnotation);
        parameters.setOperationParameters(this.getParameters(resourceMethod));
    }

    protected void processFinalize(ClassInfo resourceClass, MethodInfo resourceMethod, ResourceParameters parameters) {
        List<Parameter> allParameters = parameters.getAllParameters();
        parameters.setPathItemPath(this.generatePath((AnnotationTarget)resourceClass, allParameters));
        parameters.setOperationPath(this.generatePath((AnnotationTarget)resourceMethod, allParameters));
        parameters.getPathParameterTemplateNames().stream().filter(pip -> allParameters.stream().noneMatch(ap -> this.samePathParameter((Parameter)ap, (String)pip))).map(pip -> this.getUnannotatedPathParameter(resourceMethod, (String)pip)).filter(Objects::nonNull).map(pip -> this.mapParameter(resourceMethod, (ParameterContext)pip)).forEach(parameters::addOperationParameter);
        parameters.sort();
        parameters.setFormBodyContent(this.getFormBodyContent());
    }

    protected String generatePath(AnnotationTarget target, List<Parameter> parameters) {
        StringBuilder path = new StringBuilder(this.pathOf(target));
        if (path.length() > 0) {
            path.insert(0, '/');
        }
        Matcher templateMatcher = this.getTemplateParameterPattern().matcher(path);
        while (templateMatcher.find()) {
            String variableName = templateMatcher.group(1).trim();
            String variablePattern = templateMatcher.group(2).trim();
            parameters.stream().filter(p -> this.samePathParameter((Parameter)p, variableName)).filter(this::templateParameterPatternEligible).forEach(p -> p.getSchema().setPattern(variablePattern));
            String replacement = templateMatcher.replaceFirst('{' + variableName + '}');
            path.setLength(0);
            path.append(replacement);
            templateMatcher = this.getTemplateParameterPattern().matcher(path);
        }
        parameters.stream().filter(p -> Parameter.Style.MATRIX.equals((Object)p.getStyle())).filter(p -> !this.processedMatrixSegments.contains(p.getName())).filter(p -> path.indexOf(p.getName()) > -1).forEach(matrix -> {
            String segmentName = matrix.getName();
            this.processedMatrixSegments.add(segmentName);
            String matrixRef = '{' + segmentName + '}';
            int insertIndex = -1;
            insertIndex = path.lastIndexOf(matrixRef);
            if (insertIndex > -1) {
                insertIndex += matrixRef.length();
                String generatedName = segmentName + "Matrix";
                matrix.setName(generatedName);
                matrixRef = '{' + generatedName + '}';
            } else {
                insertIndex = path.lastIndexOf(segmentName);
                if (insertIndex > -1) {
                    insertIndex += segmentName.length();
                }
            }
            if (insertIndex > -1) {
                path.insert(insertIndex, matrixRef);
            } else {
                ScannerSPILogging.log.missingPathSegment(segmentName);
            }
        });
        return path.toString();
    }

    protected abstract Pattern getTemplateParameterPattern();

    boolean samePathParameter(Parameter param, String name) {
        return name.equals(param.getName()) && Parameter.In.PATH.equals((Object)param.getIn()) && !Parameter.Style.MATRIX.equals((Object)param.getStyle());
    }

    boolean templateParameterPatternEligible(Parameter param) {
        return Parameter.In.PATH.equals((Object)param.getIn()) && !Parameter.Style.MATRIX.equals((Object)param.getStyle()) && param.getSchema() != null && Schema.SchemaType.STRING.equals((Object)param.getSchema().getType()) && param.getSchema().getPattern() == null;
    }

    protected List<Parameter> getParameters(MethodInfo resourceMethod) {
        this.mapMatrixParameters();
        List<Parameter> parameters = this.params.values().stream().map(context -> this.mapParameter(resourceMethod, (ParameterContext)context)).filter(Objects::nonNull).sorted(ResourceParameters.PARAMETER_COMPARATOR).collect(Collectors.toList());
        return parameters.isEmpty() ? null : parameters;
    }

    private void mapMatrixParameters() {
        for (Map.Entry<String, Map<String, AnnotationInstance>> matrixPath : this.matrixParams.entrySet()) {
            String segmentName = matrixPath.getKey();
            ParameterContext context = this.params.values().stream().filter(p -> p.oaiParam != null).filter(p -> p.oaiParam.getStyle() == Parameter.Style.MATRIX).filter(p -> segmentName.equals(p.name)).findFirst().orElseGet(() -> {
                ParameterContext generated = new ParameterContext();
                generated.name = segmentName;
                generated.location = Parameter.In.PATH;
                generated.style = Parameter.Style.MATRIX;
                generated.frameworkParam = this.getMatrixParameter();
                generated.target = null;
                generated.targetType = null;
                generated.oaiParam = new ParameterImpl();
                generated.oaiParam.setStyle(Parameter.Style.MATRIX);
                generated.oaiParam.setExplode(Boolean.TRUE);
                this.params.put(new ParameterContextKey(generated), generated);
                return generated;
            });
            List<Schema> schemas = ModelUtil.getParameterSchemas(context.oaiParam);
            if (schemas.isEmpty()) {
                SchemaImpl schema = new SchemaImpl();
                schema.setType(Schema.SchemaType.OBJECT);
                ModelUtil.setParameterSchema(context.oaiParam, schema);
                schemas = Arrays.asList(schema);
            }
            for (Schema schema : schemas) {
                this.setSchemaProperties(schema, Collections.emptyMap(), matrixPath.getValue(), false);
            }
        }
    }

    protected abstract FrameworkParameter getMatrixParameter();

    protected ParameterContext getUnannotatedPathParameter(MethodInfo resourceMethod, String name) {
        return null;
    }

    private Parameter mapParameter(MethodInfo resourceMethod, ParameterContext context) {
        Parameter param = context.oaiParam != null ? context.oaiParam : new ParameterImpl();
        param.setName(context.name);
        this.mapParameterIn(param, context);
        if (this.isIgnoredParameter(param, (AnnotationTarget)resourceMethod)) {
            return null;
        }
        this.mapParameterStyle(param, context);
        this.mapParameterSchema(param, context);
        this.mapParameterDeprecated(param, context);
        this.mapParameterExtensions(param, context);
        if (param.getSchema() != null) {
            this.augmentParamSchema(param, context);
        }
        if (param.getRequired() == null && TypeUtil.isOptional(context.targetType)) {
            param.setRequired(Boolean.FALSE);
        }
        return param;
    }

    void mapParameterIn(Parameter param, ParameterContext context) {
        if (param.getIn() == null && context.location != null) {
            param.setIn(context.location);
        }
        if (param.getIn() == Parameter.In.PATH) {
            param.setRequired(Boolean.valueOf(true));
        }
    }

    void mapParameterStyle(Parameter param, ParameterContext context) {
        if (param.getStyle() == null && context.frameworkParam != null) {
            param.setStyle(context.frameworkParam.style);
        }
    }

    void mapParameterSchema(Parameter param, ParameterContext context) {
        Schema schema;
        if (ModelUtil.parameterHasSchema(param) || context.targetType == null) {
            return;
        }
        AnnotationInstance schemaAnnotation = TypeUtil.getAnnotation(context.target, SchemaConstant.DOTNAME_SCHEMA);
        if (schemaAnnotation != null) {
            Type paramType = JandexUtil.value(schemaAnnotation, "implementation", context.targetType);
            Map<Object, Object> defaults = JandexUtil.isArraySchema(schemaAnnotation) || TypeUtil.isTypeOverridden(context.targetType, schemaAnnotation) ? Collections.emptyMap() : TypeUtil.getTypeAttributes(paramType);
            schema = SchemaFactory.readSchema(this.scannerContext, (Schema)new SchemaImpl(), schemaAnnotation, defaults);
        } else {
            schema = SchemaFactory.typeToSchema(this.scannerContext, context.targetType, this.extensions);
        }
        ModelUtil.setParameterSchema(param, schema);
    }

    void mapParameterDeprecated(Parameter param, ParameterContext context) {
        if (param.getDeprecated() == null && TypeUtil.hasAnnotation(context.target, JDKConstants.DOTNAME_DEPRECATED)) {
            param.setDeprecated(Boolean.TRUE);
        }
    }

    void mapParameterExtensions(Parameter param, ParameterContext context) {
        List<AnnotationInstance> extensionAnnotations = ExtensionReader.getExtensionsAnnotations(context.target);
        if (param.getExtensions() == null && !extensionAnnotations.isEmpty()) {
            param.setExtensions(ExtensionReader.readExtensions(this.scannerContext, extensionAnnotations));
        }
    }

    protected Type resolveType(Type targetType) {
        if (targetType != null) {
            for (TypeResolver resolver : this.scannerContext.getResolverStack()) {
                targetType = resolver.resolve(targetType);
            }
        }
        return targetType;
    }

    void augmentParamSchema(Parameter param, ParameterContext context) {
        Schema localSchema;
        Schema paramSchema = param.getSchema();
        String ref = paramSchema.getRef();
        if (ref != null) {
            Type paramType = TypeUtil.unwrapType(context.targetType);
            Schema refSchema = (Schema)ModelUtil.getComponent(this.scannerContext.getOpenApi(), ref);
            localSchema = refSchema != null ? new SchemaImpl().type(refSchema.getType()) : new SchemaImpl().type(Schema.SchemaType.valueOf((String)TypeUtil.getTypeAttributes(paramType).get("type").toString().toUpperCase()));
        } else {
            localSchema = paramSchema;
        }
        int modCount = SchemaImpl.getModCount(localSchema);
        BeanValidationScanner.applyConstraints(context.target, localSchema, param.getName(), (target, name) -> {
            if (param.getRequired() == null) {
                param.setRequired(Boolean.TRUE);
            }
        });
        this.setDefaultValue(localSchema, context.defaultValue);
        if (this.localOnlySchemaModified(paramSchema, localSchema, modCount)) {
            Schema allOf = new SchemaImpl().addAllOf(paramSchema).addAllOf(localSchema.type(null));
            param.setSchema(allOf);
        }
    }

    boolean localOnlySchemaModified(Schema paramSchema, Schema localSchema, int originalModCount) {
        return localSchema != paramSchema && originalModCount != -1 && SchemaImpl.getModCount(localSchema) > originalModCount;
    }

    protected void setSchemaProperties(Schema schema, Map<String, Encoding> encodings, Map<String, AnnotationInstance> params, boolean schemaAnnotationSupported) {
        for (Map.Entry<String, AnnotationInstance> param : params.entrySet()) {
            AnnotationInstance schemaAnnotation;
            String paramName = param.getKey();
            AnnotationTarget paramTarget = param.getValue().target();
            Type paramType = AbstractParameterProcessor.getType(paramTarget);
            Schema paramSchema = SchemaFactory.typeToSchema(this.scannerContext, paramType, this.extensions);
            if (schemaAnnotationSupported && (schemaAnnotation = TypeUtil.getAnnotation(paramTarget, SchemaConstant.DOTNAME_SCHEMA)) != null) {
                Schema fromAnnotation = SchemaFactory.readSchema(this.scannerContext, schemaAnnotation);
                if (fromAnnotation == null) continue;
                paramSchema = MergeUtil.mergeObjects(paramSchema, fromAnnotation);
            }
            if (paramSchema == null) continue;
            this.addEncoding(encodings, paramName, paramTarget);
            this.setDefaultValue(paramSchema, this.getDefaultValue(paramTarget));
            BeanValidationScanner.applyConstraints(paramTarget, paramSchema, paramName, (target, name) -> this.setRequired(name, schema));
            if (paramSchema.getNullable() == null && TypeUtil.isOptional(paramType)) {
                paramSchema.setNullable(Boolean.TRUE);
            }
            if (schema.getProperties() != null) {
                paramSchema = MergeUtil.mergeObjects((Schema)schema.getProperties().get(paramName), paramSchema);
            }
            schema.addProperty(paramName, paramSchema);
        }
    }

    private void setRequired(String name, Schema schema) {
        List requiredProperties = schema.getRequired();
        if (requiredProperties == null || !requiredProperties.contains(name)) {
            schema.addRequired(name);
        }
    }

    private void setDefaultValue(Schema schema, Object defaultValue) {
        if (schema.getDefaultValue() == null && defaultValue != null) {
            schema.setDefaultValue(defaultValue);
        }
    }

    protected Content getFormBodyContent() {
        if (this.formParams.isEmpty()) {
            return null;
        }
        ContentImpl content = new ContentImpl();
        Arrays.stream(this.getFormMediaTypes(CurrentScannerInfo::getCurrentConsumes, this::getFormMediaType)).forEach(mediaTypeName -> {
            MediaTypeImpl mediaType = new MediaTypeImpl();
            SchemaImpl schema = new SchemaImpl();
            HashMap<String, Encoding> encodings = new HashMap<String, Encoding>();
            schema.setType(Schema.SchemaType.OBJECT);
            mediaType.setSchema(schema);
            if (APPLICATION_FORM_URLENCODED.equals(mediaTypeName)) {
                this.addFormParamEncodings(encodings);
            }
            this.setSchemaProperties(schema, encodings, this.formParams, true);
            if (encodings.size() > 0) {
                mediaType.setEncoding(encodings);
            }
            content.addMediaType((String)mediaTypeName, mediaType);
        });
        return content;
    }

    @SafeVarargs
    final String[] getFormMediaTypes(Supplier<String[]> ... mediaTypeSources) {
        for (Supplier<String[]> souce : mediaTypeSources) {
            String[] mediaTypes = souce.get();
            if (mediaTypes == null) continue;
            return mediaTypes;
        }
        return new String[]{this.getDefaultFormMediaType()};
    }

    String[] getFormMediaType() {
        String[] stringArray;
        if (this.formMediaType != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.formMediaType;
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    void addFormParamEncodings(Map<String, Encoding> encodings) {
        this.formParams.entrySet().stream().map(param -> {
            ParameterContextKey key = new ParameterContextKey((String)param.getKey(), null, Parameter.Style.FORM);
            return this.getParameterContext(key, ((AnnotationInstance)param.getValue()).target());
        }).filter(context -> context != null && context.oaiParam != null).forEach(context -> {
            EncodingImpl encoding = null;
            if (context.oaiParam.getStyle() != null) {
                encoding = new EncodingImpl();
                String styleString = context.oaiParam.getStyle().toString();
                Arrays.stream(Encoding.Style.values()).filter(encodingStyle -> encodingStyle.toString().equals(styleString)).findFirst().ifPresent(arg_0 -> ((Encoding)encoding).setStyle(arg_0));
            }
            if (context.oaiParam.getExplode() != null) {
                encoding = encoding != null ? encoding : new EncodingImpl();
                encoding.setExplode(context.oaiParam.getExplode());
            }
            if (encoding != null) {
                encodings.put(context.name, encoding);
            }
        });
    }

    protected String getDefaultFormMediaType() {
        return null;
    }

    protected void addEncoding(Map<String, Encoding> encodings, String paramName, AnnotationTarget paramTarget) {
    }

    protected boolean isIgnoredParameter(Parameter parameter, AnnotationTarget resourceMethod) {
        String ref = parameter.getRef();
        String paramName = parameter.getName();
        Parameter.In paramIn = parameter.getIn();
        if (paramIn == null && ref == null) {
            return true;
        }
        if (ParameterImpl.isHidden(parameter)) {
            return true;
        }
        if ((paramName == null || paramName.trim().isEmpty()) && ref == null) {
            return true;
        }
        if (paramIn == Parameter.In.PATH && !AbstractParameterProcessor.parameterInPath(paramName, parameter.getStyle(), this.fullPathOf(resourceMethod))) {
            return true;
        }
        if (paramIn == Parameter.In.HEADER && paramName != null) {
            switch (paramName.toUpperCase()) {
                case "ACCEPT": 
                case "AUTHORIZATION": 
                case "CONTENT-TYPE": {
                    return true;
                }
            }
        }
        return false;
    }

    static boolean parameterInPath(String paramName, Parameter.Style paramStyle, String resourcePath) {
        if (paramName == null || resourcePath == null) {
            return true;
        }
        String regex = Parameter.Style.MATRIX.equals((Object)paramStyle) ? String.format("(?:\\{[ \\t]*|^|/?)\\Q%s\\E(?:[ \\t]*(?:}|:)|/?|$)", paramName) : String.format("\\{[ \\t]*\\Q%s\\E[ \\t]*(?:}|:)", paramName);
        return Pattern.compile(regex).matcher(resourcePath).find();
    }

    protected void readParameterAnnotation(AnnotationInstance annotation) {
        AnnotationValue annotationValue;
        DotName name = annotation.name();
        if (ParameterConstant.DOTNAME_PARAMETER.equals((Object)name)) {
            this.readAnnotatedType(annotation, null, false);
        } else if (ParameterConstant.DOTNAME_PARAMETERS.equals((Object)name) && (annotationValue = annotation.value()) != null) {
            for (AnnotationInstance nested : annotationValue.asNestedArray()) {
                this.readAnnotatedType(AnnotationInstance.create((DotName)nested.name(), (AnnotationTarget)annotation.target(), (List)nested.values()), null, false);
            }
        }
    }

    protected void readAnnotatedType(AnnotationInstance annotation) {
        this.readAnnotatedType(annotation, null, false);
    }

    protected abstract void readAnnotatedType(AnnotationInstance var1, AnnotationInstance var2, boolean var3);

    protected static Parameter.Style styleOf(Parameter param) {
        if (param.getStyle() != null) {
            return param.getStyle();
        }
        if (param.getIn() != null) {
            switch (param.getIn()) {
                case COOKIE: 
                case QUERY: {
                    return Parameter.Style.FORM;
                }
                case HEADER: 
                case PATH: {
                    return Parameter.Style.SIMPLE;
                }
            }
        }
        return null;
    }

    protected void setMediaType(FrameworkParameter frameworkParam) {
        if (frameworkParam.mediaType != null && this.formMediaType == null) {
            this.formMediaType = frameworkParam.mediaType;
        }
    }

    protected static String paramName(AnnotationInstance annotation) {
        AnnotationValue value = annotation.value();
        String valueString = null;
        if (value != null && (valueString = value.asString()).length() > 0) {
            return valueString;
        }
        AnnotationTarget target = annotation.target();
        switch (target.kind()) {
            case FIELD: {
                valueString = target.asField().name();
                break;
            }
            case METHOD_PARAMETER: {
                valueString = target.asMethodParameter().name();
                break;
            }
            case METHOD: {
                MethodInfo method = target.asMethod();
                if (method.parameters().size() != 1) break;
                String methodName = method.name();
                if (methodName.startsWith("set")) {
                    valueString = Introspector.decapitalize(methodName.substring(3));
                    break;
                }
                valueString = methodName;
                break;
            }
        }
        return valueString;
    }

    protected Set<DotName> getDefaultAnnotationNames() {
        return Collections.emptySet();
    }

    protected String getDefaultAnnotationProperty() {
        return null;
    }

    protected Object getDefaultValue(AnnotationTarget target) {
        Set<DotName> defaultAnnotationNames = this.getDefaultAnnotationNames();
        String annotationProperty = this.getDefaultAnnotationProperty();
        if (defaultAnnotationNames == null || defaultAnnotationNames.isEmpty() || annotationProperty == null) {
            return null;
        }
        AnnotationInstance defaultValueAnno = TypeUtil.getAnnotation(target, defaultAnnotationNames);
        Object defaultValue = null;
        if (defaultValueAnno != null) {
            PrimitiveType.Primitive primitive;
            Object primitiveValue;
            String defaultValueString = JandexUtil.stringValue(defaultValueAnno, annotationProperty);
            defaultValue = defaultValueString;
            Type targetType = AbstractParameterProcessor.getType(target);
            if (targetType != null && targetType.kind() == Type.Kind.PRIMITIVE && (primitiveValue = this.primitiveToObject(primitive = targetType.asPrimitiveType().primitive(), defaultValueString)) != null) {
                defaultValue = primitiveValue;
            }
        }
        return defaultValue;
    }

    protected Object primitiveToObject(PrimitiveType.Primitive primitive, String stringValue) {
        Constable value = null;
        try {
            switch (primitive) {
                case BOOLEAN: {
                    value = Boolean.valueOf(Boolean.parseBoolean(stringValue));
                    break;
                }
                case CHAR: {
                    if (stringValue.length() != 1) break;
                    value = Character.valueOf(stringValue.charAt(0));
                    break;
                }
                case BYTE: {
                    byte[] bytes = stringValue.getBytes();
                    if (bytes.length != 1) break;
                    value = bytes[0];
                    break;
                }
                case SHORT: 
                case INT: 
                case LONG: {
                    value = Long.valueOf(stringValue);
                    break;
                }
                case FLOAT: 
                case DOUBLE: {
                    value = Double.valueOf(stringValue);
                }
            }
        }
        catch (Exception e) {
            ScannerSPILogging.log.invalidDefault(stringValue, primitive.name().toLowerCase());
        }
        return value;
    }

    protected String lastPathSegmentOf(AnnotationTarget target) {
        String fullPath = this.fullPathOf(target);
        String lastSegment = null;
        if (fullPath != null && (lastSegment = fullPath.substring(fullPath.lastIndexOf(47) + 1)).startsWith("{") && lastSegment.endsWith("}")) {
            lastSegment = lastSegment.substring(1, lastSegment.length() - 1);
        }
        return lastSegment;
    }

    protected String fullPathOf(AnnotationTarget target) {
        String pathSegment = null;
        switch (target.kind()) {
            case FIELD: {
                pathSegment = this.pathOf((AnnotationTarget)target.asField().declaringClass());
                break;
            }
            case METHOD: {
                pathSegment = this.methodPath(target.asMethod());
                break;
            }
            case METHOD_PARAMETER: {
                pathSegment = this.methodPath(target.asMethodParameter().method());
                break;
            }
        }
        return pathSegment;
    }

    String methodPath(MethodInfo method) {
        String methodPath = this.pathOf((AnnotationTarget)method);
        String classPath = this.pathOf((AnnotationTarget)method.declaringClass());
        if (methodPath.isEmpty()) {
            return classPath;
        }
        return classPath + '/' + methodPath;
    }

    protected abstract String pathOf(AnnotationTarget var1);

    protected static Type getType(AnnotationTarget target) {
        if (target == null) {
            return null;
        }
        Type type = null;
        switch (target.kind()) {
            case FIELD: {
                type = target.asField().type();
                break;
            }
            case METHOD: {
                List methodParams = target.asMethod().parameters();
                if (methodParams.size() != 1) break;
                type = (Type)methodParams.get(0);
                break;
            }
            case METHOD_PARAMETER: {
                type = JandexUtil.getMethodParameterType(target.asMethodParameter());
                break;
            }
        }
        return type;
    }

    protected boolean isReadableParameterAnnotation(DotName name) {
        return ParameterConstant.DOTNAME_PARAMETER.equals((Object)name) && this.readerFunction != null;
    }

    protected void readParameterAnnotation(AnnotationInstance annotation, boolean overriddenParametersOnly) {
        Parameter oaiParam = this.readerFunction.apply(annotation);
        this.readParameter(new ParameterContextKey(oaiParam), oaiParam, null, null, annotation.target(), overriddenParametersOnly);
    }

    protected void readFrameworkParameter(AnnotationInstance annotation, FrameworkParameter frameworkParam, boolean overriddenParametersOnly) {
        AnnotationTarget target = annotation.target();
        this.readParameter(new ParameterContextKey(AbstractParameterProcessor.paramName(annotation), frameworkParam.location, frameworkParam.defaultStyle), null, frameworkParam, this.getDefaultValue(target), target, overriddenParametersOnly);
    }

    protected void readParameter(ParameterContextKey key, Parameter oaiParam, FrameworkParameter frameworkParam, Object defaultValue, AnnotationTarget target, boolean overriddenParametersOnly) {
        boolean oaiNameOverride;
        ParameterContext context = this.getParameterContext(key, target);
        boolean addParam = false;
        if (context == null) {
            if (overriddenParametersOnly) {
                return;
            }
            context = new ParameterContext();
            addParam = true;
        }
        boolean bl = oaiNameOverride = oaiParam != null && key.name != null && !key.name.equals(context.name) && context.location != Parameter.In.PATH;
        if (context.name == null || oaiNameOverride) {
            if (context.name != null) {
                this.params.remove(new ParameterContextKey(context));
                addParam = true;
            }
            context.name = key.name;
        }
        if (context.location == null) {
            context.location = key.location;
        }
        if (context.style == null) {
            context.style = key.style;
        }
        context.oaiParam = MergeUtil.mergeObjects(context.oaiParam, oaiParam);
        if (context.frameworkParam == null) {
            context.frameworkParam = frameworkParam;
            context.defaultValue = defaultValue;
        }
        if (context.target == null || context.target.kind() == AnnotationTarget.Kind.METHOD) {
            context.target = target;
            context.targetType = this.resolveType(AbstractParameterProcessor.getType(target));
        }
        if (addParam) {
            this.params.put(new ParameterContextKey(context), context);
        }
    }

    ParameterContext getParameterContext(ParameterContextKey key, AnnotationTarget target) {
        ParameterContext context = this.params.get(key);
        if (context == null) {
            context = this.params.values().stream().filter(c -> c.oaiParam == null || c.oaiParam.getRef() == null).filter(c -> this.haveSameAnnotatedTarget((ParameterContext)c, target, key.name)).filter(c -> this.attributesCompatible(c.location, key.location)).filter(c -> this.attributesCompatible(c.style, key.style)).findFirst().orElseGet(() -> this.params.values().stream().filter(c -> this.nameAndStyleMatch((ParameterContext)c, key)).findFirst().orElse(null));
        }
        return context;
    }

    boolean haveSameAnnotatedTarget(ParameterContext context, AnnotationTarget target, String name) {
        boolean sameTarget = false;
        if (JandexUtil.equals(target, context.target)) {
            if (target.kind() != AnnotationTarget.Kind.METHOD) {
                sameTarget = true;
            } else if (name != null) {
                sameTarget = context.name == null || Objects.equals(name, context.name);
            } else if (context.name != null) {
                sameTarget = true;
            }
        } else if (JandexUtil.equals((AnnotationTarget)AbstractParameterProcessor.targetMethod(target), (AnnotationTarget)AbstractParameterProcessor.targetMethod(context.target))) {
            sameTarget = name != null && name.equals(context.name);
        }
        return sameTarget;
    }

    boolean attributesCompatible(Object a1, Object a2) {
        return a1 == null || a2 == null || a1.equals(a2);
    }

    boolean nameAndStyleMatch(ParameterContext context, ParameterContextKey key) {
        if ((context.location == null || key.location == null) && key.name != null && key.style != null) {
            return key.name.equals(context.name) && key.style.equals((Object)context.style);
        }
        return false;
    }

    static MethodInfo targetMethod(AnnotationTarget target) {
        if (target.kind() == AnnotationTarget.Kind.METHOD) {
            return target.asMethod();
        }
        if (target.kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
            return target.asMethodParameter().method();
        }
        return null;
    }

    protected void readParametersInherited(ClassInfo clazz, AnnotationInstance beanParamAnnotation, boolean overriddenParametersOnly) {
        AugmentedIndexView augmentedIndex = AugmentedIndexView.augment(this.index);
        ArrayList<ClassInfo> ancestors = new ArrayList<ClassInfo>(JandexUtil.inheritanceChain(this.index, clazz, null).keySet());
        Collections.reverse(ancestors);
        ancestors.forEach(c -> {
            c.interfaceTypes().stream().map(augmentedIndex::getClass).filter(Objects::nonNull).forEach(iface -> this.readParameters((ClassInfo)iface, beanParamAnnotation, overriddenParametersOnly));
            this.readParameters((ClassInfo)c, beanParamAnnotation, overriddenParametersOnly);
        });
    }

    protected void readParameters(ClassInfo clazz, AnnotationInstance beanParamAnnotation, boolean overriddenParametersOnly) {
        clazz.annotations().entrySet().stream().filter(e -> ParameterConstant.DOTNAME_PARAMETER.equals(e.getKey()) || this.isParameter((DotName)e.getKey())).flatMap(a -> ((List)a.getValue()).stream()).filter(this::isBeanPropertyParam).forEach(annotation -> this.readAnnotatedType((AnnotationInstance)annotation, beanParamAnnotation, overriddenParametersOnly));
    }

    boolean isBeanPropertyParam(AnnotationInstance annotation) {
        AnnotationTarget target = annotation.target();
        boolean relevant = false;
        switch (target.kind()) {
            case FIELD: {
                FieldInfo field = target.asField();
                relevant = this.hasParameters(field.annotations());
                break;
            }
            case METHOD_PARAMETER: {
                MethodParameterInfo param = target.asMethodParameter();
                relevant = !this.isResourceMethod(param.method()) && this.hasParameters(TypeUtil.getAnnotations((AnnotationTarget)param)) && !this.isSubResourceLocator(param.method());
                break;
            }
            case METHOD: {
                MethodInfo method = target.asMethod();
                relevant = !this.isResourceMethod(method) && this.hasParameters(method.annotations()) && AbstractParameterProcessor.getType(target) != null && !this.isSubResourceLocator(method);
                break;
            }
        }
        return relevant;
    }

    protected abstract boolean isSubResourceLocator(MethodInfo var1);

    protected abstract boolean isResourceMethod(MethodInfo var1);

    protected boolean hasParameters(Collection<AnnotationInstance> annotations) {
        return annotations.stream().map(AnnotationInstance::name).anyMatch(this::isParameter);
    }

    protected abstract boolean isParameter(DotName var1);

    protected static class ParameterContextKey {
        final String name;
        final Parameter.In location;
        final Parameter.Style style;
        final String ref;

        public ParameterContextKey(String name, Parameter.In location, Parameter.Style style) {
            this.name = name;
            this.location = location;
            this.style = style;
            this.ref = null;
        }

        public ParameterContextKey(Parameter oaiParam) {
            this.name = oaiParam.getName();
            this.location = oaiParam.getIn();
            this.style = AbstractParameterProcessor.styleOf(oaiParam);
            this.ref = oaiParam.getRef();
        }

        public ParameterContextKey(ParameterContext context) {
            this.name = context.name;
            this.location = context.location;
            this.style = context.style;
            this.ref = context.oaiParam != null ? context.oaiParam.getRef() : null;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ParameterContextKey) {
                ParameterContextKey other = (ParameterContextKey)obj;
                if (this.isNull() && other.isNull()) {
                    return this == other;
                }
                if (this.ref != null) {
                    return this.ref.equals(other.ref);
                }
                return Objects.equals(this.name, other.name) && Objects.equals(this.location, other.location) && Objects.equals(this.style, other.style);
            }
            return false;
        }

        public int hashCode() {
            return this.isNull() ? super.hashCode() : Objects.hash(this.name, this.location, this.style, this.ref);
        }

        public String toString() {
            return "name: " + this.name + "; in: " + this.location + "; style: " + this.style + "; ref: " + this.ref;
        }

        public boolean isNull() {
            return this.name == null && this.location == null && this.style == null && this.ref == null;
        }
    }

    protected static class ParameterContext {
        protected String name;
        protected Parameter.In location;
        protected Parameter.Style style;
        protected Parameter oaiParam;
        protected FrameworkParameter frameworkParam;
        protected Object defaultValue;
        protected AnnotationTarget target;
        protected Type targetType;

        ParameterContext() {
        }

        public ParameterContext(String name, FrameworkParameter frameworkParam, AnnotationTarget target, Type targetType) {
            this.name = name;
            this.location = frameworkParam.location;
            this.style = frameworkParam.style;
            this.frameworkParam = frameworkParam;
            this.target = target;
            this.targetType = targetType;
        }

        public String toString() {
            return "name: " + this.name + "; in: " + this.location + "; target: " + this.target;
        }
    }
}

