/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import org.hibernate.LockMode;
import org.hibernate.action.internal.EntityAction;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.internal.NonNullableTransientDependencies;
import org.hibernate.engine.internal.Nullability;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.CachedNaturalIdValueSource;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.metamodel.mapping.NaturalIdMapping;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;

public abstract class AbstractEntityInsertAction
extends EntityAction {
    private transient Object[] state;
    private final boolean isVersionIncrementDisabled;
    private boolean isExecuted;
    private boolean areTransientReferencesNullified;

    protected AbstractEntityInsertAction(Object id, Object[] state, Object instance, boolean isVersionIncrementDisabled, EntityPersister persister, SharedSessionContractImplementor session) {
        super(session, id, instance, persister);
        this.state = state;
        this.isVersionIncrementDisabled = isVersionIncrementDisabled;
        this.isExecuted = false;
        this.areTransientReferencesNullified = false;
        if (id != null) {
            this.handleNaturalIdPreSaveNotifications();
        }
    }

    public Object[] getState() {
        return this.state;
    }

    public abstract boolean isEarlyInsert();

    public NonNullableTransientDependencies findNonNullableTransientEntities() {
        return ForeignKeys.findNonNullableTransientEntities(this.getPersister().getEntityName(), this.getInstance(), this.getState(), this.isEarlyInsert(), this.getSession());
    }

    protected final void nullifyTransientReferencesIfNotAlready() {
        if (!this.areTransientReferencesNullified) {
            new ForeignKeys.Nullifier(this.getInstance(), false, this.isEarlyInsert(), this.getSession(), this.getPersister()).nullifyTransientReferences(this.getState());
            new Nullability(this.getSession()).checkNullability(this.getState(), this.getPersister(), false);
            this.areTransientReferencesNullified = true;
        }
    }

    public final void makeEntityManaged() {
        this.nullifyTransientReferencesIfNotAlready();
        Object version = Versioning.getVersion(this.getState(), this.getPersister());
        this.getSession().getPersistenceContextInternal().addEntity(this.getInstance(), this.getPersister().isMutable() ? Status.MANAGED : Status.READ_ONLY, this.getState(), this.getEntityKey(), version, LockMode.WRITE, this.isExecuted, this.getPersister(), this.isVersionIncrementDisabled);
        if (this.isEarlyInsert()) {
            SharedSessionContractImplementor session = this.getSession();
            PersistenceContext persistenceContext = session.getPersistenceContextInternal();
            Object[] objects = this.getState();
            for (int i = 0; i < objects.length; ++i) {
                if (!(objects[i] instanceof PersistentCollection)) continue;
                PersistentCollection persistentCollection = (PersistentCollection)objects[i];
                CollectionPersister collectionPersister = ((PluralAttributeMapping)this.getPersister().getAttributeMapping(i)).getCollectionDescriptor();
                CollectionKey collectionKey = new CollectionKey(collectionPersister, ((AbstractEntityPersister)this.getPersister()).getCollectionKey(collectionPersister, this.getInstance(), persistenceContext.getEntry(this.getInstance()), this.getSession()));
                persistenceContext.addCollectionByKey(collectionKey, persistentCollection);
            }
        }
    }

    protected void markExecuted() {
        this.isExecuted = true;
    }

    protected abstract EntityKey getEntityKey();

    @Override
    public void afterDeserialize(SharedSessionContractImplementor session) {
        super.afterDeserialize(session);
        if (session != null) {
            EntityEntry entityEntry = session.getPersistenceContextInternal().getEntry(this.getInstance());
            this.state = entityEntry.getLoadedState();
        }
    }

    protected void handleNaturalIdPreSaveNotifications() {
        NaturalIdMapping naturalIdMapping = this.getPersister().getNaturalIdMapping();
        if (naturalIdMapping != null) {
            this.getSession().getPersistenceContextInternal().getNaturalIdResolutions().manageLocalResolution(this.getId(), naturalIdMapping.extractNaturalIdFromEntityState(this.state, this.getSession()), this.getPersister(), CachedNaturalIdValueSource.INSERT);
        }
    }

    public void handleNaturalIdPostSaveNotifications(Object generatedId) {
        NaturalIdMapping naturalIdMapping = this.getPersister().getNaturalIdMapping();
        if (naturalIdMapping == null) {
            return;
        }
        Object naturalIdValues = naturalIdMapping.extractNaturalIdFromEntityState(this.state, this.getSession());
        if (this.isEarlyInsert()) {
            this.getSession().getPersistenceContextInternal().getNaturalIdResolutions().manageLocalResolution(generatedId, naturalIdValues, this.getPersister(), CachedNaturalIdValueSource.INSERT);
        }
        this.getSession().getPersistenceContextInternal().getNaturalIdResolutions().manageSharedResolution(generatedId, naturalIdValues, null, this.getPersister(), CachedNaturalIdValueSource.INSERT);
    }
}

