/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.jdbc.internal.StandardJdbcValuesMapping;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class JdbcValuesMappingProducerStandard
implements JdbcValuesMappingProducer {
    private final JdbcValuesMapping resolvedMapping;

    public JdbcValuesMappingProducerStandard(List<SqlSelection> sqlSelections, List<DomainResult<?>> domainResults) {
        this.resolvedMapping = new StandardJdbcValuesMapping(sqlSelections, domainResults);
    }

    @Override
    public void addAffectedTableNames(Set<String> affectedTableNames, SessionFactoryImplementor sessionFactory) {
    }

    @Override
    public JdbcValuesMapping resolve(JdbcValuesMetadata jdbcResultsMetadata, SessionFactoryImplementor sessionFactory) {
        List<SqlSelection> sqlSelections = this.resolvedMapping.getSqlSelections();
        ArrayList<SqlSelection> resolvedSelections = null;
        for (int i = 0; i < sqlSelections.size(); ++i) {
            SqlSelection sqlSelection = sqlSelections.get(i);
            SqlSelection resolvedSelection = sqlSelection.resolve(jdbcResultsMetadata, sessionFactory);
            if (resolvedSelection == sqlSelection) continue;
            if (resolvedSelections == null) {
                resolvedSelections = new ArrayList<SqlSelection>(sqlSelections);
            }
            resolvedSelections.set(i, resolvedSelection);
        }
        if (resolvedSelections == null) {
            return this.resolvedMapping;
        }
        return new StandardJdbcValuesMapping(resolvedSelections, this.resolvedMapping.getDomainResults());
    }
}

