/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import org.hibernate.search.backend.lucene.lowlevel.collector.impl.IdentifierCollector;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractLuceneProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.IdProjectionBuilder;

public class LuceneIdProjection<I>
extends AbstractLuceneProjection<String, I> {
    private final ProjectionConverter<String, I> converter;

    private LuceneIdProjection(LuceneSearchIndexScope<?> scope, ProjectionConverter<String, I> converter) {
        super(scope);
        this.converter = converter;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void request(SearchProjectionRequestContext context) {
        context.requireCollector(IdentifierCollector.FACTORY);
    }

    @Override
    public String extract(ProjectionHitMapper<?, ?> mapper, LuceneResult documentResult, SearchProjectionExtractContext context) {
        return context.getCollector(IdentifierCollector.KEY).get(documentResult.getDocId());
    }

    @Override
    public I transform(LoadingResult<?, ?> loadingResult, String extractedData, SearchProjectionTransformContext context) {
        return (I)this.converter.fromDocumentValue((Object)extractedData, context.fromDocumentValueConvertContext());
    }

    public static class Builder<I>
    extends AbstractLuceneProjection.AbstractBuilder<I>
    implements IdProjectionBuilder<I> {
        private final LuceneIdProjection<I> projection;

        public Builder(LuceneSearchIndexScope<?> scope, ProjectionConverter<String, I> converter) {
            super(scope);
            this.projection = new LuceneIdProjection(scope, converter);
        }

        public SearchProjection<I> build() {
            return this.projection;
        }
    }
}

