/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Weigher;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.near.NearCacheService;
import org.wildfly.clustering.ee.hotrod.RemoteCacheKey;
import org.wildfly.clustering.infinispan.client.NearCacheFactory;
import org.wildfly.clustering.infinispan.client.near.CaffeineNearCacheService;
import org.wildfly.clustering.infinispan.client.near.SimpleKeyWeigher;
import org.wildfly.clustering.web.hotrod.session.SessionAccessMetaDataKey;
import org.wildfly.clustering.web.hotrod.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.hotrod.session.coarse.SessionAttributesKey;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeKey;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeNamesKey;
import org.wildfly.clustering.web.session.SessionAttributePersistenceStrategy;

public class SessionManagerNearCacheFactory<K, V>
implements NearCacheFactory<K, V>,
Supplier<Cache<K, MetadataValue<V>>>,
RemovalListener<Object, Object> {
    private final Integer maxActiveSessions;
    private final SessionAttributePersistenceStrategy strategy;
    private final AtomicReference<Cache<K, MetadataValue<V>>> cache = new AtomicReference();

    public SessionManagerNearCacheFactory(Integer maxActiveSessions, SessionAttributePersistenceStrategy strategy) {
        this.maxActiveSessions = maxActiveSessions;
        this.strategy = strategy;
    }

    public NearCacheService<K, V> createService(ClientListenerNotifier notifier) {
        return new CaffeineNearCacheService((Supplier)this, notifier);
    }

    @Override
    public Cache<K, MetadataValue<V>> get() {
        Caffeine builder = Caffeine.newBuilder();
        if (this.maxActiveSessions != null) {
            builder.executor(Runnable::run).maximumWeight(this.maxActiveSessions.longValue()).weigher((Weigher)new SimpleKeyWeigher(SessionCreationMetaDataKey.class::isInstance)).removalListener((RemovalListener)this);
        }
        Cache cache = builder.build();
        this.cache.set(cache);
        return cache;
    }

    public void onRemoval(Object key, Object value, RemovalCause cause) {
        if (cause == RemovalCause.SIZE && key instanceof SessionCreationMetaDataKey) {
            String id = (String)((SessionCreationMetaDataKey)((Object)key)).getId();
            Cache<K, MetadataValue<V>> cache = this.cache.get();
            LinkedList<RemoteCacheKey> keys = new LinkedList<RemoteCacheKey>();
            keys.add(new SessionAccessMetaDataKey(id));
            switch (this.strategy) {
                case COARSE: {
                    keys.add(new SessionAttributesKey(id));
                    break;
                }
                case FINE: {
                    SessionAttributeNamesKey namesKey = new SessionAttributeNamesKey(id);
                    keys.add(namesKey);
                    MetadataValue namesValue = (MetadataValue)cache.getIfPresent((Object)namesKey);
                    if (namesValue == null) break;
                    Map names = (Map)namesValue.getValue();
                    for (UUID attributeId : names.values()) {
                        keys.add(new SessionAttributeKey(id, attributeId));
                    }
                    break;
                }
            }
            cache.invalidateAll(keys);
        }
    }
}

