/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.Logger;
import org.jboss.modcluster.ModClusterLogger;
import org.jboss.modcluster.container.Context;
import org.jboss.modcluster.container.Engine;
import org.jboss.modcluster.container.Host;
import org.jboss.modcluster.mcmp.MCMPRequestType;

public class ModClusterLogger_$logger
implements ModClusterLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ModClusterLogger_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public ModClusterLogger_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void catchingDebug(Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.DEBUG, throwable, this.catchingDebug$str(), new Object[0]);
    }

    protected String catchingDebug$str() {
        return "Catching";
    }

    @Override
    public final void init(String version) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.init$str(), (Object)version);
    }

    protected String init$str() {
        return "MODCLUSTER000001: Initializing mod_cluster version %s";
    }

    @Override
    public final void shutdown() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.shutdown$str(), new Object[0]);
    }

    protected String shutdown$str() {
        return "MODCLUSTER000002: Initiating mod_cluster shutdown";
    }

    @Override
    public final void startServer() {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.startServer$str(), new Object[0]);
    }

    protected String startServer$str() {
        return "MODCLUSTER000003: Received server start event";
    }

    @Override
    public final void stopServer() {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.stopServer$str(), new Object[0]);
    }

    protected String stopServer$str() {
        return "MODCLUSTER000004: Received server stop event";
    }

    @Override
    public final void addContext(Host host, Context context) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.addContext$str(), (Object)host, (Object)context);
    }

    protected String addContext$str() {
        return "MODCLUSTER000005: Received add context event for %s:%s";
    }

    @Override
    public final void removeContext(Host host, Context context) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.removeContext$str(), (Object)host, (Object)context);
    }

    protected String removeContext$str() {
        return "MODCLUSTER000006: Received remove context event for %s:%s";
    }

    @Override
    public final void startContext(Host host, Context context) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.startContext$str(), (Object)host, (Object)context);
    }

    protected String startContext$str() {
        return "MODCLUSTER000007: Received start context event for %s:%s";
    }

    @Override
    public final void stopContext(Host host, Context context) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.stopContext$str(), (Object)host, (Object)context);
    }

    protected String stopContext$str() {
        return "MODCLUSTER000008: Received stop context event for %s:%s";
    }

    @Override
    public final void sendEngineCommand(MCMPRequestType command, Engine engine) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.sendEngineCommand$str(), (Object)command, (Object)engine);
    }

    protected String sendEngineCommand$str() {
        return "MODCLUSTER000009: Sending %s for %s";
    }

    @Override
    public final void sendContextCommand(MCMPRequestType command, Host host, Context context) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.sendContextCommand$str(), (Object)command, (Object)host, (Object)context);
    }

    protected String sendContextCommand$str() {
        return "MODCLUSTER000010: Sending %s for %s:%s";
    }

    @Override
    public final void detectJvmRoute(Engine engine, String jvmRoute) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.detectJvmRoute$str(), (Object)engine, (Object)jvmRoute);
    }

    protected String detectJvmRoute$str() {
        return "MODCLUSTER000011: %s will use %s as jvm-route";
    }

    @Override
    public final void detectConnectorAddress(Engine engine, InetAddress address) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.detectConnectorAddress$str(), (Object)engine, (Object)address);
    }

    protected String detectConnectorAddress$str() {
        return "MODCLUSTER000012: %s connector will use %s";
    }

    @Override
    public final void drainRequests(int requests, Host host, Context context) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.drainRequests$str(), (Object)requests, (Object)host, (Object)context);
    }

    protected String drainRequests$str() {
        return "MODCLUSTER000020: Waiting to drain %d pending requests from %s:%s";
    }

    @Override
    public final void requestsDrained(Host host, Context context, float seconds) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.requestsDrained$str(), (Object)host, (Object)context, (Object)Float.valueOf(seconds));
    }

    protected String requestsDrained$str() {
        return "MODCLUSTER000021: All pending requests drained from %s:%s in %.1f seconds";
    }

    @Override
    public final void requestDrainTimeout(int requests, Host host, Context context, float seconds) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.requestDrainTimeout$str(), new Object[]{requests, host, context, Float.valueOf(seconds)});
    }

    protected String requestDrainTimeout$str() {
        return "MODCLUSTER000022: Failed to drain %d remaining pending requests from %s:%s within %.1f seconds";
    }

    @Override
    public final void drainSessions(int sessions, Host host, Context context) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.drainSessions$str(), (Object)sessions, (Object)host, (Object)context);
    }

    protected String drainSessions$str() {
        return "MODCLUSTER000023: Waiting to drain %d active sessions from %s:%s";
    }

    @Override
    public final void sessionsDrained(Host host, Context context, float seconds) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.sessionsDrained$str(), (Object)host, (Object)context, (Object)Float.valueOf(seconds));
    }

    protected String sessionsDrained$str() {
        return "MODCLUSTER000024: All active sessions drained from %s:%s in %.1f seconds";
    }

    @Override
    public final void sessionDrainTimeout(int sessions, Host host, Context context, float seconds) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.sessionDrainTimeout$str(), new Object[]{sessions, host, context, Float.valueOf(seconds)});
    }

    protected String sessionDrainTimeout$str() {
        return "MODCLUSTER000025: Failed to drain %d remaining active sessions from %s:%s within %.1f seconds";
    }

    @Override
    public final void potentialCrossTalking(InetAddress address, String addressType, String message) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.potentialCrossTalking$str(), (Object)address, (Object)addressType, (Object)message);
    }

    protected String potentialCrossTalking$str() {
        return "MODCLUSTER000031: Could not bind multicast socket to %s (%s address): %s; make sure your multicast address is of the same type as the IP stack (IPv4 or IPv6). Multicast socket will not be bound to an address, but this may lead to cross talking (see https://developer.jboss.org/docs/DOC-9469 for details).";
    }

    @Override
    public final void startAdvertise(InetSocketAddress address) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startAdvertise$str(), (Object)address);
    }

    protected String startAdvertise$str() {
        return "MODCLUSTER000032: Listening to proxy advertisements on %s";
    }

    @Override
    public final void advertiseStartFailed(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.advertiseStartFailed$str(), new Object[0]);
    }

    protected String advertiseStartFailed$str() {
        return "MODCLUSTER000034: Failed to start advertise listener";
    }

    @Override
    public final void parseHeaderFailed(Throwable cause, MCMPRequestType command, InetSocketAddress proxy) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.parseHeaderFailed$str(), (Object)command, (Object)proxy);
    }

    protected String parseHeaderFailed$str() {
        return "MODCLUSTER000040: Failed to parse response header from %2$s for %1$s command";
    }

    @Override
    public final void unrecoverableErrorResponse(String errorType, MCMPRequestType type, InetSocketAddress proxy, String message) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.unrecoverableErrorResponse$str(), new Object[]{errorType, type, proxy, message});
    }

    protected String unrecoverableErrorResponse$str() {
        return "MODCLUSTER000041: Unrecoverable syntax error %s sending %s command to %s: %s";
    }

    @Override
    public final void recoverableErrorResponse(String errorType, MCMPRequestType type, InetSocketAddress proxy, String message) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.recoverableErrorResponse$str(), new Object[]{errorType, type, proxy, message});
    }

    protected String recoverableErrorResponse$str() {
        return "MODCLUSTER000042: Error %s sending %s command to %s, configuration will be reset: %s";
    }

    @Override
    public final void sendFailed(MCMPRequestType type, InetSocketAddress proxy, String message) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.sendFailed$str(), (Object)type, (Object)proxy, (Object)message);
    }

    protected String sendFailed$str() {
        return "MODCLUSTER000043: Failed to send %s command to %s: %s";
    }

    @Override
    public final void notSupportedOnSystem(String classname) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.notSupportedOnSystem$str(), (Object)classname);
    }

    protected String notSupportedOnSystem$str() {
        return "MODCLUSTER000045: %s is not supported on this system and will be disabled.";
    }

    @Override
    public final void startSessionDraining(int sessions, Host host, Context context, long timeout) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startSessionDraining$str(), new Object[]{sessions, host, context, timeout});
    }

    protected String startSessionDraining$str() {
        return "MODCLUSTER000046: Starting to drain %d active sessions from %s:%s in %d seconds.";
    }

    protected String connectorMatchesMultiple$str() {
        return "MODCLUSTER000048: Multiple connectors match specified host:port (%s)! Ensure connectorPort and/or connectorAddress are configured.";
    }

    @Override
    public final RuntimeException connectorMatchesMultiple(String connector) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.connectorMatchesMultiple$str(), connector));
        ModClusterLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String connectorAddressUnknownHost$str() {
        return "MODCLUSTER000049: Could not resolve configured connector address (%d)!";
    }

    @Override
    public final RuntimeException connectorAddressUnknownHost(String connectorAddress) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.connectorAddressUnknownHost$str(), connectorAddress));
        ModClusterLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidInitialLoad$str() {
        return "MODCLUSTER000050: Initial load must be within the range [0..100] or -1 to not prepopulate with initial load, but was: %d";
    }

    @Override
    public final RuntimeException invalidInitialLoad(int initialLoad) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.invalidInitialLoad$str(), initialLoad));
        ModClusterLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noValidAdvertiseInterfaceConfigured$str() {
        return "MODCLUSTER000051: No valid advertise interface configured! Disabling multicast advertise mechanism.";
    }

    @Override
    public final RuntimeException noValidAdvertiseInterfaceConfigured() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.noValidAdvertiseInterfaceConfigured$str(), new Object[0]));
        ModClusterLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String createMulticastSocketWithNullMulticastAddress$str() {
        return "MODCLUSTER000052: Attempted to create multicast socket without multicast address specified! Disabling multicast advertise mechanism.";
    }

    @Override
    public final RuntimeException createMulticastSocketWithNullMulticastAddress() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.createMulticastSocketWithNullMulticastAddress$str(), new Object[0]));
        ModClusterLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String createMulticastSocketWithUnicastAddress$str() {
        return "MODCLUSTER000053: Attempted to create multicast socket with unicast address (%s)! Disabling multicast advertise mechanism.";
    }

    @Override
    public final RuntimeException createMulticastSocketWithUnicastAddress(InetAddress address) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.createMulticastSocketWithUnicastAddress$str(), address));
        ModClusterLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void startSessionDrainingIndefinitely(int sessions, Host host, Context context) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startSessionDrainingIndefinitely$str(), (Object)sessions, (Object)host, (Object)context);
    }

    protected String startSessionDrainingIndefinitely$str() {
        return "MODCLUSTER000054: Starting to drain %d active sessions from %s:%s waiting indefinitely until all remaining sessions are drained or expired.";
    }

    @Override
    public final void noConnectorForEngine(String engineName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noConnectorForEngine$str(), (Object)engineName);
    }

    protected String noConnectorForEngine$str() {
        return "MODCLUSTER000055: No configured connector for engine %s. If this engine should be used with mod_cluster check connector, connectorPort and/or connectorAddress configuration.";
    }
}

