/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.scanner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;

public class ResourceScanner {
    private static final DotName JAKARTA = DotName.createComponentized(null, (String)"jakarta");
    private static final DotName ANNOTATION = DotName.createComponentized((DotName)JAKARTA, (String)"annotation");
    private static final DotName PRIORITY = DotName.createComponentized((DotName)ANNOTATION, (String)"Priority");
    private static final DotName WS = DotName.createComponentized((DotName)JAKARTA, (String)"ws");
    private static final DotName RS = DotName.createComponentized((DotName)WS, (String)"rs");
    private static final DotName APPLICATION_PATH = DotName.createComponentized((DotName)RS, (String)"ApplicationPath");
    private static final DotName PATH = DotName.createComponentized((DotName)RS, (String)"Path");
    private static final DotName CORE = DotName.createComponentized((DotName)RS, (String)"core");
    private static final DotName APPLICATION = DotName.createComponentized((DotName)CORE, (String)"Application");
    private static final DotName EXT = DotName.createComponentized((DotName)RS, (String)"ext");
    private static final DotName PROVIDER = DotName.createComponentized((DotName)EXT, (String)"Provider");
    private final IndexView index;
    private final Set<String> applications;
    private final Set<String> providers;
    private final Set<String> resources;

    private ResourceScanner(IndexView index) {
        this.index = index;
        this.applications = new LinkedHashSet<String>();
        this.providers = new LinkedHashSet<String>();
        this.resources = new LinkedHashSet<String>();
    }

    public static ResourceScanner fromClassPath(ClassLoader cl) throws IOException {
        return ResourceScanner.fromClassPath(cl, null);
    }

    public static ResourceScanner fromClassPath(ClassLoader cl, Predicate<Path> filter) throws IOException {
        String[] cpEntries;
        Enumeration<URL> resources = cl.getResources("META-INF/jandex.idx");
        if (resources.hasMoreElements()) {
            ArrayList<Index> indexes = new ArrayList<Index>();
            while (resources.hasMoreElements()) {
                InputStream in = resources.nextElement().openStream();
                try {
                    IndexReader reader = new IndexReader(in);
                    indexes.add(reader.read());
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            return new ResourceScanner((IndexView)CompositeIndex.create(indexes));
        }
        final Indexer indexer = new Indexer();
        for (String entry : cpEntries = System.getProperty("java.class.path").split(File.pathSeparator)) {
            Path path = Paths.get(entry, new String[0]);
            if (!Files.exists(path, new LinkOption[0]) || filter != null && !filter.test(path)) continue;
            if (Files.isDirectory(path, new LinkOption[0])) {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (file.getFileName().toString().endsWith(".class")) {
                            ResourceScanner.indexClass(indexer, file);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                continue;
            }
            if (path.getFileName().toString().endsWith(".class")) {
                ResourceScanner.indexClass(indexer, path);
                continue;
            }
            if (!path.getFileName().toString().endsWith(".jar")) continue;
            ResourceScanner.indexJar(indexer, path);
        }
        return new ResourceScanner((IndexView)indexer.complete());
    }

    public static ResourceScanner of(Index index) {
        return new ResourceScanner((IndexView)index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getApplications() {
        if (this.applications.isEmpty()) {
            Set<String> set = this.applications;
            synchronized (set) {
                if (this.applications.isEmpty()) {
                    ArrayList<ClassInfo> apps = new ArrayList<ClassInfo>();
                    apps.addAll(this.resolveTypeFromAnnotation(APPLICATION_PATH));
                    apps.addAll(this.index.getAllKnownImplementors(APPLICATION));
                    apps.sort(PrioritySorter.INSTANCE);
                    apps.forEach(classInfo -> this.applications.add(classInfo.name().toString()));
                }
            }
        }
        return Collections.unmodifiableSet(this.applications);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getProviders() {
        if (this.providers.isEmpty()) {
            Set<String> set = this.providers;
            synchronized (set) {
                if (this.providers.isEmpty()) {
                    this.providers.addAll(this.resolveFromAnnotation(PROVIDER));
                }
            }
        }
        return Collections.unmodifiableSet(this.providers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getResources() {
        if (this.resources.isEmpty()) {
            Set<String> set = this.resources;
            synchronized (set) {
                if (this.resources.isEmpty()) {
                    this.resources.addAll(this.resolveFromAnnotation(PATH));
                }
            }
        }
        return Collections.unmodifiableSet(this.resources);
    }

    private Set<String> resolveFromAnnotation(DotName annotation) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        this.resolveTypeFromAnnotation(annotation).forEach(classInfo -> result.add(classInfo.name().toString()));
        return result;
    }

    private Collection<ClassInfo> resolveTypeFromAnnotation(DotName annotation) {
        ArrayList<ClassInfo> results = new ArrayList<ClassInfo>();
        for (AnnotationInstance instance : this.index.getAnnotations(annotation)) {
            AnnotationTarget target = instance.target();
            if (!(target instanceof ClassInfo)) continue;
            ClassInfo classInfo = (ClassInfo)target;
            if (Modifier.isInterface(classInfo.flags())) {
                results.addAll(this.index.getAllKnownImplementors(classInfo.name()));
                continue;
            }
            results.add(classInfo);
        }
        results.sort(PrioritySorter.INSTANCE);
        return results;
    }

    private static void indexJar(final Indexer indexer, Path jar) throws IOException {
        try (FileSystem fs = ResourceScanner.getZipFs(jar);){
            Files.walkFileTree(fs.getPath("/", new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().endsWith(".class")) {
                        ResourceScanner.indexClass(indexer, file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private static void indexClass(Indexer indexer, Path file) throws IOException {
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            indexer.index(in);
        }
    }

    private static FileSystem getZipFs(Path path) throws IOException {
        URI uri = URI.create("jar:" + path.toUri());
        try {
            return FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
            return FileSystems.newFileSystem(uri, Collections.emptyMap());
        }
    }

    private static class PrioritySorter
    implements Comparator<ClassInfo> {
        static final PrioritySorter INSTANCE = new PrioritySorter();

        private PrioritySorter() {
        }

        @Override
        public int compare(ClassInfo o1, ClassInfo o2) {
            int p1 = Integer.MAX_VALUE;
            int p2 = Integer.MAX_VALUE;
            AnnotationInstance pa1 = o1.classAnnotation(PRIORITY);
            AnnotationInstance pa2 = o2.classAnnotation(PRIORITY);
            if (pa1 != null) {
                p1 = pa1.value().asInt();
            }
            if (pa2 != null) {
                p2 = pa2.value().asInt();
            }
            return Integer.compare(p1, p2);
        }
    }
}

