/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.cursor.LivePageCache;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscriptionCounter;
import org.apache.activemq.artemis.core.paging.impl.PagedMessageImpl;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.utils.Env;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.jboss.logging.Logger;

public final class Page
implements Comparable<Page> {
    private static final Logger logger = Logger.getLogger(Page.class);
    public static final int SIZE_RECORD = 6;
    private static final byte START_BYTE = 123;
    private static final byte END_BYTE = 125;
    private final int pageId;
    private boolean suspiciousRecords = false;
    private final AtomicInteger numberOfMessages = new AtomicInteger(0);
    private final SequentialFile file;
    private final SequentialFileFactory fileFactory;
    private volatile LivePageCache pageCache;
    private final AtomicInteger size = new AtomicInteger(0);
    private final StorageManager storageManager;
    private final SimpleString storeName;
    private Set<PageSubscriptionCounter> pendingCounters;
    private int lastReadMessageNumber;
    private ByteBuffer readFileBuffer;
    private final ByteBuffer headerBuffer = ByteBuffer.allocate(5);
    private ChannelBufferWrapper readFileBufferWrapper;
    private int readProcessedBytes;
    private static final int HEADER_AND_TRAILER_SIZE = 6;
    private static final int MINIMUM_MSG_PERSISTENT_SIZE = 6;
    private static final int HEADER_SIZE = 5;
    private static final int MIN_CHUNK_SIZE = Env.osPageSize();

    public Page(SimpleString storeName, StorageManager storageManager, SequentialFileFactory factory, SequentialFile file, int pageId) throws Exception {
        this.pageId = pageId;
        this.file = file;
        this.fileFactory = factory;
        this.storageManager = storageManager;
        this.storeName = storeName;
        this.resetReadMessageStatus();
    }

    public int getPageId() {
        return this.pageId;
    }

    public void setLiveCache(LivePageCache pageCache) {
        this.pageCache = pageCache;
    }

    public LivePageCache getLiveCache() {
        return this.pageCache;
    }

    private synchronized void resetReadMessageStatus() {
        this.lastReadMessageNumber = -3;
        this.readProcessedBytes = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized PagedMessage readMessage(int startOffset, int startMessageNumber, int targetMessageNumber) throws Exception {
        block24: {
            assert (startMessageNumber <= targetMessageNumber);
            if (!this.file.isOpen()) {
                if (!this.file.exists()) {
                    return null;
                }
                throw ActiveMQMessageBundle.BUNDLE.invalidPageIO();
            }
            int fileSize = (int)this.file.size();
            try {
                byte startByte;
                int currentMessageNumber;
                if (this.readFileBuffer == null) {
                    this.readProcessedBytes = startOffset;
                    if (startOffset > fileSize) {
                        return this.readMessage(0, 0, targetMessageNumber);
                    }
                    this.file.position((long)this.readProcessedBytes);
                    this.readFileBuffer = this.fileFactory.allocateDirectBuffer(Math.min(fileSize - this.readProcessedBytes, MIN_CHUNK_SIZE));
                    this.readFileBufferWrapper = Page.wrapWhole(this.readFileBuffer);
                    this.readFileBuffer.limit(0);
                } else if (this.lastReadMessageNumber + 1 != targetMessageNumber) {
                    this.readProcessedBytes = startOffset;
                    this.file.position((long)this.readProcessedBytes);
                    this.readFileBuffer.limit(0);
                } else {
                    startMessageNumber = targetMessageNumber;
                }
                int remainingBytes = fileSize - this.readProcessedBytes;
                for (currentMessageNumber = startMessageNumber; remainingBytes >= 6 && currentMessageNumber < targetMessageNumber; ++currentMessageNumber) {
                    this.headerBuffer.clear();
                    this.file.read(this.headerBuffer);
                    this.headerBuffer.position(0);
                    if (this.headerBuffer.remaining() >= 5 && this.headerBuffer.get() == 123) {
                        int encodedSize = this.headerBuffer.getInt();
                        int nextPosition = this.readProcessedBytes + 6 + encodedSize;
                        if (nextPosition <= fileSize) {
                            int endPosition = nextPosition - 1;
                            this.file.position((long)endPosition);
                            this.headerBuffer.rewind();
                            this.headerBuffer.limit(1);
                            this.file.read(this.headerBuffer);
                            this.headerBuffer.position(0);
                            if (this.headerBuffer.remaining() >= 1 && this.headerBuffer.get() == 125) {
                                this.readProcessedBytes = nextPosition;
                                remainingBytes = fileSize - this.readProcessedBytes;
                                continue;
                            }
                            this.markFileAsSuspect(this.file.getFileName(), this.readProcessedBytes, currentMessageNumber);
                            break;
                        }
                        this.markFileAsSuspect(this.file.getFileName(), this.readProcessedBytes, currentMessageNumber);
                        break;
                    }
                    this.markFileAsSuspect(this.file.getFileName(), this.readProcessedBytes, currentMessageNumber);
                    break;
                }
                if (currentMessageNumber != targetMessageNumber || remainingBytes < 6) break block24;
                ByteBuffer oldFileBuffer = this.readFileBuffer;
                this.readFileBuffer = this.readIntoFileBufferIfNecessary(this.readFileBuffer, 6, true);
                if (this.readFileBuffer != oldFileBuffer) {
                    this.readFileBufferWrapper = Page.wrapWhole(this.readFileBuffer);
                }
                if ((startByte = this.readFileBuffer.get()) == 123) {
                    int encodedSize = this.readFileBuffer.getInt();
                    int nextPosition = this.readProcessedBytes + 6 + encodedSize;
                    if (nextPosition <= fileSize) {
                        ByteBuffer currentFileBuffer = this.readFileBuffer;
                        this.readFileBuffer = this.readIntoFileBufferIfNecessary(this.readFileBuffer, encodedSize + 1, true);
                        if (this.readFileBuffer != currentFileBuffer) {
                            this.readFileBufferWrapper = Page.wrapWhole(this.readFileBuffer);
                        }
                        int endPosition = this.readFileBuffer.position() + encodedSize;
                        if (this.readFileBuffer.remaining() >= encodedSize + 1 && this.readFileBuffer.get(endPosition) == 125) {
                            PagedMessageImpl msg = new PagedMessageImpl(encodedSize, this.storageManager);
                            this.readFileBufferWrapper.setIndex(this.readFileBuffer.position(), endPosition);
                            msg.decode((ActiveMQBuffer)this.readFileBufferWrapper);
                            this.readFileBuffer.position(endPosition + 1);
                            assert (this.readFileBuffer.get(endPosition) == 125) : "decoding cannot change end byte";
                            msg.initMessage(this.storageManager);
                            assert (Page.validateLargeMessageStorageManager(msg));
                            if (logger.isTraceEnabled()) {
                                logger.tracef("Reading message %s on pageId=%d for address=%s", (Object)msg, (Object)this.pageId, (Object)this.storeName);
                            }
                            this.readProcessedBytes = nextPosition;
                            this.lastReadMessageNumber = targetMessageNumber;
                            return msg;
                        }
                        this.markFileAsSuspect(this.file.getFileName(), this.readProcessedBytes, currentMessageNumber);
                        break block24;
                    } else {
                        this.markFileAsSuspect(this.file.getFileName(), this.readProcessedBytes, currentMessageNumber);
                    }
                    break block24;
                }
                this.markFileAsSuspect(this.file.getFileName(), this.readProcessedBytes, currentMessageNumber);
            }
            catch (Exception e) {
                this.resetReadMessageStatus();
                throw e;
            }
        }
        this.resetReadMessageStatus();
        ActiveMQServerLogger.LOGGER.pageLookupError(this.pageId, targetMessageNumber, startOffset, startMessageNumber);
        if (startOffset > 0) {
            return this.readMessage(0, 0, targetMessageNumber);
        }
        return null;
    }

    public synchronized List<PagedMessage> read() throws Exception {
        return this.read(this.storageManager);
    }

    public synchronized List<PagedMessage> read(StorageManager storage) throws Exception {
        return this.read(storage, false);
    }

    public synchronized List<PagedMessage> read(StorageManager storage, boolean onlyLargeMessages) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debugf("reading page %d on address = %s onlyLargeMessages = %b", new Object[]{this.pageId, this.storeName, onlyLargeMessages});
        }
        if (!this.file.isOpen()) {
            if (!this.file.exists()) {
                return Collections.emptyList();
            }
            throw ActiveMQMessageBundle.BUNDLE.invalidPageIO();
        }
        this.size.lazySet((int)this.file.size());
        ArrayList<PagedMessage> messages = new ArrayList<PagedMessage>();
        int totalMessageCount = this.readFromSequentialFile(storage, messages, onlyLargeMessages);
        this.numberOfMessages.lazySet(totalMessageCount);
        return messages;
    }

    private ByteBuffer allocateAndReadIntoFileBuffer(ByteBuffer fileBuffer, int requiredBytes, boolean direct) throws Exception {
        ByteBuffer newFileBuffer;
        if (direct) {
            newFileBuffer = this.fileFactory.allocateDirectBuffer(Math.max(requiredBytes, MIN_CHUNK_SIZE));
            newFileBuffer.put(fileBuffer);
            this.fileFactory.releaseDirectBuffer(fileBuffer);
        } else {
            newFileBuffer = this.fileFactory.newBuffer(Math.max(requiredBytes, MIN_CHUNK_SIZE));
            newFileBuffer.put(fileBuffer);
            this.fileFactory.releaseBuffer(fileBuffer);
        }
        fileBuffer = newFileBuffer;
        fileBuffer.limit(fileBuffer.capacity());
        this.file.read(fileBuffer);
        fileBuffer.position(0);
        return fileBuffer;
    }

    private ByteBuffer readIntoFileBufferIfNecessary(ByteBuffer fileBuffer, int requiredBytes, boolean direct) throws Exception {
        int remaining = fileBuffer.remaining();
        int bytesToBeRead = requiredBytes - remaining;
        if (bytesToBeRead > 0) {
            int capacity = fileBuffer.capacity();
            if (capacity >= requiredBytes) {
                if (fileBuffer.limit() > 0) {
                    fileBuffer.compact();
                } else {
                    fileBuffer.limit(capacity);
                }
                this.file.read(fileBuffer);
                fileBuffer.position(0);
            } else {
                fileBuffer = this.allocateAndReadIntoFileBuffer(fileBuffer, requiredBytes, direct);
            }
        }
        return fileBuffer;
    }

    private static boolean validateLargeMessageStorageManager(PagedMessage msg) {
        if (!(msg.getMessage() instanceof LargeServerMessage)) {
            return true;
        }
        LargeServerMessage largeServerMessage = (LargeServerMessage)msg.getMessage();
        return largeServerMessage.getStorageManager() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ChannelBufferWrapper wrapWhole(ByteBuffer fileBuffer) {
        int position = fileBuffer.position();
        int limit = fileBuffer.limit();
        int capacity = fileBuffer.capacity();
        try {
            ChannelBufferWrapper fileBufferWrapper;
            fileBuffer.clear();
            ByteBuf wrappedBuffer = Unpooled.wrappedBuffer((ByteBuffer)fileBuffer);
            assert (wrappedBuffer.readableBytes() == capacity);
            ChannelBufferWrapper channelBufferWrapper = fileBufferWrapper = new ChannelBufferWrapper(wrappedBuffer);
            return channelBufferWrapper;
        }
        finally {
            fileBuffer.position(position);
            fileBuffer.limit(limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int readFromSequentialFile(StorageManager storage, List<PagedMessage> messages, boolean onlyLargeMessages) throws Exception {
        block24: {
            block23: {
                block22: {
                    block21: {
                        fileSize = (int)this.file.size();
                        this.file.position(0L);
                        processedBytes = 0;
                        fileBuffer = null;
                        totalMessageCount = 0;
                        try {
                            remainingBytes = fileSize - processedBytes;
                            if (remainingBytes < 6) ** GOTO lbl82
                            fileBuffer = this.fileFactory.newBuffer(Math.min(remainingBytes, Page.MIN_CHUNK_SIZE));
                            fileBufferWrapper = Page.wrapWhole(fileBuffer);
                            fileBuffer.limit(0);
                            while (true) {
                                oldFileBuffer = fileBuffer;
                                if ((fileBuffer = this.readIntoFileBufferIfNecessary(fileBuffer, 6, false)) != oldFileBuffer) {
                                    fileBufferWrapper = Page.wrapWhole(fileBuffer);
                                }
                                if ((startByte = fileBuffer.get()) != 123) ** GOTO lbl-1000
                                encodedSize = fileBuffer.getInt();
                                nextPosition = processedBytes + 6 + encodedSize;
                                if (nextPosition <= fileSize) {
                                    currentFileBuffer = fileBuffer;
                                    if ((fileBuffer = this.readIntoFileBufferIfNecessary(fileBuffer, encodedSize + 1, false)) != currentFileBuffer) {
                                        fileBufferWrapper = Page.wrapWhole(fileBuffer);
                                    }
                                    endPosition = fileBuffer.position() + encodedSize;
                                    if (fileBuffer.remaining() >= encodedSize + 1 && fileBuffer.get(endPosition) == 125) {
                                        fileBufferWrapper.setIndex(fileBuffer.position(), endPosition);
                                        skipMessage = onlyLargeMessages != false ? PagedMessageImpl.isLargeMessage((ActiveMQBuffer)fileBufferWrapper) == false : false;
                                        if (!skipMessage) {
                                            msg = new PagedMessageImpl(encodedSize, this.storageManager);
                                            msg.decode((ActiveMQBuffer)fileBufferWrapper);
                                            if (!Page.$assertionsDisabled && fileBuffer.get(endPosition) != 125) {
                                                throw new AssertionError((Object)"decoding cannot change end byte");
                                            }
                                            msg.initMessage(storage);
                                            if (!Page.$assertionsDisabled && !Page.validateLargeMessageStorageManager(msg)) {
                                                throw new AssertionError();
                                            }
                                            if (Page.logger.isTraceEnabled()) {
                                                Page.logger.tracef("Reading message %s on pageId=%d for address=%s", (Object)msg, (Object)this.pageId, (Object)this.storeName);
                                            }
                                            messages.add(msg);
                                        }
                                        ++totalMessageCount;
                                        fileBuffer.position(endPosition + 1);
                                        processedBytes = nextPosition;
                                        continue;
                                    }
                                    this.markFileAsSuspect(this.file.getFileName(), processedBytes, totalMessageCount + 1);
                                    var16_18 = totalMessageCount;
                                    if (fileBuffer == null) break block21;
                                }
                                ** GOTO lbl-1000
                                break;
                            }
                        }
                        catch (Throwable var18_20) {
                            if (fileBuffer != null) {
                                this.fileFactory.releaseBuffer(fileBuffer);
                            }
                            this.size.lazySet(processedBytes);
                            if (this.file.position() != (long)processedBytes) {
                                this.file.position((long)processedBytes);
                            }
                            throw var18_20;
                        }
                        this.fileFactory.releaseBuffer(fileBuffer);
                    }
                    this.size.lazySet(processedBytes);
                    if (this.file.position() != (long)processedBytes) {
                        this.file.position((long)processedBytes);
                    }
                    return var16_18;
lbl-1000:
                    // 1 sources

                    {
                        this.markFileAsSuspect(this.file.getFileName(), processedBytes, totalMessageCount + 1);
                        var14_16 = totalMessageCount;
                        if (fileBuffer == null) break block22;
                    }
                    this.fileFactory.releaseBuffer(fileBuffer);
                }
                this.size.lazySet(processedBytes);
                if (this.file.position() != (long)processedBytes) {
                    this.file.position((long)processedBytes);
                }
                return var14_16;
lbl-1000:
                // 1 sources

                {
                    this.markFileAsSuspect(this.file.getFileName(), processedBytes, totalMessageCount + 1);
                    var12_13 = totalMessageCount;
                    if (fileBuffer == null) break block23;
                }
                this.fileFactory.releaseBuffer(fileBuffer);
            }
            this.size.lazySet(processedBytes);
            if (this.file.position() != (long)processedBytes) {
                this.file.position((long)processedBytes);
            }
            return var12_13;
            {
                if ((remainingBytes = fileSize - processedBytes) >= 6) ** continue;
lbl82:
                // 2 sources

                if (Page.logger.isTraceEnabled()) {
                    Page.logger.tracef("%s has %d bytes of unknown data at position = %d", (Object)this.file.getFileName(), (Object)remainingBytes, (Object)processedBytes);
                }
                var10_11 = totalMessageCount;
                if (fileBuffer == null) break block24;
            }
            this.fileFactory.releaseBuffer(fileBuffer);
        }
        this.size.lazySet(processedBytes);
        if (this.file.position() != (long)processedBytes) {
            this.file.position((long)processedBytes);
        }
        return var10_11;
    }

    public synchronized void write(PagedMessage message) throws Exception {
        this.writeDirect(message);
        this.storageManager.pageWrite(message, this.pageId);
    }

    public void writeDirect(PagedMessage message) throws Exception {
        if (!this.file.isOpen()) {
            throw ActiveMQMessageBundle.BUNDLE.cannotWriteToClosedFile(this.file);
        }
        int messageEncodedSize = message.getEncodeSize();
        int bufferSize = messageEncodedSize + 6;
        ByteBuffer buffer = this.fileFactory.newBuffer(bufferSize);
        ChannelBufferWrapper activeMQBuffer = new ChannelBufferWrapper(Unpooled.wrappedBuffer((ByteBuffer)buffer));
        activeMQBuffer.clear();
        activeMQBuffer.writeByte((byte)123);
        activeMQBuffer.writeInt(messageEncodedSize);
        message.encode((ActiveMQBuffer)activeMQBuffer);
        activeMQBuffer.writeByte((byte)125);
        assert (activeMQBuffer.readableBytes() == bufferSize) : "messageEncodedSize is different from expected";
        assert (buffer.remaining() == bufferSize) : "buffer position or limit are changed";
        this.file.writeDirect(buffer, false);
        if (this.pageCache != null) {
            this.pageCache.addLiveMessage(message);
        }
        this.numberOfMessages.lazySet(this.numberOfMessages.get() + 1);
        this.size.lazySet(this.size.get() + bufferSize);
    }

    public void sync() throws Exception {
        this.file.sync();
    }

    public void open(boolean createFile) throws Exception {
        if (!this.file.isOpen() && (createFile || this.file.exists())) {
            this.file.open();
        }
        if (this.file.isOpen()) {
            this.size.set((int)this.file.size());
            this.file.position(0L);
        }
    }

    public void close(boolean sendEvent) throws Exception {
        this.close(sendEvent, true);
    }

    public synchronized void close(boolean sendEvent, boolean waitSync) throws Exception {
        if (this.readFileBuffer != null) {
            this.fileFactory.releaseDirectBuffer(this.readFileBuffer);
            this.readFileBuffer = null;
        }
        if (sendEvent && this.storageManager != null) {
            this.storageManager.pageClosed(this.storeName, this.pageId);
        }
        if (this.pageCache != null) {
            this.pageCache.close();
            this.pageCache = null;
        }
        this.file.close(waitSync, waitSync);
        Set<PageSubscriptionCounter> counters = this.getPendingCounters();
        if (counters != null) {
            for (PageSubscriptionCounter counter : counters) {
                counter.cleanupNonTXCounters(this.getPageId());
            }
        }
    }

    public boolean isLive() {
        return this.pageCache != null;
    }

    public boolean delete(PagedMessage[] messages) throws Exception {
        List<Long> largeMessageIds;
        if (this.storageManager != null) {
            this.storageManager.pageDeleted(this.storeName, this.pageId);
        }
        if (logger.isDebugEnabled()) {
            logger.debugf("Deleting pageNr=%d on store %s", this.pageId, (Object)this.storeName);
        }
        if (messages != null && messages.length > 0) {
            largeMessageIds = new ArrayList();
            for (PagedMessage msg : messages) {
                if (!msg.getMessage().isLargeMessage()) continue;
                msg.getMessage().usageDown();
                largeMessageIds.add(msg.getMessage().getMessageID());
            }
        } else {
            largeMessageIds = Collections.emptyList();
        }
        try {
            if (!this.storageManager.waitOnOperations(5000L)) {
                ActiveMQServerLogger.LOGGER.timedOutWaitingForLargeMessagesDeletion(largeMessageIds);
            }
            if (this.suspiciousRecords) {
                ActiveMQServerLogger.LOGGER.pageInvalid(this.file.getFileName(), this.file.getFileName());
                this.file.renameTo(this.file.getFileName() + ".invalidPage");
            } else {
                this.file.delete();
            }
            return true;
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.pageDeleteError(e);
            return false;
        }
    }

    public int getNumberOfMessages() {
        return this.numberOfMessages.intValue();
    }

    public int getSize() {
        return this.size.intValue();
    }

    public String toString() {
        return "Page::pageNr=" + this.pageId + ", file=" + this.file;
    }

    @Override
    public int compareTo(Page otherPage) {
        return otherPage.getPageId() - this.pageId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.pageId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Page other = (Page)obj;
        return this.pageId == other.pageId;
    }

    private void markFileAsSuspect(String fileName, int position, int msgNumber) {
        ActiveMQServerLogger.LOGGER.pageSuspectFile(fileName, position, msgNumber);
        this.suspiciousRecords = true;
    }

    public SequentialFile getFile() {
        return this.file;
    }

    public void addPendingCounter(PageSubscriptionCounter pageSubscriptionCounter) {
        this.getOrCreatePendingCounters().add(pageSubscriptionCounter);
    }

    private synchronized Set<PageSubscriptionCounter> getPendingCounters() {
        return this.pendingCounters;
    }

    private synchronized Set<PageSubscriptionCounter> getOrCreatePendingCounters() {
        if (this.pendingCounters == null) {
            this.pendingCounters = new ConcurrentHashSet();
        }
        return this.pendingCounters;
    }
}

