/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.annotation;

import jakarta.ejb.Schedule;
import jakarta.ejb.Schedules;
import java.io.Serializable;
import org.jboss.as.ee.metadata.ClassAnnotationInformationFactory;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.AutoTimer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.metadata.property.PropertyReplacer;

public class ScheduleAnnotationInformationFactory
extends ClassAnnotationInformationFactory<Schedule, AutoTimer> {
    public ScheduleAnnotationInformationFactory() {
        super(Schedule.class, Schedules.class);
    }

    protected AutoTimer fromAnnotation(AnnotationInstance annotationInstance, PropertyReplacer propertyReplacer) {
        AutoTimer timer = new AutoTimer();
        block12: for (AnnotationValue av : annotationInstance.values()) {
            switch (ScheduleValues.valueOf(av.name())) {
                case dayOfMonth: {
                    timer.getScheduleExpression().dayOfMonth(propertyReplacer.replaceProperties(av.asString()));
                    continue block12;
                }
                case dayOfWeek: {
                    timer.getScheduleExpression().dayOfWeek(propertyReplacer.replaceProperties(av.asString()));
                    continue block12;
                }
                case hour: {
                    timer.getScheduleExpression().hour(propertyReplacer.replaceProperties(av.asString()));
                    continue block12;
                }
                case info: {
                    timer.getTimerConfig().setInfo((Serializable)((Object)propertyReplacer.replaceProperties(av.asString())));
                    continue block12;
                }
                case minute: {
                    timer.getScheduleExpression().minute(propertyReplacer.replaceProperties(av.asString()));
                    continue block12;
                }
                case month: {
                    timer.getScheduleExpression().month(propertyReplacer.replaceProperties(av.asString()));
                    continue block12;
                }
                case persistent: {
                    timer.getTimerConfig().setPersistent(av.asBoolean());
                    continue block12;
                }
                case second: {
                    timer.getScheduleExpression().second(propertyReplacer.replaceProperties(av.asString()));
                    continue block12;
                }
                case timezone: {
                    timer.getScheduleExpression().timezone(propertyReplacer.replaceProperties(av.asString()));
                    continue block12;
                }
                case year: {
                    timer.getScheduleExpression().year(propertyReplacer.replaceProperties(av.asString()));
                    continue block12;
                }
            }
            throw EjbLogger.ROOT_LOGGER.invalidScheduleValue(av.name(), av.value().toString());
        }
        return timer;
    }

    private static enum ScheduleValues {
        dayOfMonth,
        dayOfWeek,
        hour,
        info,
        minute,
        month,
        persistent,
        second,
        timezone,
        year;

    }
}

