/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.persistence.filestore;

import jakarta.ejb.ScheduleExpression;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.CalendarTimer;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import org.jboss.as.ejb3.timerservice.TimerServiceImpl;
import org.jboss.as.ejb3.timerservice.persistence.CalendarTimerEntity;
import org.jboss.as.ejb3.timerservice.persistence.TimerEntity;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.InputStreamByteInput;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.vfs.VFSUtils;

public class LegacyFileStore {
    public static final String MIGRATION_MARKER = "migrated-to-xml.marker";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, TimerImpl> loadTimersFromFile(String timedObjectId, TimerServiceImpl timerService, String directory, MarshallerFactory factory, MarshallingConfiguration configuration) {
        HashMap<String, TimerImpl> timers = new HashMap<String, TimerImpl>();
        Unmarshaller unmarshaller = null;
        try {
            File file = new File(directory);
            if (!file.exists()) {
                HashMap<String, TimerImpl> hashMap = timers;
                return hashMap;
            }
            if (!file.isDirectory()) {
                EjbLogger.EJB3_TIMER_LOGGER.failToRestoreTimers(file);
                HashMap<String, TimerImpl> hashMap = timers;
                return hashMap;
            }
            File marker = new File(file, MIGRATION_MARKER);
            if (marker.exists()) {
                HashMap<String, TimerImpl> hashMap = timers;
                return hashMap;
            }
            unmarshaller = factory.createUnmarshaller(configuration);
            for (File timerFile : file.listFiles()) {
                if (timerFile.getName().endsWith(".xml")) continue;
                FileInputStream in = null;
                try {
                    TimerImpl.Builder builder;
                    in = new FileInputStream(timerFile);
                    unmarshaller.start((ByteInput)new InputStreamByteInput((InputStream)in));
                    TimerEntity entity = (TimerEntity)unmarshaller.readObject(TimerEntity.class);
                    if (entity instanceof CalendarTimerEntity) {
                        CalendarTimerEntity c = (CalendarTimerEntity)entity;
                        ScheduleExpression scheduleExpression = new ScheduleExpression();
                        scheduleExpression.second(c.getSecond()).minute(c.getMinute()).hour(c.getHour()).dayOfWeek(c.getDayOfWeek()).dayOfMonth(c.getDayOfMonth()).month(c.getMonth()).year(c.getYear()).start(c.getStartDate()).end(c.getEndDate()).timezone(c.getTimezone());
                        builder = CalendarTimer.builder().setScheduleExpression(scheduleExpression).setAutoTimer(c.isAutoTimer()).setTimeoutMethod(CalendarTimer.getTimeoutMethod(c.getTimeoutMethod(), ((TimedObjectInvoker)timerService.getTimedObjectInvoker().getValue()).getClassLoader()));
                    } else {
                        builder = TimerImpl.builder();
                    }
                    builder.setId(entity.getId()).setTimedObjectId(entity.getTimedObjectId()).setInitialDate(entity.getInitialDate()).setRepeatInterval(entity.getInterval()).setNextDate(entity.getNextDate()).setPreviousRun(entity.getPreviousRun()).setInfo(entity.getInfo()).setTimerState(entity.getTimerState()).setPersistent(true);
                    timers.put(entity.getId(), builder.build(timerService));
                    unmarshaller.finish();
                }
                catch (Exception e) {
                    EjbLogger.EJB3_TIMER_LOGGER.failToRestoreTimersFromFile(timerFile, e);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            EjbLogger.EJB3_TIMER_LOGGER.failToCloseFile(e);
                        }
                    }
                }
            }
            if (!timers.isEmpty()) {
                Files.write(marker.toPath(), new Date().toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            VFSUtils.safeClose((Closeable)unmarshaller);
        }
        catch (Exception e) {
            EjbLogger.EJB3_TIMER_LOGGER.failToRestoreTimersForObjectId(timedObjectId, e);
        }
        finally {
            VFSUtils.safeClose(unmarshaller);
        }
        return timers;
    }
}

