/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import jakarta.persistence.EnumType;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.MappingException;
import org.hibernate.boot.model.process.internal.InferredBasicValueResolution;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.model.convert.internal.NamedEnumValueConverter;
import org.hibernate.metamodel.model.convert.internal.OrdinalEnumValueConverter;
import org.hibernate.type.AdjustableBasicType;
import org.hibernate.type.BasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.SerializableType;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.SerializableJavaType;
import org.hibernate.type.descriptor.java.TemporalJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.ObjectJdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class InferredBasicValueResolver {
    public static <T> BasicValue.Resolution<T> from(BasicJavaType<T> explicitJavaType, JdbcType explicitJdbcType, Type resolvedJavaType, Supplier<JavaType<T>> reflectedJtdResolver, JdbcTypeIndicators stdIndicators, Table table, Selectable selectable, String ownerName, String propertyName, TypeConfiguration typeConfiguration) {
        BasicType<Object> legacyType;
        BasicType<T> jdbcMapping;
        JavaType<T> reflectedJtd = reflectedJtdResolver.get();
        if (explicitJavaType != null) {
            if (explicitJdbcType != null) {
                legacyType = jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(explicitJavaType, explicitJdbcType);
            } else {
                if (explicitJavaType instanceof TemporalJavaType) {
                    return InferredBasicValueResolver.fromTemporal((TemporalJavaType)explicitJavaType, null, null, resolvedJavaType, stdIndicators, typeConfiguration);
                }
                JdbcType inferredJdbcType = explicitJavaType.getRecommendedJdbcType(stdIndicators);
                if (inferredJdbcType instanceof ObjectJdbcType) {
                    if (explicitJavaType instanceof EnumJavaType) {
                        return InferredBasicValueResolver.fromEnum((EnumJavaType)reflectedJtd, explicitJavaType, null, stdIndicators, typeConfiguration);
                    }
                    if (explicitJavaType instanceof TemporalJavaType) {
                        return InferredBasicValueResolver.fromTemporal((TemporalJavaType)reflectedJtd, explicitJavaType, null, resolvedJavaType, stdIndicators, typeConfiguration);
                    }
                    if (explicitJavaType instanceof SerializableJavaType || explicitJavaType.getJavaType() instanceof Serializable) {
                        jdbcMapping = legacyType = new SerializableType<T>(explicitJavaType);
                    } else {
                        legacyType = jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(explicitJavaType, inferredJdbcType);
                    }
                } else {
                    legacyType = jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(explicitJavaType, inferredJdbcType);
                }
            }
        } else if (reflectedJtd != null) {
            if (explicitJdbcType != null) {
                legacyType = jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(reflectedJtd, explicitJdbcType);
            } else {
                if (reflectedJtd instanceof EnumJavaType) {
                    return InferredBasicValueResolver.fromEnum((EnumJavaType)reflectedJtd, null, null, stdIndicators, typeConfiguration);
                }
                if (reflectedJtd instanceof TemporalJavaType) {
                    return InferredBasicValueResolver.fromTemporal((TemporalJavaType)reflectedJtd, null, null, resolvedJavaType, stdIndicators, typeConfiguration);
                }
                BasicType registeredType = typeConfiguration.getBasicTypeRegistry().getRegisteredType(reflectedJtd.getJavaType());
                if (registeredType != null) {
                    jdbcMapping = legacyType = InferredBasicValueResolver.resolveSqlTypeIndicators(stdIndicators, registeredType, reflectedJtd);
                } else {
                    JdbcType recommendedJdbcType = reflectedJtd.getRecommendedJdbcType(stdIndicators);
                    if (recommendedJdbcType != null) {
                        legacyType = jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(reflectedJtd, recommendedJdbcType);
                    } else if (reflectedJtd instanceof SerializableJavaType || Serializable.class.isAssignableFrom(reflectedJtd.getJavaTypeClass())) {
                        jdbcMapping = legacyType = new SerializableType<T>(reflectedJtd);
                    } else {
                        legacyType = null;
                        jdbcMapping = null;
                    }
                }
            }
        } else if (explicitJdbcType != null) {
            Integer length = null;
            Integer scale = null;
            if (selectable instanceof Column) {
                Column column = (Column)selectable;
                if (column.getPrecision() != null && column.getPrecision() > 0) {
                    length = column.getPrecision();
                    scale = column.getScale();
                } else if (column.getLength() != null) {
                    length = column.getLength() > Integer.MAX_VALUE ? Integer.valueOf(Integer.MAX_VALUE) : Integer.valueOf(column.getLength().intValue());
                }
            }
            BasicJavaType recommendedJtd = explicitJdbcType.getJdbcRecommendedJavaTypeMapping(length, scale, typeConfiguration);
            legacyType = jdbcMapping = InferredBasicValueResolver.resolveSqlTypeIndicators(stdIndicators, typeConfiguration.getBasicTypeRegistry().resolve(recommendedJtd, explicitJdbcType), recommendedJtd);
        } else {
            throw new MappingException("Could not determine JavaType nor JdbcType to use for BasicValue: owner = " + ownerName + "; property = " + propertyName + "; table = " + table.getName() + "; column = " + selectable.getText());
        }
        if (jdbcMapping == null) {
            throw new MappingException("Could not determine JavaType nor JdbcType to use for " + ((BasicValue)stdIndicators).getResolvedJavaType() + "; table = " + table.getName() + "; column = " + selectable.getText());
        }
        return new InferredBasicValueResolution<T, T>(jdbcMapping, jdbcMapping.getJavaTypeDescriptor(), jdbcMapping.getJavaTypeDescriptor(), jdbcMapping.getJdbcType(), null, legacyType, null);
    }

    public static <T> BasicValue.Resolution<T> from(Function<TypeConfiguration, BasicJavaType> explicitJavaTypeAccess, Function<TypeConfiguration, JdbcType> explicitSqlTypeAccess, Type resolvedJavaType, Supplier<JavaType<T>> reflectedJtdResolver, JdbcTypeIndicators stdIndicators, Table table, Selectable selectable, String ownerName, String propertyName, TypeConfiguration typeConfiguration) {
        BasicJavaType explicitJavaType = explicitJavaTypeAccess != null ? explicitJavaTypeAccess.apply(typeConfiguration) : null;
        JdbcType explicitJdbcType = explicitSqlTypeAccess != null ? explicitSqlTypeAccess.apply(typeConfiguration) : null;
        return InferredBasicValueResolver.from(explicitJavaType, explicitJdbcType, resolvedJavaType, reflectedJtdResolver, stdIndicators, table, selectable, ownerName, propertyName, typeConfiguration);
    }

    public static <T> BasicType<T> resolveSqlTypeIndicators(JdbcTypeIndicators stdIndicators, BasicType<T> resolved, JavaType<T> domainJtd) {
        if (resolved instanceof AdjustableBasicType) {
            AdjustableBasicType indicatorCapable = (AdjustableBasicType)resolved;
            BasicType<T> indicatedType = indicatorCapable.resolveIndicatedType(stdIndicators, domainJtd);
            return indicatedType != null ? indicatedType : resolved;
        }
        return resolved;
    }

    public static <E extends Enum<E>> InferredBasicValueResolution<E, ?> fromEnum(EnumJavaType<E> enumJavaType, BasicJavaType<?> explicitJavaType, JdbcType explicitJdbcType, JdbcTypeIndicators stdIndicators, TypeConfiguration typeConfiguration) {
        EnumType enumStyle = stdIndicators.getEnumeratedType() != null ? stdIndicators.getEnumeratedType() : EnumType.ORDINAL;
        switch (enumStyle) {
            case STRING: {
                return InferredBasicValueResolver.stringEnumValueResolution(enumJavaType, explicitJavaType, explicitJdbcType, stdIndicators, typeConfiguration);
            }
            case ORDINAL: {
                return InferredBasicValueResolver.ordinalEnumValueResolution(enumJavaType, explicitJavaType, explicitJdbcType, typeConfiguration);
            }
        }
        throw new MappingException("Unknown enumeration-style (JPA EnumType) : " + enumStyle);
    }

    private static <E extends Enum<E>> InferredBasicValueResolution<E, Integer> ordinalEnumValueResolution(EnumJavaType<E> enumJavaType, BasicJavaType<?> explicitJavaType, JdbcType explicitJdbcType, TypeConfiguration typeConfiguration) {
        JavaType<Integer> relationalJtd;
        if (explicitJavaType != null) {
            if (!Integer.class.isAssignableFrom(explicitJavaType.getJavaTypeClass())) {
                throw new MappingException("Explicit JavaType [" + explicitJavaType + "] applied to enumerated value with EnumType#ORDINAL should handle `java.lang.Integer` as its relational type descriptor");
            }
            relationalJtd = explicitJavaType;
        } else {
            relationalJtd = typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)((Object)Integer.class));
        }
        JdbcType jdbcType = explicitJdbcType != null ? explicitJdbcType : typeConfiguration.getJdbcTypeRegistry().getDescriptor(-6);
        OrdinalEnumValueConverter<E> valueConverter = new OrdinalEnumValueConverter<E>(enumJavaType, jdbcType, relationalJtd);
        return new InferredBasicValueResolution<E, Integer>(typeConfiguration.getBasicTypeRegistry().resolve(relationalJtd, jdbcType), enumJavaType, relationalJtd, jdbcType, valueConverter, new CustomType(new org.hibernate.type.EnumType(enumJavaType.getJavaTypeClass(), valueConverter, typeConfiguration), typeConfiguration), ImmutableMutabilityPlan.instance());
    }

    private static <E extends Enum<E>> InferredBasicValueResolution<E, String> stringEnumValueResolution(EnumJavaType<E> enumJavaType, BasicJavaType<?> explicitJavaType, JdbcType explicitJdbcType, JdbcTypeIndicators stdIndicators, TypeConfiguration typeConfiguration) {
        BasicJavaType<String> relationalJtd;
        if (explicitJavaType != null) {
            if (!String.class.isAssignableFrom(explicitJavaType.getJavaTypeClass())) {
                throw new MappingException("Explicit JavaType [" + explicitJavaType + "] applied to enumerated value with EnumType#STRING should handle `java.lang.String` as its relational type descriptor");
            }
            relationalJtd = explicitJavaType;
        } else {
            boolean useCharacter = stdIndicators.getColumnLength() == 1L;
            relationalJtd = typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)((Object)(useCharacter ? Character.class : String.class)));
        }
        JdbcType jdbcType = explicitJdbcType != null ? explicitJdbcType : relationalJtd.getRecommendedJdbcType(stdIndicators);
        NamedEnumValueConverter<E> valueConverter = new NamedEnumValueConverter<E>(enumJavaType, jdbcType, relationalJtd);
        return new InferredBasicValueResolution<E, String>(typeConfiguration.getBasicTypeRegistry().resolve(relationalJtd, jdbcType), enumJavaType, relationalJtd, jdbcType, valueConverter, new CustomType(new org.hibernate.type.EnumType(enumJavaType.getJavaTypeClass(), valueConverter, typeConfiguration), typeConfiguration), ImmutableMutabilityPlan.instance());
    }

    public static <T> InferredBasicValueResolution<T, T> fromTemporal(TemporalJavaType<T> reflectedJtd, BasicJavaType<?> explicitJavaType, JdbcType explicitJdbcType, Type resolvedJavaType, JdbcTypeIndicators stdIndicators, TypeConfiguration typeConfiguration) {
        TemporalType requestedTemporalPrecision = stdIndicators.getTemporalPrecision();
        if (explicitJavaType != null) {
            if (!(explicitJavaType instanceof TemporalJavaType)) {
                throw new MappingException("Explicit JavaType [" + explicitJavaType + "] defined for temporal value must implement TemporalJavaType");
            }
            TemporalJavaType explicitTemporalJtd = (TemporalJavaType)explicitJavaType;
            if (requestedTemporalPrecision != null && explicitTemporalJtd.getPrecision() != requestedTemporalPrecision) {
                throw new MappingException("Temporal precision (`jakarta.persistence.TemporalType`) mismatch... requested precision = " + requestedTemporalPrecision + "; explicit JavaType (`" + explicitTemporalJtd + "`) precision = " + explicitTemporalJtd.getPrecision());
            }
            JdbcType jdbcType = explicitJdbcType != null ? explicitJdbcType : explicitTemporalJtd.getRecommendedJdbcType(stdIndicators);
            BasicType jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(explicitTemporalJtd, jdbcType);
            return new InferredBasicValueResolution(jdbcMapping, explicitTemporalJtd, explicitTemporalJtd, jdbcType, null, jdbcMapping, explicitTemporalJtd.getMutabilityPlan());
        }
        if (explicitJdbcType != null) {
            TemporalJavaType<Object> jtd = requestedTemporalPrecision != null ? reflectedJtd.resolveTypeForPrecision(requestedTemporalPrecision, typeConfiguration) : reflectedJtd;
            BasicType<T> jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(jtd, explicitJdbcType);
            return new InferredBasicValueResolution<Object, Object>(jdbcMapping, jtd, jtd, explicitJdbcType, null, jdbcMapping, jtd.getMutabilityPlan());
        }
        BasicType<Object> basicType = requestedTemporalPrecision != null && requestedTemporalPrecision != reflectedJtd.getPrecision() ? typeConfiguration.getBasicTypeRegistry().resolve(reflectedJtd.resolveTypeForPrecision(requestedTemporalPrecision, typeConfiguration), TemporalJavaType.resolveJdbcTypeCode(requestedTemporalPrecision)) : typeConfiguration.getBasicTypeRegistry().resolve(reflectedJtd, reflectedJtd.getRecommendedJdbcType(stdIndicators));
        return new InferredBasicValueResolution<Object, Object>(basicType, basicType.getJavaTypeDescriptor(), basicType.getJavaTypeDescriptor(), basicType.getJdbcType(), null, basicType, reflectedJtd.getMutabilityPlan());
    }
}

