/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import org.hibernate.engine.jdbc.internal.Formatter;

public class BasicFormatterImpl
implements Formatter {
    private static final Set<String> NON_FUNCTION_NAMES = Set.of("select", "from", "on", "set", "and", "or", "where", "having", "by");
    private static final String INDENT_STRING = "    ";
    private static final String INITIAL = System.lineSeparator() + "    ";

    @Override
    public String format(String source) {
        return new FormatProcess(source).perform();
    }

    private static class FormatProcess {
        boolean beginLine = true;
        boolean afterBeginBeforeEnd;
        boolean afterByOrSetOrFromOrSelect;
        boolean afterOn;
        boolean afterBetween;
        boolean afterExtract;
        boolean afterInsert;
        int inFunction;
        int parensSinceSelect;
        private final LinkedList<Integer> parenCounts = new LinkedList();
        private final LinkedList<Boolean> afterByOrFromOrSelects = new LinkedList();
        int indent = 1;
        StringBuilder result = new StringBuilder();
        StringTokenizer tokens;
        String lastToken;
        String token;
        String lcToken;

        public FormatProcess(String sql) {
            assert (sql != null) : "SQL to format should not be null";
            this.tokens = new StringTokenizer(sql, "()+*/-=<>'`\"[], \n\r\f\t", true);
        }

        public String perform() {
            this.result.append(INITIAL);
            while (this.tokens.hasMoreTokens()) {
                this.token = this.tokens.nextToken();
                switch (this.lcToken = this.token.toLowerCase(Locale.ROOT)) {
                    case "'": 
                    case "\"": {
                        String t;
                        do {
                            t = this.tokens.nextToken();
                            this.token = this.token + t;
                        } while (!this.lcToken.equals(t) && this.tokens.hasMoreTokens());
                        this.lcToken = this.token;
                        this.misc();
                        break;
                    }
                    case "[": {
                        String tt;
                        do {
                            tt = this.tokens.nextToken();
                            this.token = this.token + tt;
                        } while (!"]".equals(tt) && this.tokens.hasMoreTokens());
                        this.lcToken = this.token;
                        this.misc();
                        break;
                    }
                    case ",": {
                        if (this.afterByOrSetOrFromOrSelect && this.inFunction == 0) {
                            this.commaAfterByOrFromOrSelect();
                            break;
                        }
                        if (this.afterOn && this.inFunction == 0) {
                            this.commaAfterOn();
                            break;
                        }
                        this.misc();
                        break;
                    }
                    case "(": {
                        this.openParen();
                        break;
                    }
                    case ")": {
                        this.closeParen();
                        break;
                    }
                    case "select": {
                        this.select();
                        break;
                    }
                    case "insert": 
                    case "update": 
                    case "delete": {
                        this.updateOrInsertOrDelete();
                        break;
                    }
                    case "values": {
                        this.values();
                        break;
                    }
                    case "on": {
                        this.on();
                        break;
                    }
                    case "between": {
                        this.afterBetween = true;
                        this.misc();
                        break;
                    }
                    case "trim": 
                    case "extract": {
                        this.afterExtract = true;
                        this.misc();
                        break;
                    }
                    case "left": 
                    case "right": 
                    case "full": 
                    case "inner": 
                    case "outer": 
                    case "cross": 
                    case "group": 
                    case "order": {
                        this.beginNewClause();
                        break;
                    }
                    case "from": {
                        if (this.afterExtract) {
                            this.misc();
                            this.afterExtract = false;
                            break;
                        }
                    }
                    case "where": 
                    case "set": 
                    case "having": 
                    case "by": 
                    case "join": 
                    case "into": 
                    case "union": 
                    case "intersect": {
                        this.endNewClause();
                        break;
                    }
                    case "case": {
                        this.beginCase();
                        break;
                    }
                    case "end": {
                        this.endCase();
                        break;
                    }
                    case "and": {
                        if (this.afterBetween) {
                            this.misc();
                            this.afterBetween = false;
                            break;
                        }
                    }
                    case "or": 
                    case "when": 
                    case "else": {
                        this.logical();
                        break;
                    }
                    default: {
                        if (FormatProcess.isWhitespace(this.token)) {
                            this.white();
                            break;
                        }
                        this.misc();
                    }
                }
                if (FormatProcess.isWhitespace(this.token)) continue;
                this.lastToken = this.lcToken;
            }
            return this.result.toString();
        }

        private void commaAfterOn() {
            this.out();
            --this.indent;
            this.newline();
            this.afterOn = false;
            this.afterByOrSetOrFromOrSelect = true;
        }

        private void commaAfterByOrFromOrSelect() {
            this.out();
            this.newline();
        }

        private void logical() {
            this.newline();
            this.out();
            this.beginLine = false;
        }

        private void endCase() {
            --this.indent;
            this.logical();
        }

        private void on() {
            ++this.indent;
            this.afterOn = true;
            this.newline();
            this.out();
            this.beginLine = false;
        }

        private void beginCase() {
            this.out();
            this.beginLine = false;
            ++this.indent;
        }

        private void misc() {
            this.out();
            if (this.afterInsert && this.inFunction == 0) {
                this.newline();
                this.afterInsert = false;
            } else {
                this.beginLine = false;
            }
        }

        private void white() {
            if (!this.beginLine) {
                this.result.append(" ");
            }
        }

        private void updateOrInsertOrDelete() {
            if (this.indent > 1) {
                this.out();
            } else {
                this.out();
                ++this.indent;
                this.beginLine = false;
                if ("update".equals(this.lcToken)) {
                    this.newline();
                }
                if ("insert".equals(this.lcToken)) {
                    this.afterInsert = true;
                }
            }
        }

        private void select() {
            this.out();
            ++this.indent;
            this.newline();
            this.parenCounts.addLast(this.parensSinceSelect);
            this.afterByOrFromOrSelects.addLast(this.afterByOrSetOrFromOrSelect);
            this.parensSinceSelect = 0;
            this.afterByOrSetOrFromOrSelect = true;
        }

        private void out() {
            this.result.append(this.token);
        }

        private void endNewClause() {
            if (!this.afterBeginBeforeEnd) {
                --this.indent;
                if (this.afterOn) {
                    --this.indent;
                    this.afterOn = false;
                }
                this.newline();
            }
            this.out();
            if (!"union".equals(this.lcToken) && !"intersect".equals(this.lcToken)) {
                ++this.indent;
            }
            this.newline();
            this.afterBeginBeforeEnd = false;
            this.afterByOrSetOrFromOrSelect = "by".equals(this.lcToken) || "set".equals(this.lcToken) || "from".equals(this.lcToken);
        }

        private void beginNewClause() {
            if (!this.afterBeginBeforeEnd) {
                if (this.afterOn) {
                    --this.indent;
                    this.afterOn = false;
                }
                --this.indent;
                this.newline();
            }
            this.out();
            this.beginLine = false;
            this.afterBeginBeforeEnd = true;
        }

        private void values() {
            if (this.parensSinceSelect == 0) {
                --this.indent;
                this.newline();
                this.out();
                ++this.indent;
                this.newline();
            } else {
                this.out();
            }
        }

        private void closeParen() {
            --this.parensSinceSelect;
            if (this.parensSinceSelect < 0) {
                --this.indent;
                this.parensSinceSelect = this.parenCounts.removeLast();
                this.afterByOrSetOrFromOrSelect = this.afterByOrFromOrSelects.removeLast();
            }
            if (this.inFunction > 0) {
                --this.inFunction;
                this.out();
            } else {
                if (!this.afterByOrSetOrFromOrSelect) {
                    --this.indent;
                    this.newline();
                }
                this.out();
            }
            this.beginLine = false;
        }

        private void openParen() {
            if (FormatProcess.isFunctionName(this.lastToken) || this.inFunction > 0) {
                ++this.inFunction;
            }
            this.beginLine = false;
            if (this.inFunction > 0) {
                this.out();
            } else {
                this.out();
                if (!this.afterByOrSetOrFromOrSelect) {
                    ++this.indent;
                    this.newline();
                    this.beginLine = true;
                }
            }
            ++this.parensSinceSelect;
        }

        private static boolean isFunctionName(String tok) {
            if (tok == null || tok.length() == 0) {
                return false;
            }
            char begin = tok.charAt(0);
            boolean isIdentifier = Character.isJavaIdentifierStart(begin) || '\"' == begin;
            return isIdentifier && !NON_FUNCTION_NAMES.contains(tok);
        }

        private static boolean isWhitespace(String token) {
            return " \n\r\f\t".contains(token);
        }

        private void newline() {
            this.result.append(System.lineSeparator()).append(BasicFormatterImpl.INDENT_STRING.repeat(this.indent));
            this.beginLine = true;
        }
    }
}

