/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Destination;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnector;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManagerFactory;
import org.apache.activemq.artemis.protocol.amqp.client.AMQPClientConnectionFactory;
import org.apache.activemq.artemis.protocol.amqp.client.ProtonClientConnectionManager;
import org.apache.activemq.artemis.protocol.amqp.client.ProtonClientProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.EventHandler;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.ProtonHandler;
import org.apache.activemq.artemis.protocol.amqp.sasl.ClientSASL;
import org.apache.activemq.artemis.protocol.amqp.sasl.ClientSASLFactory;
import org.apache.activemq.artemis.spi.core.remoting.BaseConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.apache.qpid.jms.sasl.GssapiMechanism;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.engine.Connection;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSSaslGssapiTest
extends JMSClientTestSupport {
    private static final Logger LOG;
    private static final String KRB5_TCP_PORT_TEMPLATE = "MINI_KDC_PORT";
    private static final String KRB5_CONFIG_TEMPLATE = "minikdc-krb5-template.conf";
    private static final String KRB5_DEFAULT_KEYTAB = "target/test.krb5.keytab";
    private static MiniKdc kdc;
    private static final boolean debug = false;

    @BeforeClass
    public static void setUpKerberos() throws Exception {
        Properties kdcConf = MiniKdc.createConf();
        kdcConf.setProperty("debug", Boolean.toString(false));
        kdc = new MiniKdc(kdcConf, new File("target/"));
        kdc.start();
        File userKeyTab = new File(KRB5_DEFAULT_KEYTAB);
        kdc.createPrincipal(userKeyTab, new String[]{"client", "amqp/localhost"});
        JMSSaslGssapiTest.rewriteKrbConfFile(kdc);
    }

    @AfterClass
    public static void stopKerberos() throws Exception {
        if (kdc != null) {
            kdc.stop();
        }
    }

    @Override
    protected boolean isSecurityEnabled() {
        return true;
    }

    @Override
    protected void configureBrokerSecurity(ActiveMQServer server) {
        server.getConfiguration().setSecurityEnabled(this.isSecurityEnabled());
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.setConfigurationName("Krb5Plus");
        securityManager.setConfiguration(null);
        String roleName = "ALLOW_ALL";
        Role role = new Role("ALLOW_ALL", true, true, true, true, true, true, true, true, true, true);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        server.getSecurityRepository().addMatch(this.getQueueName().toString(), roles);
    }

    @Override
    protected String getJmsConnectionURIOptions() {
        return "amqp.saslMechanisms=GSSAPI";
    }

    @Override
    protected URI getBrokerQpidJMSConnectionURI() {
        try {
            int port = 5672;
            String uri = "amqp://localhost:" + port;
            if (!this.getJmsConnectionURIOptions().isEmpty()) {
                uri = uri + "?" + this.getJmsConnectionURIOptions();
            }
            return new URI(uri);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    @Override
    protected void configureAMQPAcceptorParameters(Map<String, Object> params) {
        params.put("saslMechanisms", "GSSAPI");
        params.put("saslLoginConfigScope", "amqp-sasl-gssapi");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=600000L)
    public void testConnection() throws Exception {
        connection.start();
        try (jakarta.jms.Connection connection = this.createConnection("client", null);){
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(this.getQueueName());
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            MessageProducer producer = session.createProducer((Destination)queue);
            String text = RandomUtil.randomString();
            producer.send((Message)session.createTextMessage(text));
            TextMessage m = (TextMessage)consumer.receive(1000L);
            JMSSaslGssapiTest.assertNotNull((Object)m);
            JMSSaslGssapiTest.assertEquals((Object)text, (Object)m.getText());
        }
    }

    @Test(timeout=600000L)
    public void testSaslPlainConnectionDenied() throws Exception {
        JmsConnectionFactory factory = new JmsConnectionFactory(new URI("amqp://localhost:5672?amqp.saslMechanisms=PLAIN"));
        try {
            factory.createConnection("plain", "secret");
            JMSSaslGssapiTest.fail((String)"Expect sasl failure");
        }
        catch (JMSSecurityException expected) {
            JMSSaslGssapiTest.assertTrue((boolean)expected.getMessage().contains("SASL"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=900000L)
    public void testOutboundWithSlowMech() throws Exception {
        LinkedHashMap<String, String> config = new LinkedHashMap<String, String>();
        config.put("host", "localhost");
        config.put("port", String.valueOf(5672));
        ClientSASLFactory clientSASLFactory = new ClientSASLFactory(){

            public ClientSASL chooseMechanism(String[] availableMechanims) {
                final GssapiMechanism gssapiMechanism = new GssapiMechanism();
                return new ClientSASL(){

                    public String getName() {
                        return gssapiMechanism.getName();
                    }

                    public byte[] getInitialResponse() {
                        gssapiMechanism.setUsername("client");
                        gssapiMechanism.setServerName("localhost");
                        try {
                            return gssapiMechanism.getInitialResponse();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return new byte[0];
                        }
                    }

                    public byte[] getResponse(byte[] challenge) {
                        try {
                            TimeUnit.SECONDS.sleep(4L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        try {
                            return gssapiMechanism.getChallengeResponse(challenge);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return new byte[0];
                        }
                    }
                };
            }
        };
        final AtomicBoolean connectionOpened = new AtomicBoolean();
        final AtomicBoolean authFailed = new AtomicBoolean();
        EventHandler eventHandler = new EventHandler(){

            public void onRemoteOpen(Connection connection) throws Exception {
                connectionOpened.set(true);
            }

            public void onAuthFailed(ProtonHandler protonHandler, Connection connection) {
                authFailed.set(true);
            }
        };
        ProtonClientConnectionManager lifeCycleListener = new ProtonClientConnectionManager(new AMQPClientConnectionFactory(this.server, "myid", Collections.singletonMap(Symbol.getSymbol((String)"myprop"), "propvalue"), 5000), Optional.of(eventHandler), clientSASLFactory);
        ProtonClientProtocolManager protocolManager = new ProtonClientProtocolManager(new ProtonProtocolManagerFactory(), this.server);
        NettyConnector connector = new NettyConnector(config, (BufferHandler)lifeCycleListener, (BaseConnectionLifeCycleListener)lifeCycleListener, (Executor)this.server.getExecutorFactory().getExecutor(), (Executor)this.server.getExecutorFactory().getExecutor(), this.server.getScheduledPool(), (ClientProtocolManager)protocolManager);
        connector.start();
        connector.createConnection();
        try {
            Wait.assertEquals((int)1, () -> ((ActiveMQServer)this.server).getConnectionCount());
            Wait.assertTrue(connectionOpened::get);
            Wait.assertFalse(authFailed::get);
            lifeCycleListener.stop();
            Wait.assertEquals((int)0, () -> ((ActiveMQServer)this.server).getConnectionCount());
        }
        finally {
            lifeCycleListener.stop();
        }
    }

    private static void rewriteKrbConfFile(MiniKdc server) throws Exception {
        Path template = Paths.get(JMSSaslGssapiTest.class.getClassLoader().getResource(KRB5_CONFIG_TEMPLATE).toURI());
        String krb5confTemplate = new String(Files.readAllBytes(template), StandardCharsets.UTF_8);
        String replacementPort = Integer.toString(server.getPort());
        String krb5confUpdated = krb5confTemplate.replaceAll(KRB5_TCP_PORT_TEMPLATE, replacementPort);
        try (OutputStream outputStream = Files.newOutputStream(server.getKrb5conf().toPath(), new OpenOption[0]);
             WritableByteChannel channel = Channels.newChannel(outputStream);){
            channel.write(ByteBuffer.wrap(krb5confUpdated.getBytes(StandardCharsets.UTF_8)));
        }
    }

    private static /* synthetic */ void lambda$setUpKerberos$0(String line) {
        LOG.debug(line);
    }

    static {
        URL resource;
        LOG = LoggerFactory.getLogger(JMSSaslGssapiTest.class);
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = JMSSaslGssapiTest.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
    }
}

