/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.journal;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.activemq.artemis.cli.commands.tools.PrintData;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.persistence.impl.journal.DescribeJournal;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.jms.server.config.impl.FileJMSConfiguration;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.jaas.InVMLoginModule;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JournalDataPrintTest
extends ActiveMQTestBase {
    protected ActiveMQServer server;

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJournalDataPrint() throws Exception {
        ActiveMQServer server = this.getActiveMQServer("dataprint/etc/broker.xml");
        try {
            server.start();
            server.stop();
            DescribeJournal journal = new DescribeJournal(null, null);
            System.setProperty("artemis.instance", ((Object)((Object)this)).getClass().getClassLoader().getResource("dataprint").getFile());
            PrintData.printData((File)server.getConfiguration().getBindingsLocation().getAbsoluteFile(), (File)server.getConfiguration().getJournalLocation().getAbsoluteFile(), (File)server.getConfiguration().getPagingLocation().getAbsoluteFile(), (PrintStream)new PrintStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            }), (boolean)false, (boolean)false);
            File dirFile = server.getConfiguration().getJournalLocation().getAbsoluteFile();
            File[] files = dirFile.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File journalFile = files[i];
                Assert.assertEquals((long)0x1E00000L, (long)journalFile.length());
            }
            server.start();
        }
        finally {
            try {
                server.stop();
            }
            catch (Exception exception) {}
        }
    }

    protected ActiveMQServer getActiveMQServer(String brokerConfig) throws Exception {
        FileConfiguration fc = new FileConfiguration();
        FileJMSConfiguration fileConfiguration = new FileJMSConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager(brokerConfig);
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.addDeployable((Deployable)fileConfiguration);
        deploymentManager.readConfiguration();
        ActiveMQJAASSecurityManager sm = new ActiveMQJAASSecurityManager(InVMLoginModule.class.getName(), new SecurityConfiguration());
        JournalDataPrintTest.recreateDirectory((String)fc.getBindingsDirectory());
        JournalDataPrintTest.recreateDirectory((String)fc.getJournalDirectory());
        JournalDataPrintTest.recreateDirectory((String)fc.getPagingDirectory());
        JournalDataPrintTest.recreateDirectory((String)fc.getLargeMessagesDirectory());
        return this.addServer((ActiveMQServer)new ActiveMQServerImpl((Configuration)fc, (ActiveMQSecurityManager)sm));
    }
}

