/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.rest;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSConnectionFactory;
import org.apache.activemq.artemis.tests.integration.rest.Order;
import org.apache.activemq.artemis.tests.integration.rest.RestTestBase;
import org.apache.activemq.artemis.tests.integration.rest.util.QueueRestMessageContext;
import org.apache.activemq.artemis.tests.integration.rest.util.RestAMQConnection;
import org.apache.activemq.artemis.tests.integration.rest.util.RestMessageContext;
import org.apache.activemq.artemis.tests.integration.rest.util.TopicRestMessageContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class RestDeserializationTest
extends RestTestBase {
    private RestAMQConnection restConnection;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.createJettyServer("localhost", 12345);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.restConnection != null) {
            this.restConnection.close();
        }
        super.tearDown();
    }

    @Test
    public void testWithoutBlackWhiteListQueue() throws Exception {
        this.deployAndconfigureRESTService("rest-test.war");
        Order order = new Order();
        order.setName("Bill");
        order.setItem("iPhone4");
        order.setAmount("$199.99");
        this.jmsSendMessage(order, "orders", true);
        String received = this.restReceiveQueueMessage("orders");
        Object object = this.xmlToObject(received);
        RestDeserializationTest.assertEquals((Object)order, (Object)object);
    }

    @Test
    public void testWithoutBlackWhiteListTopic() throws Exception {
        this.jmsServer.getActiveMQServer().addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)"ordersTopic"), RoutingType.MULTICAST));
        this.deployAndconfigureRESTService("rest-test.war");
        TopicRestMessageContext topicContext = this.restConnection.createTopicContext("ordersTopic");
        ((RestMessageContext)topicContext).initPullConsumers();
        Order order = new Order();
        order.setName("Bill");
        order.setItem("iPhone4");
        order.setAmount("$199.99");
        this.jmsSendMessage(order, "ordersTopic", false);
        String received = topicContext.pullMessage();
        Object object = this.xmlToObject(received);
        RestDeserializationTest.assertEquals((Object)order, (Object)object);
    }

    @Test
    public void testBlackWhiteListQueuePull() throws Exception {
        this.deployAndconfigureRESTService("rest-test-bwlist.war");
        Order order = new Order();
        order.setName("Bill");
        order.setItem("iPhone4");
        order.setAmount("$199.99");
        this.jmsSendMessage(order, "orders", true);
        try {
            String received = this.restReceiveQueueMessage("orders");
            RestDeserializationTest.fail((String)("Object should be rejected by blacklist, but " + received));
        }
        catch (IllegalStateException e) {
            String error = e.getMessage();
            RestDeserializationTest.assertTrue((String)error, (boolean)error.contains("ClassNotFoundException"));
        }
    }

    @Test
    public void testBlackWhiteListTopicPull() throws Exception {
        this.deployAndconfigureRESTService("rest-test-bwlist.war");
        TopicRestMessageContext topicContext = this.restConnection.createTopicContext("ordersTopic");
        ((RestMessageContext)topicContext).initPullConsumers();
        Order order = new Order();
        order.setName("Bill");
        order.setItem("iPhone4");
        order.setAmount("$199.99");
        this.jmsSendMessage(order, "ordersTopic", false);
        try {
            String received = topicContext.pullMessage();
            RestDeserializationTest.fail((String)("object should have been rejected but: " + received));
        }
        catch (IllegalStateException e) {
            String error = e.getMessage();
            RestDeserializationTest.assertTrue((String)error, (boolean)error.contains("ClassNotFoundException"));
        }
    }

    private void deployAndconfigureRESTService(String warFileName) throws Exception {
        this.jmsServer.createTopic(false, "ordersTopic", (String[])null);
        File warFile = this.getResourceFile("/rest/" + warFileName, warFileName);
        this.deployWebApp("/restapp", warFile);
        this.server.start();
        String uri = this.server.getURI().toASCIIString();
        this.restConnection = new RestAMQConnection(uri);
    }

    private Object xmlToObject(String xmlString) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Order.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        StringReader reader = new StringReader(xmlString);
        return unmarshaller.unmarshal((Reader)reader);
    }

    private String restReceiveQueueMessage(String destName) throws Exception {
        QueueRestMessageContext restContext = this.restConnection.createQueueContext(destName);
        String val = restContext.pullMessage();
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jmsSendMessage(Serializable value, String destName, boolean isQueue) throws JMSException {
        ActiveMQJMSConnectionFactory factory = new ActiveMQJMSConnectionFactory("tcp://localhost:61616");
        String jmsDest = isQueue ? "queue://" + destName : "topic://" + destName;
        ActiveMQDestination destination = ActiveMQDestination.fromPrefixedName((String)jmsDest);
        try (Connection conn = factory.createConnection();){
            Session session = conn.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)destination);
            ObjectMessage message = session.createObjectMessage();
            message.setStringProperty("http_content$type", "application/xml");
            message.setObject(value);
            producer.send((Message)message);
        }
    }
}

