/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb.hacks;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.UnmarshallerHandler;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.bind.attachment.AttachmentUnmarshaller;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.jboss.resteasy.plugins.providers.jaxb.hacks.PropertyResolver;
import org.jboss.resteasy.plugins.providers.jaxb.i18n.LogMessages;
import org.jboss.resteasy.plugins.providers.jaxb.i18n.Messages;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

class DelegatingUnmarshaller
implements Unmarshaller {
    private final Unmarshaller delegate;

    DelegatingUnmarshaller(Unmarshaller delegate) {
        this.delegate = delegate;
    }

    public Object unmarshal(File f) throws JAXBException {
        return this.delegate.unmarshal(f);
    }

    public Object unmarshal(InputStream is) throws JAXBException {
        return this.delegate.unmarshal(is);
    }

    public Object unmarshal(Reader reader) throws JAXBException {
        return this.delegate.unmarshal(reader);
    }

    public Object unmarshal(URL url) throws JAXBException {
        return this.delegate.unmarshal(url);
    }

    public Object unmarshal(InputSource source) throws JAXBException {
        return this.delegate.unmarshal(source);
    }

    public Object unmarshal(Node node) throws JAXBException {
        return this.delegate.unmarshal(node);
    }

    public <T> JAXBElement<T> unmarshal(Node node, Class<T> declaredType) throws JAXBException {
        return this.delegate.unmarshal(node, declaredType);
    }

    public Object unmarshal(Source source) throws JAXBException {
        return this.delegate.unmarshal(source);
    }

    public <T> JAXBElement<T> unmarshal(Source source, Class<T> declaredType) throws JAXBException {
        return this.delegate.unmarshal(source, declaredType);
    }

    public Object unmarshal(XMLStreamReader reader) throws JAXBException {
        return this.delegate.unmarshal(reader);
    }

    public <T> JAXBElement<T> unmarshal(XMLStreamReader reader, Class<T> declaredType) throws JAXBException {
        return this.delegate.unmarshal(reader, declaredType);
    }

    public Object unmarshal(XMLEventReader reader) throws JAXBException {
        return this.delegate.unmarshal(reader);
    }

    public <T> JAXBElement<T> unmarshal(XMLEventReader reader, Class<T> declaredType) throws JAXBException {
        return this.delegate.unmarshal(reader, declaredType);
    }

    public UnmarshallerHandler getUnmarshallerHandler() {
        return this.delegate.getUnmarshallerHandler();
    }

    public void setValidating(boolean validating) throws JAXBException {
        this.delegate.setValidating(validating);
    }

    public boolean isValidating() throws JAXBException {
        return this.delegate.isValidating();
    }

    public void setEventHandler(ValidationEventHandler handler) throws JAXBException {
        this.delegate.setEventHandler(handler);
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.delegate.getEventHandler();
    }

    public void setProperty(String name, Object value) throws PropertyException {
        try {
            this.delegate.setProperty(name, value);
            return;
        }
        catch (PropertyException e) {
            LogMessages.LOGGER.debugf(e, "Failed to set %s with value %s", name, value);
            String newName = PropertyResolver.resolveProperty(name);
            if (newName != null) {
                try {
                    this.delegate.setProperty(newName, value);
                    return;
                }
                catch (PropertyException e2) {
                    LogMessages.LOGGER.debugf(e2, "Failed to set %s with value %s", newName, value);
                }
            } else {
                throw Messages.MESSAGES.couldNotAddProperty(name, value);
            }
            throw Messages.MESSAGES.couldNotAddProperty(name, newName, value);
        }
    }

    public Object getProperty(String name) throws PropertyException {
        try {
            return this.delegate.getProperty(name);
        }
        catch (PropertyException e) {
            LogMessages.LOGGER.debugf(e, "Failed to get property %s.", name);
            String newName = PropertyResolver.resolveProperty(name);
            if (newName != null) {
                try {
                    return this.delegate.getProperty(newName);
                }
                catch (PropertyException e2) {
                    LogMessages.LOGGER.debugf(e2, "Failed to get property %s.", name);
                }
            } else {
                throw Messages.MESSAGES.couldNotGetProperty(name);
            }
            throw Messages.MESSAGES.couldNotGetProperty(name, newName);
        }
    }

    public void setSchema(Schema schema) {
        this.delegate.setSchema(schema);
    }

    public Schema getSchema() {
        return this.delegate.getSchema();
    }

    public void setAdapter(XmlAdapter adapter) {
        this.delegate.setAdapter(adapter);
    }

    public <A extends XmlAdapter> void setAdapter(Class<A> type, A adapter) {
        this.delegate.setAdapter(type, adapter);
    }

    public <A extends XmlAdapter> A getAdapter(Class<A> type) {
        return (A)this.delegate.getAdapter(type);
    }

    public void setAttachmentUnmarshaller(AttachmentUnmarshaller au) {
        this.delegate.setAttachmentUnmarshaller(au);
    }

    public AttachmentUnmarshaller getAttachmentUnmarshaller() {
        return this.delegate.getAttachmentUnmarshaller();
    }

    public void setListener(Unmarshaller.Listener listener) {
        this.delegate.setListener(listener);
    }

    public Unmarshaller.Listener getListener() {
        return this.delegate.getListener();
    }
}

