/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.composite;

import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.facelets.tag.composite.CompositeComponentBeanInfo;
import com.sun.faces.facelets.tag.composite.PropertyHandler;
import com.sun.faces.facelets.tag.composite.PropertyHandlerManager;
import com.sun.faces.facelets.util.ReflectionUtil;
import com.sun.faces.util.FacesLogger;
import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagAttributeException;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagException;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AttributeHandler
extends TagHandlerImpl {
    private final Logger LOGGER = FacesLogger.TAGLIB.getLogger();
    private static final String[] COMPOSITE_ATTRIBUTE_ATTRIBUTES = new String[]{"required", "targets", "targetAttributeName", "default", "displayName", "preferred", "hidden", "expert", "shortDescription", "method-signature", "type"};
    private static final PropertyHandlerManager ATTRIBUTE_MANAGER = PropertyHandlerManager.getInstance(COMPOSITE_ATTRIBUTE_ATTRIBUTES);
    private TagAttribute name = this.getRequiredAttribute("name");

    public AttributeHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        CCAttributePropertyDescriptor propertyDescriptor;
        if (null == parent || null == (parent = parent.getParent()) || !ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        Map attrs = parent.getAttributes();
        CompositeComponentBeanInfo componentBeanInfo = (CompositeComponentBeanInfo)attrs.get("jakarta.faces.component.BEANINFO_KEY");
        assert (null != componentBeanInfo);
        List<PropertyDescriptor> declaredAttributes = componentBeanInfo.getPropertyDescriptorsList();
        ValueExpression ve = this.name.getValueExpression(ctx, String.class);
        String strValue = (String)ve.getValue((ELContext)ctx);
        for (PropertyDescriptor cur : declaredAttributes) {
            if (!strValue.endsWith(cur.getName())) continue;
            return;
        }
        try {
            propertyDescriptor = new CCAttributePropertyDescriptor(strValue, null, null);
            declaredAttributes.add(propertyDescriptor);
        }
        catch (IntrospectionException ex) {
            throw new TagException(this.tag, "Unable to create property descriptor for property " + strValue, (Throwable)ex);
        }
        TagAttribute defaultTagAttribute = null;
        PropertyHandler defaultHandler = null;
        for (TagAttribute tagAttribute : this.tag.getAttributes().getAll()) {
            String attributeName = tagAttribute.getLocalName();
            if ("default".equals(attributeName)) {
                defaultTagAttribute = tagAttribute;
                defaultHandler = ATTRIBUTE_MANAGER.getHandler(ctx, "default");
                continue;
            }
            PropertyHandler handler = ATTRIBUTE_MANAGER.getHandler(ctx, attributeName);
            if (handler == null) continue;
            handler.apply(ctx, attributeName, propertyDescriptor, tagAttribute);
        }
        if (defaultHandler != null) {
            try {
                defaultHandler.apply(ctx, "default", propertyDescriptor, defaultTagAttribute);
            }
            catch (IllegalArgumentException ex) {
                throw new TagException(this.tag, "'type' could not be resolved: " + ex.getCause(), ex.getCause());
            }
        }
        this.nextHandler.apply(ctx, parent);
    }

    private class CCAttributePropertyDescriptor
    extends PropertyDescriptor {
        public CCAttributePropertyDescriptor(String propertyName, Method readMethod, Method writeMethod) throws IntrospectionException {
            super(propertyName, readMethod, writeMethod);
        }

        @Override
        public Object getValue(String attributeName) {
            Object result;
            block6: {
                FacesContext context;
                ELContext elContext;
                Object classStr;
                result = super.getValue(attributeName);
                if ("type".equals(attributeName) && null != result && !(result instanceof Class) && null != (classStr = (String)((ValueExpression)result).getValue(elContext = (context = FacesContext.getCurrentInstance()).getELContext()))) {
                    try {
                        result = ReflectionUtil.forName((String)classStr);
                        this.setValue(attributeName, result);
                    }
                    catch (ClassNotFoundException ex) {
                        classStr = "java.lang." + (String)classStr;
                        boolean throwException = false;
                        try {
                            result = ReflectionUtil.forName((String)classStr);
                            this.setValue(attributeName, result);
                        }
                        catch (ClassNotFoundException ex2) {
                            throwException = true;
                        }
                        if (!throwException) break block6;
                        String message = "Unable to obtain class for " + (String)classStr;
                        if (AttributeHandler.this.LOGGER.isLoggable(Level.INFO)) {
                            AttributeHandler.this.LOGGER.log(Level.INFO, message, ex);
                        }
                        throw new TagAttributeException(AttributeHandler.this.tag, AttributeHandler.this.name, message, (Throwable)ex);
                    }
                }
            }
            return result;
        }
    }
}

