/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.lifecycle.Phase;
import com.sun.faces.util.DebugUtil;
import com.sun.faces.util.FacesLogger;
import jakarta.faces.FacesException;
import jakarta.faces.application.Application;
import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PostRenderViewEvent;
import jakarta.faces.event.PreRenderViewEvent;
import jakarta.faces.view.ViewDeclarationLanguage;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RenderResponsePhase
extends Phase {
    private static Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();

    @Override
    public void execute(FacesContext facesContext) throws FacesException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Entering RenderResponsePhase");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("About to render view " + facesContext.getViewRoot().getViewId());
        }
        facesContext.getPartialViewContext();
        try {
            boolean viewIdsUnchanged;
            ViewHandler vh = facesContext.getApplication().getViewHandler();
            ViewDeclarationLanguage vdl = vh.getViewDeclarationLanguage(facesContext, facesContext.getViewRoot().getViewId());
            if (vdl != null) {
                vdl.buildView(facesContext, facesContext.getViewRoot());
            }
            Application application = facesContext.getApplication();
            do {
                String beforePublishViewId = facesContext.getViewRoot().getViewId();
                application.publishEvent(facesContext, PreRenderViewEvent.class, (Object)facesContext.getViewRoot());
                String afterPublishViewId = facesContext.getViewRoot().getViewId();
                boolean bl = viewIdsUnchanged = beforePublishViewId == null && afterPublishViewId == null || beforePublishViewId != null && afterPublishViewId != null && beforePublishViewId.equals(afterPublishViewId);
                if (!facesContext.getResponseComplete()) continue;
                return;
            } while (!viewIdsUnchanged);
            vh.renderView(facesContext, facesContext.getViewRoot());
            application.publishEvent(facesContext, PostRenderViewEvent.class, (Object)facesContext.getViewRoot());
        }
        catch (IOException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "+=+=+=+=+=+= View structure printout for " + facesContext.getViewRoot().getViewId());
            DebugUtil.printTree((UIComponent)facesContext.getViewRoot(), LOGGER, Level.FINEST);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Exiting RenderResponsePhase");
        }
    }

    @Override
    public PhaseId getId() {
        return PhaseId.RENDER_RESPONSE;
    }
}

